/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Font;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class LanguageInfo {
    private final String languageCode;
    private final String countryCode;
    private final String variantCode;
    private final String display;
    private final String countryName;
    private final String variantName;

    public LanguageInfo(String lc, String cc, String vc, String ln, String cn, String vn) {
        this.languageCode = lc.trim();
        this.countryCode = cc.trim();
        this.variantCode = vc.trim();
        this.display = ln.trim();
        this.countryName = cn.trim();
        this.variantName = vn.trim();
    }

    public Locale toLocale() {
        return new Locale(this.languageCode, this.countryCode, this.variantCode);
    }

    public boolean matches(String[] codes) {
        String lc = codes[0];
        String cc = codes[1];
        String vc = codes[2];
        if (lc == null) {
            lc = "";
        }
        if (cc == null) {
            cc = "";
        }
        if (vc == null) {
            vc = "";
        }
        return this.languageCode.equals(lc) && this.countryCode.equals(cc) && this.variantCode.equals(vc);
    }

    public boolean matches(LanguageInfo lang) {
        return this.matches(new String[]{lang.languageCode, lang.countryCode, lang.variantCode});
    }

    public boolean isCurrent() {
        String lc = ApplicationSettings.LANGUAGE.getValue();
        String cc = ApplicationSettings.COUNTRY.getValue();
        String lv = ApplicationSettings.LOCALE_VARIANT.getValue();
        boolean isLV = lv == null || lv.equals("") || lv.equals(this.variantCode);
        boolean isCC = cc == null || cc.equals("") || cc.equals(this.countryCode);
        boolean isLC = (lc == null || lc.equals("")) && this.languageCode.equals("en") || lc.equals(this.languageCode);
        return isLV && isCC && isLC;
    }

    public void apply() {
        ApplicationSettings.LANGUAGE.setValue(this.languageCode);
        ApplicationSettings.COUNTRY.setValue(this.countryCode);
        ApplicationSettings.LOCALE_VARIANT.setValue(this.variantCode);
        GUIMediator.resetLocale();
    }

    public String toString() {
        return LanguageInfo.displayize(this.variantName, this.countryName, this.display);
    }

    public static String getCurrentDisplay() {
        String vn = GUIMediator.getStringResource("LOCALE_VARIANT_NAME");
        String cn = GUIMediator.getStringResource("LOCALE_COUNTRY_NAME");
        String ln = GUIMediator.getStringResource("LOCALE_LANGUAGE_NAME");
        return LanguageInfo.displayize(vn, cn, ln);
    }

    private static String displayize(String vn, String cn, String ln) {
        if (vn != null && !vn.toLowerCase().equals("international") && !vn.equals("")) {
            return ln + ", " + vn + " (" + cn + ")";
        }
        return ln + " (" + cn + ")";
    }

    public static LanguageInfo getEnglish() {
        return new LanguageInfo("en", "US", "", "English", "United States", "");
    }

    public static LanguageInfo[] getLanguages(Font font) {
        List langs = null;
        langs = CommonUtils.isTestingVersion() ? LanguageInfo.getLanguagesFromDisk() : LanguageInfo.getLanguagesFromJar();
        langs.add(0, LanguageInfo.getEnglish());
        if (font != null && !CommonUtils.isMacOSX()) {
            Iterator i = langs.iterator();
            while (i.hasNext()) {
                if (GUIUtils.canDisplay(font, i.next().toString())) continue;
                i.remove();
            }
        }
        return langs.toArray(new LanguageInfo[langs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List getLanguagesFromJar() {
        LinkedList langs = new LinkedList();
        File jar = CommonUtils.getResourceFile("MessagesBundles.jar");
        if (!jar.exists()) {
            return langs;
        }
        ZipFile zip = null;
        zip = new ZipFile(jar);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            String name = entries.nextElement().getName();
            if (!name.startsWith("MessagesBundle_") || name.indexOf("_en") != -1 || !name.endsWith(".properties")) continue;
            InputStream in = CommonUtils.getResourceStream(name);
            LanguageInfo.loadFile(langs, in);
        }
        Object var7_7 = null;
        if (zip == null) return langs;
        try {
            zip.close();
            return langs;
        }
        catch (IOException ioe) {}
        return langs;
        {
            catch (IOException iOException) {
                Object var7_8 = null;
                if (zip == null) return langs;
                try {
                    zip.close();
                    return langs;
                }
                catch (IOException ioe) {}
                return langs;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (zip == null) throw throwable;
            try {
                zip.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static List getLanguagesFromDisk() {
        LinkedList langs = new LinkedList();
        File lib = new File("../lib/messagebundles");
        if (!lib.isDirectory()) {
            return langs;
        }
        String[] files = lib.list();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].startsWith("MessagesBundle_") || files[i].indexOf("_en") != -1 || !files[i].endsWith(".properties")) continue;
            try {
                FileInputStream in = new FileInputStream(new File(lib, files[i]));
                LanguageInfo.loadFile(langs, in);
                continue;
            }
            catch (FileNotFoundException fnfe) {
                // empty catch block
            }
        }
        return langs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadFile(List langs, InputStream in) {
        Properties p = new Properties();
        in = new BufferedInputStream(in);
        p.load(in);
        String lc = p.getProperty("LOCALE_LANGUAGE_CODE");
        String cc = p.getProperty("LOCALE_COUNTRY_CODE");
        String vc = p.getProperty("LOCALE_VARIANT_CODE");
        String ln = p.getProperty("LOCALE_LANGUAGE_NAME");
        String cn = p.getProperty("LOCALE_COUNTRY_NAME");
        String vn = p.getProperty("LOCALE_VARIANT_NAME");
        langs.add(new LanguageInfo(lc, cc, vc, ln, cn, vn));
        Object var10_12 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (IOException ioe) {}
        return;
        {
            catch (IOException ignored) {
                Object var10_13 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException ioe) {}
                return;
            }
            catch (IllegalArgumentException ignored) {
                Object var10_14 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException ioe) {}
                return;
            }
            catch (NullPointerException nullPointerException) {
                Object var10_15 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException ioe) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        LanguageInfo lang = (LanguageInfo)obj;
        String countryStr1 = this.languageCode + this.countryCode + this.variantCode + this.countryName + this.variantName;
        String countryStr2 = lang.languageCode + lang.countryCode + lang.variantCode + lang.countryName + lang.variantName;
        return countryStr1.equals(countryStr2);
    }

    public String getDisplay() {
        return this.display;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getVariantCode() {
        return this.variantCode;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public String getVariantName() {
        return this.variantName;
    }
}

