/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.LanguageFlagFactory;
import com.limegroup.gnutella.gui.LanguageInfo;
import com.limegroup.gnutella.gui.StatusComponent;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.settings.StatusBarSettings;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class LanguageWindow
extends JDialog {
    public LanguageWindow() {
        super(GUIMediator.getAppFrame());
        this.setWindowProperties();
        Font font = new Font("Dialog", 0, 11);
        this.createWindow(font, null, null);
    }

    private void setWindowProperties() {
        this.setModal(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        GUIUtils.addHideAction(this);
    }

    private void createWindow(final Font font, final LanguageInfo[] langs, final LanguageInfo selected) {
        JButton right;
        JButton left;
        JComboBox combo;
        JComponent topComponent;
        this.setTitle(GUIMediator.getLocalizedResource("MENU_VIEW_LANGS_TITLE", selected));
        final JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        LanguageInfo currentLanguage = null;
        if (langs == null) {
            StatusComponent waiter = new StatusComponent(2);
            waiter.setText("    " + GUIMediator.getStringResource("LANGUAGE_LOADING") + "...    ");
            GUIMediator.instance().schedule(new Runnable(){

                public void run() {
                    LanguageInfo[] loaded = LanguageInfo.getLanguages(font);
                    SwingUtilities.invokeLater(new Runnable(this, loaded){
                        private final /* synthetic */ LanguageInfo[] val$loaded;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$loaded = val$loaded;
                        }

                        public void run() {
                            1.access$100(this.this$1).remove(1.access$000(this.this$1));
                            LanguageWindow.access$400(1.access$100(this.this$1), 1.access$200(this.this$1), this.val$loaded, 1.access$300(this.this$1));
                        }
                    });
                }

                static /* synthetic */ JPanel access$000(1 x0) {
                    return x0.panel;
                }

                static /* synthetic */ LanguageWindow access$100(1 x0) {
                    return x0.LanguageWindow.this;
                }

                static /* synthetic */ Font access$200(1 x0) {
                    return x0.font;
                }

                static /* synthetic */ LanguageInfo access$300(1 x0) {
                    return x0.selected;
                }
            });
            topComponent = waiter;
            combo = null;
        } else {
            combo = new JComboBox();
            combo.setRenderer(LanguageFlagFactory.getListRenderer());
            topComponent = combo;
            combo.setMaximumRowCount(15);
            combo.setFont(font);
            currentLanguage = null;
            DefaultComboBoxModel<LanguageInfo> model = new DefaultComboBoxModel<LanguageInfo>();
            int current = -1;
            for (int i = 0; i < langs.length; ++i) {
                model.addElement(langs[i]);
                if (langs[i].isCurrent()) {
                    currentLanguage = langs[i];
                    if (selected == null) {
                        current = i;
                    }
                }
                if (selected != langs[i]) continue;
                current = i;
            }
            combo.setModel(model);
            if (current != -1) {
                combo.setSelectedIndex(current);
            }
            combo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    LanguageInfo lang;
                    if (e.getStateChange() == 1 && selected != (lang = (LanguageInfo)e.getItem())) {
                        LanguageWindow.this.remove(panel);
                        LanguageWindow.this.createWindow(font, langs, lang);
                    }
                }
            });
        }
        gbc.insets = new Insets(15, 15, 0, 15);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 0;
        panel.add(topComponent, gbc);
        LanguageInfo english = LanguageInfo.getEnglish();
        boolean addEnglishButton = currentLanguage != null && !english.matches(currentLanguage);
        URLLabel helpTranslate = new URLLabel("http://www.limewire.org/translate.shtml", GUIMediator.getLocalizedResource("MENU_VIEW_LANGS_TRANSLATE_LIMEWIRE", selected));
        gbc.gridwidth = addEnglishButton ? 1 : 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(15, 15, 25, 0);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        helpTranslate.setFont(font);
        panel.add((Component)helpTranslate, gbc);
        final JCheckBox showLanguage = new JCheckBox(GUIMediator.getLocalizedResource("STATUS_BAR_SHOW_LANGUAGE_STATUS", selected));
        if (addEnglishButton) {
            JButton useEnglish = new JButton("Use English");
            useEnglish.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LanguageWindow.this.switchLanguage(LanguageInfo.getEnglish(), showLanguage.isSelected());
                }
            });
            gbc.insets = new Insets(15, 15, 25, 15);
            gbc.gridwidth = 0;
            gbc.anchor = 13;
            panel.add((Component)useEnglish, gbc);
        }
        showLanguage.setFont(font);
        showLanguage.setSelected(StatusBarSettings.LANGUAGE_DISPLAY_ENABLED.getValue());
        gbc.gridwidth = 1;
        gbc.gridheight = 0;
        gbc.anchor = 16;
        gbc.insets = new Insets(0, 15, 5, 5);
        gbc.weightx = 1.0;
        panel.add((Component)showLanguage, gbc);
        JButton ok = new JButton(GUIMediator.getLocalizedResource("GENERAL_OK_BUTTON_LABEL", selected));
        JButton cancel = new JButton(GUIMediator.getLocalizedResource("GENERAL_CANCEL_BUTTON_LABEL", selected));
        ok.setFont(font);
        cancel.setFont(font);
        cancel.addActionListener(GUIUtils.getDisposeAction());
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (combo != null) {
                    LanguageInfo lang = (LanguageInfo)combo.getSelectedItem();
                    LanguageWindow.this.switchLanguage(lang, showLanguage.isSelected());
                }
            }
        });
        if (!CommonUtils.isMacOSX()) {
            left = ok;
            right = cancel;
        } else {
            left = cancel;
            right = ok;
        }
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.anchor = 14;
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        panel.add((Component)left, gbc);
        gbc.insets = new Insets(0, 5, 5, 15);
        gbc.gridwidth = 0;
        panel.add((Component)right, gbc);
        this.getContentPane().add(panel);
        this.pack();
        if (combo != null) {
            combo.requestFocus();
        }
    }

    private void switchLanguage(LanguageInfo lang, boolean showStatus) {
        if (lang != null && !lang.isCurrent()) {
            lang.apply();
            GUIMediator.instance().getStatusLine().updateLanguage();
            GUIMediator.showMessage("MENU_VIEW_LANGS_RESTART_REQUIRED");
        }
        StatusBarSettings.LANGUAGE_DISPLAY_ENABLED.setValue(showStatus);
        if (LanguageInfo.getEnglish().matches(lang)) {
            StatusBarSettings.LANGUAGE_DISPLAY_ENGLISH_ENABLED.setValue(showStatus);
        }
        GUIMediator.instance().getStatusLine().refresh();
        this.dispose();
    }
}

