/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.Initializer;
import com.limegroup.gnutella.gui.PackagedMediaFileLauncher;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import net.roydesign.event.ApplicationEvent;
import net.roydesign.mac.MRJAdapter;

public class MacEventHandler {
    private static MacEventHandler INSTANCE;

    public static synchronized MacEventHandler instance() {
        if (INSTANCE == null) {
            INSTANCE = new MacEventHandler();
        }
        return INSTANCE;
    }

    private MacEventHandler() {
        MRJAdapter.addAboutListener((ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MacEventHandler.this.handleAbout();
            }
        });
        MRJAdapter.addQuitApplicationListener((ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MacEventHandler.this.handleQuit();
            }
        });
        MRJAdapter.addOpenDocumentListener((ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                File file = ((ApplicationEvent)evt).getFile();
                MacEventHandler.this.handleOpenFile(file);
            }
        });
        MRJAdapter.addReopenApplicationListener((ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MacEventHandler.this.handleReopen();
            }
        });
    }

    public void enablePreferences() {
        MRJAdapter.setPreferencesEnabled((boolean)true);
        MRJAdapter.addPreferencesListener((ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MacEventHandler.this.handlePreferences();
            }
        });
    }

    private void handleAbout() {
        GUIMediator.showAboutWindow();
    }

    private void handleQuit() {
        GUIMediator.applyWindowSettings();
        GUIMediator.close(false);
    }

    private void handleOpenFile(File file) {
        String filename = file.toString();
        if (filename.endsWith("limestart")) {
            Initializer.setStartup();
        } else {
            PackagedMediaFileLauncher.launchFile(filename, false);
        }
    }

    private void handleReopen() {
        GUIMediator.handleReopen();
    }

    private void handlePreferences() {
        GUIMediator.instance().setOptionsVisible(true);
    }
}

