/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import [Ljava.lang.String;;
import com.limegroup.gnutella.gui.AWTSplashWindow;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;

public class Main {
    public static final String SPLASH_FILE = "412splashfree.png";

    public static void main(String[] args) {
        Frame splash = null;
        try {
            if (Main.isMacOSX()) {
                Class<?> clazz = Class.forName("com.limegroup.gnutella.gui.GURLHandler");
                Method getInstance = clazz.getMethod("getInstance", new Class[0]);
                Object gurl = getInstance.invoke(null, new Object[0]);
                Method register = gurl.getClass().getMethod("register", new Class[0]);
                register.invoke(gurl, new Object[0]);
            }
            if (args == null || args.length == 0) {
                splash = Main.showInitialSplash();
            }
            Class.forName("com.limegroup.gnutella.gui.GUILoader").getMethod("load", String;.class, Frame.class).invoke(null, args, splash);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static Frame showInitialSplash() {
        Frame splashFrame = null;
        Image image = null;
        File themeImage = new File(Main.getUserSettingsDir(), SPLASH_FILE);
        if (themeImage.exists()) {
            image = Toolkit.getDefaultToolkit().createImage(themeImage.getPath());
        } else {
            URL imageURL = Main.class.getResource("images/default_splash.png");
            if (imageURL != null) {
                image = Toolkit.getDefaultToolkit().createImage(imageURL);
            }
        }
        if (image != null) {
            splashFrame = AWTSplashWindow.splash(image);
        }
        return splashFrame;
    }

    private static File getUserSettingsDir() {
        File dir = new File(System.getProperty("user.home"));
        if (Main.isWindows()) {
            return Main.getWindowsSettingsDir(dir);
        }
        if (Main.isMacOSX()) {
            File f = new File(dir, "/Library/Preferences/LimeWire");
            if (new File(f, "useBrushedMetal").exists()) {
                System.setProperty("apple.awt.brushMetalLook", "true");
            }
            return f;
        }
        return new File(dir, ".limewire");
    }

    private static boolean isMacOSX() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.startsWith("mac os") && os.endsWith("x");
    }

    private static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("windows") != -1;
    }

    private static File getWindowsSettingsDir(File homeDir) {
        File tempSettingsDir;
        File settingsDir = new File(homeDir, ".limewire");
        String appdata = null;
        appdata = Main.isJava15OrLater() ? System.getProperty("LIMEWIRE_PREFS_DIR", System.getenv("APPDATA")) : System.getProperty("LIMEWIRE_PREFS_DIR", null);
        if ("%APPDATA%".equals(appdata)) {
            appdata = null;
        }
        if (appdata != null && appdata.length() > 0 && ((tempSettingsDir = new File(appdata, "LimeWire")).isDirectory() || !settingsDir.exists())) {
            return tempSettingsDir;
        }
        return settingsDir;
    }

    private static boolean isJava15OrLater() {
        String version = System.getProperty("java.version");
        return !version.startsWith("1.4") && !version.startsWith("1.3") && !version.startsWith("1.2") && !version.startsWith("1.1") && !version.startsWith("1.0");
    }
}

