/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.Console;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LogoPanel;
import com.limegroup.gnutella.gui.MonitorView;
import com.limegroup.gnutella.gui.PowerManager;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.StatusLine;
import com.limegroup.gnutella.gui.connection.ConnectionMediator;
import com.limegroup.gnutella.gui.download.DownloadMediator;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.menu.MenuMediator;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.playlist.PlaylistMediator;
import com.limegroup.gnutella.gui.search.MagnetClipboardListener;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.statistics.StatisticsMediator;
import com.limegroup.gnutella.gui.tabs.AbstractTab;
import com.limegroup.gnutella.gui.tabs.ConnectionsTab;
import com.limegroup.gnutella.gui.tabs.ConsoleTab;
import com.limegroup.gnutella.gui.tabs.LibraryPlayListTab;
import com.limegroup.gnutella.gui.tabs.MonitorUploadTab;
import com.limegroup.gnutella.gui.tabs.SearchDownloadTab;
import com.limegroup.gnutella.gui.tabs.Tab;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.gui.upload.UploadMediator;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.PlayerSettings;
import com.limegroup.gnutella.settings.SettingsHandler;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.LogUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TabbedPaneUI;

final class MainFrame
implements ComponentListener,
RefreshListener,
ThemeObserver {
    private final JTabbedPane TABBED_PANE = new JTabbedPane();
    private final SearchMediator SEARCH_MEDIATOR = new SearchMediator();
    private final DownloadMediator DOWNLOAD_MEDIATOR = DownloadMediator.instance();
    private final MonitorView MONITOR_VIEW = new MonitorView();
    private final UploadMediator UPLOAD_MEDIATOR = UploadMediator.instance();
    private final ConnectionMediator CONNECTION_MEDIATOR = ConnectionMediator.instance();
    private final LibraryMediator LIBRARY_MEDIATOR = LibraryMediator.instance();
    private final StatisticsMediator STATISTICS_MEDIATOR = StatisticsMediator.instance();
    private final OptionsMediator OPTIONS_MEDIATOR = OptionsMediator.instance();
    private final StatusLine STATUS_LINE = new StatusLine();
    private final MenuMediator MENU_MEDIATOR = MenuMediator.instance();
    private final JFrame FRAME;
    private boolean isDownloadViewVisible = false;
    private final LogoPanel LOGO_PANEL = new LogoPanel();
    private Tab[] TABS = null;
    private int height;
    private boolean isSearching = false;

    MainFrame(JFrame frame) {
        this.FRAME = frame;
        this.buildTabs();
        this.TABBED_PANE.setPreferredSize(new Dimension(10000, 10000));
        ImageIcon limeIcon = GUIMediator.getThemeImage("limeicon");
        this.FRAME.setIconImage(limeIcon.getImage());
        this.FRAME.addWindowListener(new WindowAdapter(){

            public void windowDeiconified(WindowEvent e) {
                if (!CommonUtils.supportsTray()) {
                    GUIMediator.restoreView();
                }
            }

            public void windowClosing(WindowEvent e) {
                Dimension dim = GUIMediator.getAppSize();
                Point loc = GUIMediator.getAppLocation();
                ApplicationSettings.APP_WIDTH.setValue(dim.width);
                ApplicationSettings.APP_HEIGHT.setValue(dim.height);
                ApplicationSettings.WINDOW_X.setValue(loc.x);
                ApplicationSettings.WINDOW_Y.setValue(loc.y);
                SettingsHandler.save();
                GUIMediator.close(true);
            }
        });
        this.FRAME.addComponentListener(this);
        this.FRAME.setDefaultCloseOperation(0);
        this.setFrameDimensions();
        for (int i = 0; i < this.TABS.length; ++i) {
            this.addTab(this.TABS[i]);
        }
        this.TABBED_PANE.setRequestFocusEnabled(false);
        this.TABBED_PANE.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                TabbedPaneUI ui = MainFrame.this.TABBED_PANE.getUI();
                int idx = ui.tabForCoordinate(MainFrame.this.TABBED_PANE, e.getX(), e.getY());
                if (idx != -1) {
                    idx = MainFrame.this.getTabIndex(idx);
                }
                if (idx != -1) {
                    MainFrame.this.TABS[idx].mouseClicked();
                }
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        if (!ApplicationSettings.MONITOR_VIEW_ENABLED.getValue()) {
            this.setTabVisible(1, false);
        }
        if (!ApplicationSettings.CONNECTION_VIEW_ENABLED.getValue()) {
            this.setTabVisible(2, false);
        }
        if (!ApplicationSettings.LIBRARY_VIEW_ENABLED.getValue()) {
            this.setTabVisible(3, false);
        }
        if (LogUtils.isLog4JAvailable() && !ApplicationSettings.CONSOLE_VIEW_ENABLED.getValue()) {
            this.setTabVisible(4, false);
        }
        this.FRAME.setJMenuBar(this.MENU_MEDIATOR.getMenuBar());
        JPanel contentPane = new JPanel();
        this.FRAME.setContentPane(contentPane);
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridx = 0;
        contentPane.add((Component)this.TABBED_PANE, gbc);
        gbc.weighty = 0.0;
        gbc.gridy = 1;
        gbc.fill = 2;
        contentPane.add((Component)this.STATUS_LINE.getComponent(), gbc);
        JLayeredPane layeredPane = JLayeredPane.getLayeredPaneAbove(this.TABBED_PANE);
        layeredPane.add(this.LOGO_PANEL, JLayeredPane.PALETTE_LAYER, 0);
        ThemeMediator.addThemeObserver(this);
        GUIMediator.addRefreshListener(this);
        this.updateLogoHeight();
        if (ApplicationSettings.MAGNET_CLIPBOARD_LISTENER.getValue()) {
            this.FRAME.addWindowListener(MagnetClipboardListener.getInstance());
        }
        PowerManager pm = new PowerManager();
        this.FRAME.addWindowListener(pm);
        GUIMediator.addRefreshListener(pm);
    }

    public void updateTheme() {
        this.FRAME.setJMenuBar(this.MENU_MEDIATOR.getMenuBar());
        this.LOGO_PANEL.updateTheme();
        this.setSearchIconLocation();
        this.updateLogoHeight();
    }

    private void updateLogoHeight() {
        Rectangle rect = this.TABBED_PANE.getUI().getTabBounds(this.TABBED_PANE, 0);
        Dimension ld = this.LOGO_PANEL.getPreferredSize();
        int height = ld.height + 4;
        this.height = Math.max(rect.height, height);
        if (rect.height < height) {
            this.TABBED_PANE.setBorder(BorderFactory.createEmptyBorder(height - rect.height, 0, 0, 0));
        } else {
            this.TABBED_PANE.setBorder(null);
        }
    }

    private void buildTabs() {
        ArrayList<AbstractTab> tabs = new ArrayList<AbstractTab>();
        tabs.add(new SearchDownloadTab(this.SEARCH_MEDIATOR, this.DOWNLOAD_MEDIATOR));
        tabs.add(new MonitorUploadTab(this.MONITOR_VIEW, this.UPLOAD_MEDIATOR));
        tabs.add(new ConnectionsTab(this.CONNECTION_MEDIATOR));
        tabs.add(new LibraryPlayListTab(this.LIBRARY_MEDIATOR));
        if (LogUtils.isLog4JAvailable()) {
            Console console = new Console();
            tabs.add(new ConsoleTab(console));
        }
        this.TABS = tabs.toArray(new Tab[0]);
    }

    private void addTab(Tab tab) {
        this.TABBED_PANE.addTab(tab.getTitle(), tab.getIcon(), tab.getComponent(), tab.getToolTip());
    }

    private void insertTab(Tab tab, int index) {
        this.TABBED_PANE.insertTab(tab.getTitle(), tab.getIcon(), tab.getComponent(), tab.getToolTip(), index);
        SwingUtilities.updateComponentTreeUI(this.TABBED_PANE);
        ThemeMediator.updateThemeObservers();
    }

    final void setSelectedIndex(int index) {
        int i = this.getTabIndex(index);
        if (i == -1) {
            return;
        }
        this.TABBED_PANE.setSelectedIndex(i);
    }

    void updateTabIcon(int index) {
        int i = this.getTabIndex(index);
        if (i == -1) {
            return;
        }
        this.TABBED_PANE.setIconAt(i, this.TABS[index].getIcon());
    }

    private final void setFrameDimensions() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int locX = 0;
        int locY = 0;
        int appWidth = Math.min(screenSize.width - insets.left - insets.right, ApplicationSettings.APP_WIDTH.getValue());
        int appHeight = Math.min(screenSize.height - insets.top - insets.bottom, ApplicationSettings.APP_HEIGHT.getValue());
        if (ApplicationSettings.RUN_ONCE.getValue()) {
            locX = Math.max(insets.left, ApplicationSettings.WINDOW_X.getValue());
            locY = Math.max(insets.top, ApplicationSettings.WINDOW_Y.getValue());
        } else {
            locX = (screenSize.width - appWidth) / 2;
            locY = (screenSize.height - appHeight) / 2;
        }
        if (locX + appWidth > screenSize.width) {
            locX = Math.max(insets.left, screenSize.width - insets.left - insets.right - appWidth);
        }
        if (locY + appHeight > screenSize.height) {
            locY = Math.max(insets.top, screenSize.height - insets.top - insets.bottom - appHeight);
        }
        this.FRAME.setLocation(locX, locY);
        this.FRAME.setSize(new Dimension(appWidth, appHeight));
        this.FRAME.getContentPane().setSize(new Dimension(appWidth, appHeight));
        ((JComponent)this.FRAME.getContentPane()).setPreferredSize(new Dimension(appWidth, appHeight));
    }

    void setTabVisible(int TAB_INDEX, boolean VISIBLE) {
        if (TAB_INDEX == 0 || TAB_INDEX > this.TABS.length - 1) {
            throw new IllegalArgumentException("Invalid tab index: " + TAB_INDEX);
        }
        Tab tab = this.TABS[TAB_INDEX];
        JComponent comp = tab.getComponent();
        int tabCount = this.TABBED_PANE.getTabCount();
        if (!VISIBLE) {
            for (int i = 0; i < tabCount; ++i) {
                if (!comp.equals(this.TABBED_PANE.getComponentAt(i))) continue;
                this.TABBED_PANE.remove(i);
                break;
            }
        } else {
            JComponent selComp = (JComponent)this.TABBED_PANE.getSelectedComponent();
            selComp.setVisible(false);
            for (int i = 0; i < tabCount; ++i) {
                Component comp1 = this.TABBED_PANE.getComponentAt(i);
                int index = this.getIndex(comp1);
                if (index == -1) {
                    selComp.setVisible(true);
                    return;
                }
                if (index > TAB_INDEX) {
                    this.insertTab(this.TABS[TAB_INDEX], i);
                    break;
                }
                if (i != tabCount - 1) continue;
                this.insertTab(this.TABS[TAB_INDEX], i + 1);
            }
            JComponent jcomp = comp;
            jcomp.invalidate();
            jcomp.revalidate();
            jcomp.repaint();
        }
        this.MENU_MEDIATOR.setNavMenuItemEnabled(TAB_INDEX, VISIBLE);
        tab.storeState(VISIBLE);
    }

    private int getIndex(Component comp) {
        for (int i = 0; i < this.TABS.length; ++i) {
            if (!comp.equals(this.TABS[i].getComponent())) continue;
            return this.TABS[i].getIndex();
        }
        return -1;
    }

    private int getTabIndex(int index) {
        int tabCount = this.TABBED_PANE.getTabCount();
        JComponent comp = this.TABS[index].getComponent();
        for (int i = 0; i < tabCount; ++i) {
            Component tabComp = this.TABBED_PANE.getComponentAt(i);
            if (!tabComp.equals(comp)) continue;
            return i;
        }
        return -1;
    }

    public void refresh() {
        int count;
        SearchDownloadTab tab;
        if (this.isSearching && (tab = (SearchDownloadTab)this.TABS[0]).getDividerLocation() == 0) {
            tab.setDividerLocation(0.5);
            this.isDownloadViewVisible = true;
        }
        if (this.DOWNLOAD_MEDIATOR.getActiveDownloads() == 0 && this.isDownloadViewVisible) {
            ((SearchDownloadTab)this.TABS[0]).setDividerLocation(1000);
            this.isDownloadViewVisible = false;
        } else if (this.DOWNLOAD_MEDIATOR.getActiveDownloads() > 0 && !this.isDownloadViewVisible && (count = this.DOWNLOAD_MEDIATOR.getActiveDownloads()) > 0) {
            double prop = count > 6 ? 0.6 : 0.7;
            ((SearchDownloadTab)this.TABS[0]).setDividerLocation(prop);
            ((SearchDownloadTab)this.TABS[0]).getComponent().revalidate();
            this.TABBED_PANE.revalidate();
            this.isDownloadViewVisible = true;
        }
    }

    final SearchMediator getSearchMediator() {
        return this.SEARCH_MEDIATOR;
    }

    final DownloadMediator getDownloadMediator() {
        return this.DOWNLOAD_MEDIATOR;
    }

    final MonitorView getMonitorView() {
        return this.MONITOR_VIEW;
    }

    final UploadMediator getUploadMediator() {
        return this.UPLOAD_MEDIATOR;
    }

    final ConnectionMediator getConnectionMediator() {
        return this.CONNECTION_MEDIATOR;
    }

    final LibraryMediator getLibraryMediator() {
        return this.LIBRARY_MEDIATOR;
    }

    static final PlaylistMediator getPlaylistMediator() {
        return PlayerSettings.PLAYER_ENABLED.getValue() ? PlaylistMediator.instance() : null;
    }

    final StatusLine getStatusLine() {
        return this.STATUS_LINE;
    }

    final MenuMediator getMenuMediator() {
        return this.MENU_MEDIATOR;
    }

    final OptionsMediator getOptionsMediator() {
        return this.OPTIONS_MEDIATOR;
    }

    final StatisticsMediator getStatisticsMediator() {
        return this.STATISTICS_MEDIATOR;
    }

    final void setSearching(boolean searching) {
        this.LOGO_PANEL.setSearching(searching);
        this.isSearching = searching;
        this.refresh();
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.setSearchIconLocation();
    }

    public void componentShown(ComponentEvent e) {
        this.setSearchIconLocation();
    }

    private void setSearchIconLocation() {
        int y = this.MENU_MEDIATOR.getMenuBarHeight() + (this.height - this.LOGO_PANEL.getPreferredSize().height) / 2;
        this.LOGO_PANEL.setLocation(this.FRAME.getSize().width - this.LOGO_PANEL.getSize().width - 12, y);
    }
}

