/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.BufferListModel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MonitorView
extends JPanel
implements ThemeObserver {
    private JCheckBox showQueriesCheckBox;
    private JTextField listSizeTextField;
    private JList listOfQueries;
    private JScrollPane scrollPane;
    private int listFixedSize;
    private static final int LIST_FIXED_SIZE_DEFAULT = 32;
    private boolean bypassCountChange = false;
    private BufferListModel model = new BufferListModel(32);

    public MonitorView() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_MONITOR_WINDOW"));
        int pad = 6;
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        this.showQueriesCheckBox = new JCheckBox(GUIMediator.getStringResource("MONITOR_VIEW_INCOMING_SEARCHES"));
        this.showQueriesCheckBox.setPreferredSize(new Dimension(200, 20));
        this.showQueriesCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (MonitorView.this.listOfQueries != null) {
                    MonitorView.this.listOfQueries.setEnabled(MonitorView.this.showQueriesCheckBox.isSelected());
                }
                if (MonitorView.this.listSizeTextField != null) {
                    MonitorView.this.listSizeTextField.setEnabled(MonitorView.this.showQueriesCheckBox.isSelected());
                }
                if (e.getStateChange() == 1 && RouterService.isShieldedLeaf()) {
                    GUIMediator.showMessage("MONITOR_VIEW_LEAF_MESSAGE", QuestionsHandler.MONITOR_VIEW);
                }
            }
        });
        this.showQueriesCheckBox.setSelected(UISettings.UI_MONITOR_SHOW_INCOMING_SEARCHES.getValue());
        controlPanel.add(this.showQueriesCheckBox);
        controlPanel.add(Box.createHorizontalGlue());
        controlPanel.add(new JLabel(GUIMediator.getStringResource("MONITOR_VIEW_SHOW_LAST")));
        controlPanel.add(Box.createHorizontalStrut(pad / 2));
        this.listFixedSize = 32;
        this.listSizeTextField = new WholeNumberField(this.listFixedSize, 3);
        Dimension d = new Dimension(16, 24);
        this.listSizeTextField.setPreferredSize(d);
        this.listSizeTextField.setMaximumSize(d);
        this.listSizeTextField.setEnabled(this.showQueriesCheckBox.isSelected());
        this.listSizeTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                MonitorView.this.handleCountChange();
            }

            public void removeUpdate(DocumentEvent e) {
                MonitorView.this.handleCountChange();
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
        controlPanel.add(this.listSizeTextField);
        controlPanel.add(Box.createHorizontalStrut(pad / 2));
        controlPanel.add(new JLabel(GUIMediator.getStringResource("MONITOR_VIEW_SEARCHES")));
        this.listOfQueries = new JList(this.model);
        this.listOfQueries.setPrototypeCellValue("                                      ");
        this.listOfQueries.setFixedCellHeight(16);
        this.listOfQueries.setEnabled(this.showQueriesCheckBox.isSelected());
        this.listOfQueries.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int index;
                if (e.getClickCount() >= 2 && (index = MonitorView.this.listOfQueries.locationToIndex(e.getPoint())) != -1) {
                    String str = (String)MonitorView.this.model.getElementAt(index);
                    GUIMediator.instance().triggerSearch(str);
                }
            }
        });
        this.scrollPane = new JScrollPane(this.listOfQueries);
        this.scrollPane.setPreferredSize(new Dimension(340, 180));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(pad, pad, pad, pad);
        gbc.gridy = 0;
        this.add((Component)controlPanel, gbc);
        gbc.gridy = 1;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, pad, pad, pad);
        this.add((Component)this.scrollPane, gbc);
        this.updateTheme();
        ThemeMediator.addThemeObserver(this);
    }

    public void updateTheme() {
        Color tableColor = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
        this.scrollPane.getViewport().setBackground(tableColor);
        this.listOfQueries.setBackground(tableColor);
    }

    private void handleCountChange() {
        if (this.bypassCountChange) {
            return;
        }
        String val = this.listSizeTextField.getText();
        if (val != null && !val.equals("")) {
            int size = Integer.parseInt(val);
            if (size > 1000) {
                this.listFixedSize = 32;
                Runnable runner = new Runnable(){

                    public void run() {
                        MonitorView.this.bypassCountChange = true;
                        MonitorView.this.listSizeTextField.setText(String.valueOf(MonitorView.this.listFixedSize));
                        MonitorView.this.bypassCountChange = false;
                    }
                };
                SwingUtilities.invokeLater(runner);
            } else {
                this.listFixedSize = size;
            }
            this.model.changeSize(this.listFixedSize);
            this.scrollPane.validate();
        }
    }

    public void handleQueryString(String query) {
        if (!this.showQueriesCheckBox.isSelected()) {
            return;
        }
        if (query.length() == 0) {
            return;
        }
        char c = query.charAt(query.length() - 1);
        if (Character.isISOControl(c) || !Character.isDefined(c)) {
            query = query.substring(0, query.length() - 1);
        }
        this.model.addFirst(query);
    }
}

