/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.FileIconController;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.FileChooserUI;

public class NativeFileIconController
implements FileIconController {
    private final FileView VIEW;
    private final Map EXTENSIONS = new HashMap();
    private final Icon NULL = new ImageIcon();

    NativeFileIconController() {
        FileView view = this.getNativeFileView();
        if (view == null) {
            this.VIEW = null;
        } else {
            this.VIEW = new DelegateFileView(view);
            this.preload();
        }
    }

    boolean isIconAvailable() {
        return this.VIEW != null;
    }

    private FileView getNativeFileView() {
        JFileChooser chooser = null;
        for (int i = 0; i < 10; ++i) {
            try {
                chooser = new JFileChooser(){
                    {
                        FileChooserUI ui = (FileChooserUI)ResourceManager.getNativeUI(this);
                        this.setUI(ui);
                        this.setFileView(ui.getFileView(this));
                    }
                };
                break;
            }
            catch (NullPointerException nullPointerException) {
                continue;
            }
        }
        if (chooser != null) {
            return chooser.getFileView();
        }
        return null;
    }

    public Icon getIconForFile(File f) {
        if (f == null) {
            return null;
        }
        if (f.exists()) {
            return this.VIEW.getIcon(f);
        }
        String extension = FileUtils.getFileExtension(f);
        if (extension != null) {
            return this.getIconForExtension(extension);
        }
        return null;
    }

    public Icon getIconForExtension(String ext) {
        Icon icon = (Icon)this.EXTENSIONS.get(ext = ext.trim().toLowerCase());
        if (icon != null) {
            if (icon != this.NULL) {
                return icon;
            }
            return null;
        }
        File dir = SharingSettings.INCOMPLETE_DIRECTORY.getValue();
        File tmp = new File(dir, ".LimeWireIconFinder." + ext);
        if (tmp.exists()) {
            icon = this.VIEW.getIcon(tmp);
        } else {
            try {
                FileUtils.touch(tmp);
                icon = this.VIEW.getIcon(tmp);
                if (icon == null) {
                    icon = this.NULL;
                }
            }
            catch (IOException fnfe) {
                icon = this.NULL;
            }
        }
        tmp.delete();
        this.EXTENSIONS.put(ext, icon);
        return icon;
    }

    private void preload() {
        ProcessingQueue queue = new ProcessingQueue("IconLoader");
        MediaType[] types = MediaType.getDefaultMediaTypes();
        for (int i = 0; i < types.length; ++i) {
            Set exts = types[i].getExtensions();
            Iterator j = exts.iterator();
            while (j.hasNext()) {
                final String next = (String)j.next();
                queue.add(new Runnable(){

                    public void run() {
                        GUIMediator.safeInvokeAndWait(new Runnable(this){
                            private final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                2.access$100(this.this$1).getIconForExtension(2.access$000(this.this$1));
                            }
                        });
                    }

                    static /* synthetic */ String access$000(2 x0) {
                        return x0.next;
                    }

                    static /* synthetic */ NativeFileIconController access$100(2 x0) {
                        return x0.NativeFileIconController.this;
                    }
                });
            }
        }
    }

    private static class DelegateFileView
    extends FileView {
        private final FileView DELEGATE;

        DelegateFileView(FileView real) {
            this.DELEGATE = real;
        }

        public Icon getIcon(File f) {
            try {
                return this.DELEGATE.getIcon(f);
            }
            catch (NullPointerException npe) {
                return null;
            }
        }

        public String getDescription(File f) {
            return this.DELEGATE.getDescription(f);
        }

        public String getName(File f) {
            return this.DELEGATE.getName(f);
        }

        public String getTypeDescription(File f) {
            return this.DELEGATE.getTypeDescription(f);
        }

        public Boolean isTraversable(File f) {
            return this.DELEGATE.isTraversable(f);
        }
    }
}

