/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.event.HyperlinkListener;

public final class ScrollingTextPane
extends JScrollPane {
    private final JEditorPane EDITOR_PANE;
    protected Timer _timer;

    public ScrollingTextPane(String html) {
        if (html == null) {
            throw new NullPointerException("null html");
        }
        this.EDITOR_PANE = new JEditorPane("text/html", html);
        this.EDITOR_PANE.setMargin(new Insets(5, 5, 5, 5));
        this.EDITOR_PANE.setEditable(false);
        this.getViewport().add(this.EDITOR_PANE);
        this.setDoubleBuffered(true);
        AbstractAction scrollText = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ScrollingTextPane.this.scroll();
            }
        };
        this._timer = new Timer(50, scrollText);
        this.EDITOR_PANE.setCaretPosition(0);
    }

    public void showFile(String FILE_NAME) {
        URL url = GUIMediator.getURLResource(FILE_NAME);
        if (url == null) {
            throw new NullPointerException("FILE COULD NOT BE LOADED");
        }
        try {
            this.EDITOR_PANE.setPage(url);
        }
        catch (IOException ioe) {
            throw new NullPointerException("FILE COULD NOT BE LOADED");
        }
    }

    public void startScroll() {
        this._timer.start();
    }

    public void stopScroll() {
        this._timer.stop();
    }

    protected void scroll() {
        Rectangle rect = this.EDITOR_PANE.getVisibleRect();
        int x = rect.x;
        int y = this.getVerticalScrollBar().getValue();
        if (y + rect.height >= this.EDITOR_PANE.getHeight()) {
            return;
        }
        Rectangle rectNew = new Rectangle(x, ++y, x + rect.width, y + rect.height);
        this.EDITOR_PANE.scrollRectToVisible(rectNew);
    }

    public void addHyperlinkListener(HyperlinkListener listener) {
        this.EDITOR_PANE.addHyperlinkListener(listener);
    }
}

