/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.LanguageButton;
import com.limegroup.gnutella.gui.LanguageInfo;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.StatusComponent;
import com.limegroup.gnutella.gui.StatusLinkHandler;
import com.limegroup.gnutella.gui.UpdatePanel;
import com.limegroup.gnutella.gui.mp3.MediaPlayerComponent;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.BooleanSetting;
import com.limegroup.gnutella.settings.PlayerSettings;
import com.limegroup.gnutella.settings.StatusBarSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.version.UpdateInformation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public final class StatusLine
implements ThemeObserver {
    public static final int STATUS_DISCONNECTED = 0;
    public static final int STATUS_CONNECTING = 1;
    public static final int STATUS_POOR = 2;
    public static final int STATUS_FAIR = 3;
    public static final int STATUS_GOOD = 4;
    public static final int STATUS_EXCELLENT = 5;
    public static final int STATUS_TURBOCHARGED = 6;
    public static final int STATUS_IDLE = 7;
    public static final int STATUS_WAKING_UP = 8;
    private final JPanel BAR = new JPanel(new GridBagLayout());
    private final JLabel _connectionQualityMeter = new JLabel();
    private final ImageIcon[] _connectionQualityMeterIcons = new ImageIcon[9];
    private final LanguageButton _languageButton = new LanguageButton();
    private final JLabel _firewallStatus = new JLabel();
    private final SharedFilesLabel _sharedFiles = new SharedFilesLabel();
    private final JLabel _bandwidthUsageDown = new JLabel(GUIMediator.getThemeImage("downloading_small"));
    private final JLabel _bandwidthUsageUp = new JLabel(GUIMediator.getThemeImage("uploading_small"));
    private final StatusComponent STATUS_COMPONENT = new StatusComponent(2);
    private final UpdatePanel _updatePanel = new UpdatePanel();
    private final StatusLinkHandler _statusLinkHandler = new StatusLinkHandler();
    private final JPanel _centerPanel = new JPanel(new GridBagLayout());
    private Component _centerComponent = this._updatePanel;
    private MediaPlayerComponent _mediaPlayer;
    private long _nextUpdateTime = System.currentTimeMillis();
    private final RefreshListener REFRESH_LISTENER = new RefreshListener(){

        public void refresh() {
            if (StatusBarSettings.BANDWIDTH_DISPLAY_ENABLED.getValue()) {
                StatusLine.this.updateBandwidth();
            }
            StatusLine.this.updateCenterPanel();
        }
    };
    private final MouseAdapter STATUS_BAR_LISTENER = new MouseAdapter(){

        public void mousePressed(MouseEvent me) {
            this.processMouseEvent(me);
        }

        public void mouseReleased(MouseEvent me) {
            this.processMouseEvent(me);
        }

        public void mouseClicked(MouseEvent me) {
            this.processMouseEvent(me);
        }

        public void processMouseEvent(MouseEvent me) {
            if (me.isPopupTrigger()) {
                JPopupMenu jpm = new JPopupMenu();
                JCheckBoxMenuItem jcbmi = new JCheckBoxMenuItem(new ShowConnectionQualityAction());
                jcbmi.setState(StatusBarSettings.CONNECTION_QUALITY_DISPLAY_ENABLED.getValue());
                jpm.add(jcbmi);
                jcbmi = new JCheckBoxMenuItem(new ShowLanguageStatusAction());
                jcbmi.setState(StatusLine.this.getLanguageSetting().getValue());
                jpm.add(jcbmi);
                jcbmi = new JCheckBoxMenuItem(new ShowFirewallStatusAction());
                jcbmi.setState(StatusBarSettings.FIREWALL_DISPLAY_ENABLED.getValue());
                jpm.add(jcbmi);
                jcbmi = new JCheckBoxMenuItem(new ShowSharedFilesCountAction());
                jcbmi.setState(StatusBarSettings.SHARED_FILES_DISPLAY_ENABLED.getValue());
                jpm.add(jcbmi);
                jcbmi = new JCheckBoxMenuItem(new ShowBandwidthConsumptionAction());
                jcbmi.setState(StatusBarSettings.BANDWIDTH_DISPLAY_ENABLED.getValue());
                jpm.add(jcbmi);
                jpm.addSeparator();
                jcbmi = new JCheckBoxMenuItem(new ShowMediaPlayerAction());
                jcbmi.setState(PlayerSettings.PLAYER_ENABLED.getValue());
                jpm.add(jcbmi);
                jpm.show(me.getComponent(), me.getX(), me.getY());
            }
        }
    };

    public StatusLine() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_STATUS_WINDOW"));
        GUIMediator.addRefreshListener(this.REFRESH_LISTENER);
        this.BAR.addMouseListener(this.STATUS_BAR_LISTENER);
        GUIMediator.getAppFrame().addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent arg0) {
                StatusLine.this.refresh();
            }

            public void componentMoved(ComponentEvent arg0) {
            }

            public void componentShown(ComponentEvent arg0) {
            }

            public void componentHidden(ComponentEvent arg0) {
            }
        });
        this.createConnectionQualityPanel();
        this.createLanguageButton();
        this.createFirewallLabel();
        this.createSharingFilesLabel();
        this.createBandwidthLabel();
        this.createCenterPanel();
        this.setConnectionQuality(0);
        ThemeMediator.addThemeObserver(this);
        this.refresh();
    }

    public void refresh() {
        int indicatorWidth;
        this.BAR.removeAll();
        int sepWidth = Math.max(2, this.createSeparator().getWidth());
        int remainingWidth = this.BAR.getWidth();
        if (remainingWidth <= 0) {
            remainingWidth = ApplicationSettings.APP_WIDTH.getValue();
        }
        if (GUIMediator.isPlaylistVisible()) {
            if (this._mediaPlayer == null) {
                this._mediaPlayer = MediaPlayerComponent.instance();
            }
            remainingWidth -= sepWidth;
            remainingWidth -= 3;
            remainingWidth -= Math.max(216, this._mediaPlayer.getMediaPanel().getWidth());
            remainingWidth -= 6;
        }
        if ((indicatorWidth = this._centerComponent.getWidth()) <= 0 && this._updatePanel.shouldBeShown()) {
            indicatorWidth = 190;
            if (!GUIMediator.hasDonated()) {
                indicatorWidth = 280;
            }
        }
        remainingWidth -= indicatorWidth;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 10;
        gbc.gridx = -1;
        indicatorWidth = 6 + Math.max((int)this._connectionQualityMeter.getMinimumSize().getWidth(), this._connectionQualityMeter.getWidth()) + sepWidth;
        if (StatusBarSettings.CONNECTION_QUALITY_DISPLAY_ENABLED.getValue() && remainingWidth > indicatorWidth) {
            this.BAR.add(Box.createHorizontalStrut(3), gbc);
            this.BAR.add((Component)this._connectionQualityMeter, gbc);
            this.BAR.add(Box.createHorizontalStrut(3), gbc);
            this.BAR.add(this.createSeparator(), gbc);
            remainingWidth -= indicatorWidth;
        }
        indicatorWidth = 6 + Math.max((int)this._languageButton.getMinimumSize().getWidth(), this._languageButton.getWidth()) + sepWidth;
        BooleanSetting languageSetting = this.getLanguageSetting();
        if (languageSetting.getValue() && remainingWidth > indicatorWidth) {
            this.BAR.add(Box.createHorizontalStrut(3), gbc);
            this.BAR.add((Component)this._languageButton, gbc);
            this.BAR.add(Box.createHorizontalStrut(3), gbc);
            this.BAR.add(this.createSeparator(), gbc);
            remainingWidth -= indicatorWidth;
        }
        indicatorWidth = 6 + Math.max((int)this._firewallStatus.getMinimumSize().getWidth(), this._firewallStatus.getWidth()) + sepWidth;
        if (StatusBarSettings.FIREWALL_DISPLAY_ENABLED.getValue() && remainingWidth > indicatorWidth) {
            this.BAR.add(Box.createHorizontalStrut(3), gbc);
            this.BAR.add((Component)this._firewallStatus, gbc);
            this.BAR.add(Box.createHorizontalStrut(3), gbc);
            this.BAR.add(this.createSeparator(), gbc);
            remainingWidth -= indicatorWidth;
        }
        indicatorWidth = 6 + Math.max((int)this._sharedFiles.getMinimumSize().getWidth(), this._sharedFiles.getWidth()) + sepWidth;
        if (StatusBarSettings.SHARED_FILES_DISPLAY_ENABLED.getValue() && remainingWidth > indicatorWidth) {
            this.BAR.add(Box.createHorizontalStrut(3), gbc);
            this.BAR.add((Component)this._sharedFiles, gbc);
            this.BAR.add(Box.createHorizontalStrut(3), gbc);
            this.BAR.add(this.createSeparator(), gbc);
            remainingWidth -= indicatorWidth;
        }
        indicatorWidth = 9 + sepWidth + Math.max((int)this._bandwidthUsageDown.getMinimumSize().getWidth(), this._bandwidthUsageDown.getWidth()) + Math.max((int)this._bandwidthUsageUp.getMinimumSize().getWidth(), this._bandwidthUsageUp.getWidth());
        if (StatusBarSettings.BANDWIDTH_DISPLAY_ENABLED.getValue() && remainingWidth > indicatorWidth) {
            this.BAR.add(Box.createHorizontalStrut(3), gbc);
            this.BAR.add((Component)this._bandwidthUsageDown, gbc);
            this.BAR.add(Box.createHorizontalStrut(6), gbc);
            this.BAR.add((Component)this._bandwidthUsageUp, gbc);
            this.BAR.add(Box.createHorizontalStrut(3), gbc);
            this.BAR.add(this.createSeparator(), gbc);
            remainingWidth -= indicatorWidth;
        }
        this.BAR.add(Box.createHorizontalStrut(3), gbc);
        gbc.weightx = 1.0;
        this.BAR.add((Component)this._centerPanel, gbc);
        gbc.weightx = 0.0;
        this.BAR.add(Box.createHorizontalStrut(3), gbc);
        if (GUIMediator.isPlaylistVisible()) {
            JPanel jp = this._mediaPlayer.getMediaPanel();
            jp.setOpaque(false);
            this.BAR.add(this.createSeparator(), gbc);
            this.BAR.add(Box.createHorizontalStrut(3), gbc);
            this.BAR.add((Component)jp, gbc);
            this.BAR.add(Box.createHorizontalStrut(6), gbc);
        }
        this.BAR.validate();
        this.BAR.repaint();
    }

    private Component createSeparator() {
        JSeparator sep = new JSeparator(1);
        sep.setPreferredSize(new Dimension(2, 20));
        sep.setMinimumSize(new Dimension(2, 20));
        return sep;
    }

    private void createConnectionQualityPanel() {
        this.updateTheme();
        this._connectionQualityMeter.setOpaque(false);
        this._connectionQualityMeter.setMinimumSize(new Dimension(34, 20));
        this._connectionQualityMeter.setMaximumSize(new Dimension(90, 30));
        this._connectionQualityMeter.addMouseListener(this.STATUS_BAR_LISTENER);
    }

    private void createSharingFilesLabel() {
        this._sharedFiles.setHorizontalAlignment(2);
        this._sharedFiles.setMinimumSize(new Dimension(24, 20));
        this._sharedFiles.addMouseListener(this.STATUS_BAR_LISTENER);
        this._sharedFiles.setToolTipText(GUIMediator.getStringResource("STATISTICS_SHARING_TOOLTIP") + " " + 0 + " " + GUIMediator.getStringResource("STATISTICS_FILES_TOOLTIP_PENDING"));
    }

    private void createLanguageButton() {
        this._languageButton.addMouseListener(this.STATUS_BAR_LISTENER);
        this.updateLanguage();
    }

    private void createFirewallLabel() {
        this.updateFirewall();
        this._firewallStatus.setMinimumSize(new Dimension(20, 20));
        this._firewallStatus.addMouseListener(this.STATUS_BAR_LISTENER);
    }

    private void createBandwidthLabel() {
        this.updateBandwidth();
        this._bandwidthUsageDown.setMinimumSize(new Dimension(60, 20));
        this._bandwidthUsageUp.setMinimumSize(new Dimension(60, 20));
        this._bandwidthUsageDown.addMouseListener(this.STATUS_BAR_LISTENER);
        this._bandwidthUsageUp.addMouseListener(this.STATUS_BAR_LISTENER);
    }

    private void createCenterPanel() {
        this._centerPanel.setOpaque(false);
        this._updatePanel.setOpaque(false);
        ((JComponent)this._statusLinkHandler.getComponent()).setOpaque(false);
        this.STATUS_COMPONENT.setProgressPreferredSize(new Dimension(250, 20));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 0;
        gbc.anchor = 10;
        this._centerPanel.add((Component)this.STATUS_COMPONENT, gbc);
        this._statusLinkHandler.getComponent().addMouseListener(this.STATUS_BAR_LISTENER);
        this._centerPanel.addMouseListener(this.STATUS_BAR_LISTENER);
        this._updatePanel.addMouseListener(this.STATUS_BAR_LISTENER);
        this.STATUS_COMPONENT.addMouseListener(this.STATUS_BAR_LISTENER);
    }

    private void updateCenterPanel() {
        long now = System.currentTimeMillis();
        if (this._nextUpdateTime > now) {
            return;
        }
        this._nextUpdateTime = now + 5000L;
        this._centerPanel.removeAll();
        this._centerComponent = GUIMediator.hasDonated() ? (this._updatePanel.shouldBeShown() ? this._updatePanel : new JLabel()) : (this._centerComponent == this._statusLinkHandler.getComponent() && this._updatePanel.shouldBeShown() ? this._updatePanel : this._statusLinkHandler.getComponent());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 10;
        this._centerPanel.add(this._centerComponent, gbc);
        this.refresh();
    }

    public void showUpdatePanel(boolean popup, UpdateInformation info) {
        this._updatePanel.makeVisible(popup, info);
    }

    void setStatusText(final String text) {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                StatusLine.this.STATUS_COMPONENT.setText(text);
            }
        });
    }

    public void updateFirewallLabel(boolean notFirewalled) {
        if (notFirewalled) {
            this._firewallStatus.setIcon(GUIMediator.getThemeImage("firewall_no"));
            this._firewallStatus.setToolTipText(GUIMediator.getStringResource("STATUS_BAR_FIREWALL_NOT_FOUND_TOOLTIP"));
        } else {
            this._firewallStatus.setIcon(GUIMediator.getThemeImage("firewall"));
            this._firewallStatus.setToolTipText(GUIMediator.getStringResource("STATUS_BAR_FIREWALL_FOUND_TOOLTIP"));
        }
    }

    public void updateLanguage() {
        this._languageButton.updateLanguageFlag();
    }

    public void updateFirewall() {
        this.updateFirewallLabel(RouterService.acceptedIncomingConnection());
    }

    public void updateBandwidth() {
        String sDown = GUIUtils.rate2speed(RouterService.getDownloadManager().getLastMeasuredBandwidth());
        String sUp = GUIUtils.rate2speed(RouterService.getUploadManager().getLastMeasuredBandwidth());
        int downloads = RouterService.getNumActiveDownloads();
        int uploads = RouterService.getNumUploads();
        this._bandwidthUsageDown.setText(downloads + " @ " + sDown);
        this._bandwidthUsageUp.setText(uploads + " @ " + sUp);
        String tooltip = "<html><table><tr><td>" + GUIMediator.getStringResource("OPTIONS_STATUS_BAR_BANDWIDTH_DOWNLOADS") + "</td><td>" + downloads + "</td><td>@</td><td align=right>" + sDown + "</td></tr>" + "<tr><td>" + GUIMediator.getStringResource("OPTIONS_STATUS_BAR_BANDWIDTH_UPLOADS") + "</td><td>" + uploads + "</td><td>@</td><td align=right>" + sUp + "</td></tr></table></html>";
        this._bandwidthUsageDown.setToolTipText(tooltip);
        this._bandwidthUsageUp.setToolTipText(tooltip);
    }

    void loadFinished() {
        this.updateCenterPanel();
        this._centerPanel.revalidate();
        this._centerPanel.repaint();
        this.refresh();
    }

    public void updateTheme() {
        for (int i = 0; i < this._connectionQualityMeterIcons.length; ++i) {
            this._connectionQualityMeterIcons[i] = GUIMediator.getThemeImage("connect_small_" + i);
        }
        if (this._mediaPlayer != null) {
            this._mediaPlayer.updateTheme();
        }
    }

    public void setConnectionQuality(int quality) {
        if (quality >= this._connectionQualityMeterIcons.length) {
            quality = this._connectionQualityMeterIcons.length - 1;
        }
        this._connectionQualityMeter.setIcon(this._connectionQualityMeterIcons[quality]);
        String status = null;
        String tip = null;
        String connection = GUIMediator.getStringResource("STATISTICS_CONNECTION_QUALITY");
        switch (quality) {
            case 0: {
                status = GUIMediator.getStringResource("STATISTICS_CONNECTION_DISCONNECTED");
                tip = GUIMediator.getStringResource("STATISTICS_CONNECTION_DISCONNECTED_TIP");
                break;
            }
            case 1: {
                status = GUIMediator.getStringResource("STATISTICS_CONNECTION_CONNECTING") + " " + connection;
                tip = GUIMediator.getStringResource("STATISTICS_CONNECTION_CONNECTING_TIP");
                break;
            }
            case 2: {
                status = GUIMediator.getStringResource("STATISTICS_CONNECTION_POOR") + " " + connection;
                tip = GUIMediator.getStringResource("STATISTICS_CONNECTION_POOR_TIP");
                break;
            }
            case 3: {
                status = GUIMediator.getStringResource("STATISTICS_CONNECTION_FAIR") + " " + connection;
                tip = GUIMediator.getStringResource("STATISTICS_CONNECTION_FAIR_TIP");
                break;
            }
            case 4: {
                status = GUIMediator.getStringResource("STATISTICS_CONNECTION_GOOD") + " " + connection;
                tip = GUIMediator.getStringResource("STATISTICS_CONNECTION_GOOD_TIP");
                break;
            }
            case 5: 
            case 7: {
                status = GUIMediator.getStringResource("STATISTICS_CONNECTION_EXCELLENT") + " " + connection;
                tip = GUIMediator.getStringResource("STATISTICS_CONNECTION_EXCELLENT_TIP");
                break;
            }
            case 6: {
                status = GUIMediator.getStringResource("STATISTICS_CONNECTION_TURBO_CHARGED") + " " + connection;
                tip = GUIMediator.getStringResource("STATISTICS_CONNECTION_TURBO_CHARGED_TIP_" + (CommonUtils.isPro() ? "PRO" : "FREE"));
                break;
            }
            case 8: {
                status = GUIMediator.getStringResource("STATISTICS_CONNECTION_WAKING_UP") + " " + connection;
                tip = GUIMediator.getStringResource("STATISTICS_CONNECTION_WAKING_UP_TIP");
            }
        }
        this._connectionQualityMeter.setToolTipText(tip);
        if (GUIMediator.hasDonated()) {
            this._connectionQualityMeter.setText(status);
        }
    }

    public void setStatistics(int share, int pending) {
        this._sharedFiles.update(share, pending);
    }

    public JComponent getComponent() {
        return this.BAR;
    }

    private BooleanSetting getLanguageSetting() {
        if (LanguageInfo.getEnglish().isCurrent()) {
            return StatusBarSettings.LANGUAGE_DISPLAY_ENGLISH_ENABLED;
        }
        return StatusBarSettings.LANGUAGE_DISPLAY_ENABLED;
    }

    private class SharedFilesLabel
    extends JLabel {
        private static final int _height = 20;
        private int _width = 26;
        private FontMetrics fm = null;
        private String _string = "0...";
        private int _share;
        private int _pending;

        private SharedFilesLabel() {
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            return new Dimension(this._width, 20);
        }

        public void update(int share, int pending) {
            boolean shareChanged = share != this._share;
            boolean pendingChanged = pending != this._pending;
            this._share = share;
            this._pending = pending;
            if (!shareChanged && !pendingChanged) {
                return;
            }
            this._string = GUIUtils.toLocalizedInteger(this._share);
            if (!RouterService.getFileManager().isLoadFinished() || RouterService.getFileManager().isUpdating()) {
                this._string = this._string + "...";
            }
            if (this.fm != null) {
                this._width = this.fm.stringWidth(this._string) + 20;
            }
            this.revalidate();
            this.repaint();
            if (RouterService.getFileManager().isLoadFinished()) {
                this.setToolTipText(GUIMediator.getStringResource("STATISTICS_SHARING_TOOLTIP") + " " + share + " " + GUIMediator.getStringResource("STATISTICS_FILES_TOOLTIP"));
            } else {
                this.setToolTipText(GUIMediator.getStringResource("STATISTICS_SHARING_TOOLTIP") + " " + share + " " + GUIMediator.getStringResource("STATISTICS_FILES_TOOLTIP_PENDING"));
            }
        }

        protected void paintComponent(Graphics g) {
            int width;
            Graphics2D g2 = (Graphics2D)g;
            RenderingHints rh = g2.getRenderingHints();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.fm == null) {
                this.fm = g2.getFontMetrics();
            }
            if (!RouterService.getFileManager().isLoadFinished() || RouterService.getFileManager().isUpdating()) {
                g2.setPaint(new Color(165, 165, 2));
                if (!this._string.endsWith("...")) {
                    this._string = this._string + "...";
                }
            } else {
                g2.setPaint(new Color(2, 137, 2));
                if (this._string.endsWith("...")) {
                    this._string = this._string.substring(0, this._string.length() - 3);
                }
            }
            if ((width = this.fm.stringWidth(this._string) + 20) != this._width) {
                this._width = width;
                this.revalidate();
            }
            RoundRectangle2D.Float rect = new RoundRectangle2D.Float(0.0f, 0.0f, this._width - 2, 18.0f, 20.0f, 20.0f);
            g2.fill(rect);
            g2.setColor(Color.black);
            g2.draw(rect);
            g2.setColor(Color.white);
            g2.drawString(this._string, (rect.width - (float)this.fm.stringWidth(this._string)) / 2.0f, (rect.height + (float)this.fm.getAscent() - (float)this.fm.getDescent()) / 2.0f);
            g2.setRenderingHints(rh);
        }
    }

    private class ShowMediaPlayerAction
    extends AbstractAction {
        public ShowMediaPlayerAction() {
            this.putValue("Name", GUIMediator.getStringResource("STATUS_BAR_SHOW_MEDIA_PLAYER"));
        }

        public void actionPerformed(ActionEvent e) {
            GUIMediator.instance().setPlayerEnabled(!PlayerSettings.PLAYER_ENABLED.getValue());
        }
    }

    private class ShowBandwidthConsumptionAction
    extends AbstractAction {
        public ShowBandwidthConsumptionAction() {
            this.putValue("Name", GUIMediator.getStringResource("STATUS_BAR_SHOW_BANDWIDTH_CONSUMPTION"));
        }

        public void actionPerformed(ActionEvent e) {
            StatusBarSettings.BANDWIDTH_DISPLAY_ENABLED.invert();
            StatusLine.this.refresh();
        }
    }

    private class ShowFirewallStatusAction
    extends AbstractAction {
        public ShowFirewallStatusAction() {
            this.putValue("Name", GUIMediator.getStringResource("STATUS_BAR_SHOW_FIREWALL_STATUS"));
        }

        public void actionPerformed(ActionEvent e) {
            StatusBarSettings.FIREWALL_DISPLAY_ENABLED.invert();
            StatusLine.this.refresh();
        }
    }

    private class ShowLanguageStatusAction
    extends AbstractAction {
        public ShowLanguageStatusAction() {
            this.putValue("Name", GUIMediator.getStringResource("STATUS_BAR_SHOW_LANGUAGE_STATUS"));
        }

        public void actionPerformed(ActionEvent e) {
            BooleanSetting setting = StatusLine.this.getLanguageSetting();
            setting.invert();
            StatusBarSettings.LANGUAGE_DISPLAY_ENABLED.setValue(setting.getValue());
            StatusBarSettings.LANGUAGE_DISPLAY_ENGLISH_ENABLED.setValue(setting.getValue());
            StatusLine.this.refresh();
        }
    }

    private class ShowSharedFilesCountAction
    extends AbstractAction {
        public ShowSharedFilesCountAction() {
            this.putValue("Name", GUIMediator.getStringResource("STATUS_BAR_SHOW_SHARED_FILES_COUNT"));
        }

        public void actionPerformed(ActionEvent e) {
            StatusBarSettings.SHARED_FILES_DISPLAY_ENABLED.invert();
            StatusLine.this.refresh();
        }
    }

    private class ShowConnectionQualityAction
    extends AbstractAction {
        public ShowConnectionQualityAction() {
            this.putValue("Name", GUIMediator.getStringResource("STATUS_BAR_SHOW_CONNECTION_QUALITY"));
        }

        public void actionPerformed(ActionEvent e) {
            StatusBarSettings.CONNECTION_QUALITY_DISPLAY_ENABLED.invert();
            StatusLine.this.refresh();
        }
    }
}

