/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.settings.StartupSettings;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public final class TipOfTheDayMediator
implements ThemeObserver {
    private static TipOfTheDayMediator _instance;
    private static final String TOTD_TITLE;
    private static final String TOTD_INTRO;
    private static final String TOTD_STARTUP;
    private static final String TOTD_NEXT;
    private static final String TOTD_PREVIOUS;
    private static final String TOTD_CLOSE;
    private final JDialog _dialog = new JDialog();
    private final JEditorPane _tipPane = new JEditorPane();
    private final JButton _previous;
    private static final String GENERAL = "GENERAL_";
    private static final String OSX = "OSX_";
    private static final String WINDOWS = "WINDOWS_";
    private static final String LINUX = "LINUX_";
    private static final String OTHER = "OTHER_";
    private static final String NOT_OSX = "NOT_OSX_";
    private static final String PRO = "PRO_";
    private static final String FREE = "FREE_";
    private static final List KEYS;
    private static int _currentTip;
    private static Color _foreground;
    private boolean _canDisplay = true;

    private TipOfTheDayMediator() {
        this.retrieveKeys();
        this._dialog.setModal(false);
        this._dialog.setResizable(false);
        this._dialog.setTitle(TOTD_TITLE);
        GUIUtils.addHideAction((JComponent)this._dialog.getContentPane());
        this._previous = new JButton(TOTD_PREVIOUS);
        this._previous.addActionListener(new PreviousTipListener());
        this.constructDialog();
        ThemeMediator.addThemeObserver(this);
    }

    public static synchronized TipOfTheDayMediator instance() {
        if (_instance == null) {
            _instance = new TipOfTheDayMediator();
        }
        return _instance;
    }

    public void updateComponentTreeUI() {
        SwingUtilities.updateComponentTreeUI(this._dialog);
    }

    public void displayTipWindow() {
        GUIMediator.safeInvokeLater(new Runnable(){

            public void run() {
                if (!TipOfTheDayMediator.this._canDisplay) {
                    return;
                }
                if (TipOfTheDayMediator.this._dialog.isShowing()) {
                    TipOfTheDayMediator.this._dialog.setVisible(false);
                    TipOfTheDayMediator.this._dialog.setVisible(true);
                    TipOfTheDayMediator.this._dialog.toFront();
                    return;
                }
                if (GUIMediator.isAppVisible()) {
                    TipOfTheDayMediator.this._dialog.setLocationRelativeTo(GUIMediator.getAppFrame());
                } else {
                    TipOfTheDayMediator.this._dialog.setLocation(GUIMediator.getScreenCenterPoint(TipOfTheDayMediator.this._dialog));
                }
                TipOfTheDayMediator.this._dialog.setVisible(true);
                if (!"text/html".equals(TipOfTheDayMediator.this._tipPane.getContentType())) {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            TipOfTheDayMediator.access$300(1.access$400(this.this$1)).setContentType("text/html");
                            TipOfTheDayMediator.access$600(1.access$400(this.this$1), TipOfTheDayMediator.access$500(1.access$400(this.this$1)));
                        }
                    });
                }
                TipOfTheDayMediator.this._dialog.toFront();
            }

            static /* synthetic */ TipOfTheDayMediator access$400(1 x0) {
                return x0.TipOfTheDayMediator.this;
            }
        });
    }

    public void hide() {
        this._dialog.setVisible(false);
    }

    private void setText(String tip) {
        int r = _foreground.getRed();
        int g = _foreground.getGreen();
        int b = _foreground.getBlue();
        String foreHex = this.toHex(r) + this.toHex(g) + this.toHex(b);
        this._tipPane.setText("<html><body text='#" + foreHex + "'>" + tip + "</html>");
        this._tipPane.setCaretPosition(0);
    }

    private String toHex(int i) {
        String hex = Integer.toHexString(i).toUpperCase();
        if (hex.length() == 1) {
            return "0" + hex;
        }
        return hex;
    }

    private void retrieveKeys() {
        ResourceBundle bundle = ResourceManager.getTOTDResourceBundle();
        Enumeration<String> e = bundle.getKeys();
        while (e.hasMoreElements()) {
            String k = e.nextElement();
            if (k.startsWith(GENERAL)) {
                KEYS.add(k);
                continue;
            }
            if (CommonUtils.isWindows() && k.startsWith(WINDOWS)) {
                KEYS.add(k);
                continue;
            }
            if (CommonUtils.isMacOSX() && k.startsWith(OSX)) {
                KEYS.add(k);
                continue;
            }
            if (CommonUtils.isLinux() && k.startsWith(LINUX)) {
                KEYS.add(k);
                continue;
            }
            if (!CommonUtils.isWindows() && !CommonUtils.isMacOSX() && !CommonUtils.isLinux() && k.startsWith(OTHER)) {
                KEYS.add(k);
                continue;
            }
            if (!CommonUtils.isMacOSX() && k.startsWith(NOT_OSX)) {
                KEYS.add(k);
                continue;
            }
            if (CommonUtils.isPro() && k.startsWith(PRO)) {
                KEYS.add(k);
                continue;
            }
            if (CommonUtils.isPro() || !k.startsWith(FREE)) continue;
            KEYS.add(k);
        }
        Collections.shuffle(KEYS);
        _currentTip = -1;
    }

    private String getRandomTip() {
        if (_currentTip == KEYS.size() - 1) {
            Collections.shuffle(KEYS);
            _currentTip = -1;
        } else if (_currentTip < -1) {
            _currentTip = -1;
        }
        String k = (String)KEYS.get(++_currentTip);
        if (_currentTip == 0) {
            this._previous.setEnabled(false);
        } else {
            this._previous.setEnabled(true);
        }
        ResourceBundle bundle = ResourceManager.getTOTDResourceBundle();
        return bundle.getString(k);
    }

    public void updateTheme() {
        boolean wasShowing = this._dialog.isShowing();
        this._dialog.setVisible(false);
        this._dialog.getContentPane().removeAll();
        Font tipFont = new Font(this._tipPane.getFont().getName(), this._tipPane.getFont().getStyle(), this._tipPane.getFont().getSize() - 2);
        this._tipPane.setFont(tipFont);
        this.constructDialog();
        this._tipPane.setContentType("text/html");
        this.setText(this.getRandomTip());
        if (wasShowing) {
            this._dialog.setVisible(true);
            this._dialog.toFront();
        }
    }

    private void constructDialog() {
        JPanel imagePanel = new JPanel();
        imagePanel.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue()));
        JLabel img = new JLabel(GUIMediator.getThemeImage("question"));
        imagePanel.add(img);
        JPanel didYouKnowPanel = new JPanel(new FlowLayout(0));
        JLabel didYouKnow = new JLabel(TOTD_INTRO);
        Font didYouKnowFont = new Font("Dialog", didYouKnow.getFont().getStyle(), didYouKnow.getFont().getSize() + 5);
        didYouKnow.setFont(didYouKnowFont);
        didYouKnowPanel.add(Box.createHorizontalStrut(3));
        didYouKnowPanel.add(didYouKnow);
        JPanel tipPanel = new JPanel();
        _foreground = didYouKnow.getForeground();
        tipPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue()));
        this._tipPane.setContentType("text");
        this._tipPane.setEditable(false);
        this._tipPane.setBackground(tipPanel.getBackground());
        Font tipFont = new Font("Dialog", this._tipPane.getFont().getStyle(), this._tipPane.getFont().getSize() + 2);
        this._tipPane.setFont(tipFont);
        this._tipPane.addHyperlinkListener(GUIUtils.getHyperlinkListener());
        this._tipPane.setText(GUIMediator.getStringResource("TOTD_LOADING_TIPS"));
        JScrollPane tipScroller = new JScrollPane(this._tipPane);
        tipScroller.setPreferredSize(new Dimension(400, 100));
        tipScroller.setHorizontalScrollBarPolicy(31);
        tipScroller.setVerticalScrollBarPolicy(20);
        tipScroller.setBorder(null);
        tipPanel.add(tipScroller);
        BoxPanel rightTip = new BoxPanel();
        rightTip.add(Box.createVerticalStrut(10));
        rightTip.add(didYouKnowPanel);
        rightTip.add(tipPanel);
        JPanel wholeTip = new JPanel(new BorderLayout());
        BoxPanel innerTip = new BoxPanel(0);
        innerTip.add(imagePanel);
        innerTip.add(rightTip);
        innerTip.setBorder(BorderFactory.createLoweredBevelBorder());
        wholeTip.add(Box.createHorizontalStrut(5), "West");
        wholeTip.add(Box.createHorizontalStrut(5), "East");
        wholeTip.add(Box.createVerticalStrut(5), "North");
        wholeTip.add(Box.createVerticalStrut(5), "South");
        wholeTip.add((Component)innerTip, "Center");
        JPanel startupPanel = new JPanel(new FlowLayout(0));
        JCheckBox showTips = new JCheckBox(TOTD_STARTUP);
        showTips.setSelected(StartupSettings.SHOW_TOTD.getValue());
        startupPanel.add(showTips);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(this._previous);
        JButton next = new JButton(TOTD_NEXT);
        buttonPanel.add(next);
        JButton close = new JButton(TOTD_CLOSE);
        buttonPanel.add(close);
        JPanel navigation = new JPanel(new BorderLayout());
        navigation.add((Component)startupPanel, "West");
        navigation.add((Component)buttonPanel, "East");
        showTips.addActionListener(new ShowTipListener());
        next.addActionListener(new NextTipListener());
        close.addActionListener(GUIUtils.getDisposeAction());
        this._dialog.setDefaultCloseOperation(2);
        Container pane = this._dialog.getContentPane();
        pane.setLayout(new BoxLayout(pane, 1));
        pane.add(wholeTip);
        pane.add(Box.createVerticalStrut(5));
        pane.add(navigation);
        try {
            this._dialog.pack();
        }
        catch (OutOfMemoryError oome) {
            this._canDisplay = false;
        }
    }

    static {
        TOTD_TITLE = GUIMediator.getStringResource("TOTD_TITLE");
        TOTD_INTRO = GUIMediator.getStringResource("TOTD_INTRODUCTION");
        TOTD_STARTUP = GUIMediator.getStringResource("TOTD_SHOW_AT_STARTUP");
        TOTD_NEXT = GUIMediator.getStringResource("TOTD_NEXT");
        TOTD_PREVIOUS = GUIMediator.getStringResource("TOTD_PREVIOUS");
        TOTD_CLOSE = GUIMediator.getStringResource("TOTD_CLOSE");
        KEYS = new ArrayList();
    }

    private class PreviousTipListener
    implements ActionListener {
        private PreviousTipListener() {
        }

        public void actionPerformed(ActionEvent e) {
            _currentTip = _currentTip - 2;
            TipOfTheDayMediator.this.setText(TipOfTheDayMediator.this.getRandomTip());
        }
    }

    private class NextTipListener
    implements ActionListener {
        private NextTipListener() {
        }

        public void actionPerformed(ActionEvent e) {
            TipOfTheDayMediator.this.setText(TipOfTheDayMediator.this.getRandomTip());
        }
    }

    private class ShowTipListener
    implements ActionListener {
        private ShowTipListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JCheckBox source = (JCheckBox)e.getSource();
            StartupSettings.SHOW_TOTD.setValue(source.isSelected());
        }
    }
}

