/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.UpdateDialog;
import com.limegroup.gnutella.version.UpdateInformation;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.plaf.metal.MetalLabelUI;

final class UpdatePanel
extends JLabel
implements RefreshListener {
    private final String labelString = GUIMediator.getStringResource("UPDATE_MESSAGE_SMALL");
    private volatile boolean _updateAvailable;
    private UpdateInformation _info;
    private UpdateDialog _dialog;

    UpdatePanel() {
        super(GUIMediator.getStringResource("UPDATE_MESSAGE_SMALL"), 0);
        this.setUI(new LinkLabelUI());
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int width = fm.stringWidth(this.labelString);
        Dimension dim = new Dimension(width, fm.getHeight());
        this.setForeground(Color.red);
        this.setPreferredSize(dim);
        this.setMaximumSize(dim);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                UpdatePanel.this.handleClick();
            }

            public void mouseEntered(MouseEvent e) {
                if (UpdatePanel.this._updateAvailable) {
                    e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            public void mouseExited(MouseEvent e) {
                if (UpdatePanel.this._updateAvailable) {
                    e.getComponent().setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        GUIMediator.addRefreshListener(this);
        this.setVisible(false);
        this._updateAvailable = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeVisible(boolean popup, UpdateInformation info) {
        Runnable disposer = null;
        UpdatePanel updatePanel = this;
        synchronized (updatePanel) {
            this._updateAvailable = true;
            this._info = info;
            final UpdateDialog currentDialog = this._dialog;
            if (this._info != null) {
                this._dialog = new UpdateDialog(this._info);
            }
            if (currentDialog != null) {
                disposer = new Runnable(){

                    public void run() {
                        currentDialog.setVisible(false);
                        currentDialog.dispose();
                    }
                };
            }
        }
        if (disposer != null) {
            GUIMediator.safeInvokeLater(disposer);
        }
        super.setVisible(true);
        if (popup) {
            GUIMediator.safeInvokeLater(new Runnable(){

                public void run() {
                    UpdatePanel.this.handleClick();
                }
            });
        }
    }

    public boolean shouldBeShown() {
        return this._updateAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClick() {
        if (!this._updateAvailable) {
            return;
        }
        UpdatePanel updatePanel = this;
        synchronized (updatePanel) {
            if (this._info != null) {
                this._dialog.setVisible(true);
            }
        }
    }

    public void refresh() {
        if (!this._updateAvailable) {
            return;
        }
        Color currCol = this.getForeground();
        if (currCol.equals(Color.red)) {
            this.setForeground(Color.black);
        }
        if (currCol.equals(Color.black)) {
            this.setForeground(Color.red);
        }
    }

    private class LinkLabelUI
    extends MetalLabelUI {
        private LinkLabelUI() {
        }

        protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
            super.paintEnabledText(l, g, s, textX, textY);
            if (UpdatePanel.this.getText() == null) {
                return;
            }
            FontMetrics fm = g.getFontMetrics();
            g.fillRect(textX, fm.getAscent() + 2, fm.stringWidth(UpdatePanel.this.getText()) - UpdatePanel.this.getInsets().right, 1);
        }
    }
}

