/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.actions;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Collections;
import javax.swing.AbstractAction;

public class SearchXMLFieldAction
extends AbstractAction {
    private NameValue displayPair;
    private String name;
    private String value;
    private NamedMediaType nm;

    public SearchXMLFieldAction(NameValue displayPair, String name, String value, NamedMediaType nm) {
        this.displayPair = displayPair;
        this.name = name;
        this.value = value;
        this.nm = nm;
        String formatted = MessageFormat.format(GUIMediator.getStringResource("SEARCH_XML_FIELD_ACTION_NAME"), displayPair.getName(), displayPair.getValue());
        if (formatted.length() > 80) {
            formatted = formatted.substring(0, 80) + "...";
        }
        this.putValue("Name", formatted);
    }

    public void actionPerformed(ActionEvent e) {
        NameValue namValue = new NameValue(this.name, I18NConvert.instance().getNorm(this.value));
        String xml = new LimeXMLDocument(Collections.singletonList(namValue), this.nm.getSchema().getSchemaURI()).getXMLString();
        SearchMediator.triggerSearch(SearchInformation.createTitledKeyWordSearch(StringUtils.createQueryString(this.value, true), xml, this.nm.getMediaType(), this.displayPair.getName() + ": " + this.displayPair.getValue()));
        GUIMediator.instance().setWindow(0);
    }
}

