/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class TitledIconBorder
extends TitledBorder {
    protected Icon icon;
    private Point textLoc = new Point();
    private Point iconLoc = new Point();
    private static final int BORDER_SPACING = 2;
    private static final int ICON_SPACING = 4;
    protected static final int TITLE_INSET_H = 8;
    private static final int EMPTY_SPACE = 4;

    public TitledIconBorder() {
        super(UIManager.getBorder("TitledBorder.border"));
    }

    public TitledIconBorder(Border border) {
        super(border);
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int titlePos;
        if (this.icon == null) {
            super.paintBorder(c, g, x, y, width, height);
            return;
        }
        Border border = this.getBorder();
        String title = this.getTitle();
        int n = titlePos = this.getTitlePosition() == 0 ? 2 : this.getTitlePosition();
        if (title == null || title.equals("")) {
            if (border != null) {
                border.paintBorder(c, g, x, y, width, height);
            }
            return;
        }
        Rectangle grooveRect = new Rectangle(x + 2, y + 2, width - 4, height - 4);
        Font font = g.getFont();
        Color color = g.getColor();
        g.setFont(this.getFont(c));
        JComponent jc = c instanceof JComponent ? (JComponent)c : null;
        FontMetrics fm = jc == null ? Toolkit.getDefaultToolkit().getFontMetrics(font) : jc.getFontMetrics(font);
        int titleHeight = Math.max(this.icon.getIconHeight(), fm.getHeight());
        int descent = fm.getDescent();
        int ascent = fm.getAscent();
        int titleWidth = fm.stringWidth(title) + 4 + this.icon.getIconWidth();
        Insets insets = border != null ? border.getBorderInsets(c) : new Insets(0, 0, 0, 0);
        switch (titlePos) {
            case 1: {
                int diff = ascent + descent + (Math.max(2, 4) - 2);
                grooveRect.y += diff;
                grooveRect.height -= diff;
                this.textLoc.y = grooveRect.y - (descent + 2);
                this.iconLoc.y = grooveRect.y + 2;
                break;
            }
            case 2: {
                int diff = Math.max(0, ascent / 2 + 2 - 2);
                grooveRect.y += diff;
                grooveRect.height -= diff;
                this.textLoc.y = grooveRect.y - descent + (insets.top + ascent + descent) / 2;
                this.iconLoc.y = grooveRect.y - insets.top / 2;
                break;
            }
            case 3: {
                this.textLoc.y = grooveRect.y + insets.top + ascent + 2;
                this.iconLoc.y = grooveRect.y - insets.top - 2;
                break;
            }
            case 4: {
                this.textLoc.y = grooveRect.y + grooveRect.height - (insets.bottom + descent + 2);
                this.iconLoc.y = grooveRect.y + grooveRect.height + insets.bottom + 2;
                break;
            }
            case 5: {
                grooveRect.height -= titleHeight / 2;
                this.textLoc.y = grooveRect.y + grooveRect.height - descent + (ascent + descent - insets.bottom) / 2;
                this.iconLoc.y = grooveRect.y + grooveRect.height + insets.bottom / 2;
                break;
            }
            case 6: {
                grooveRect.height -= titleHeight;
                this.textLoc.y = grooveRect.y + grooveRect.height + ascent + 2;
                this.iconLoc.y = grooveRect.y + grooveRect.height - 2;
            }
        }
        int justification = 1;
        switch (justification) {
            case 1: {
                this.iconLoc.x = grooveRect.x + 8 + insets.left;
                this.textLoc.x = this.iconLoc.x + this.icon.getIconWidth() + 4;
                break;
            }
            case 3: {
                this.iconLoc.x = grooveRect.x + grooveRect.width - (titleWidth + 8 + insets.right);
                this.textLoc.x = this.iconLoc.x - this.icon.getIconWidth() - 4;
                break;
            }
            case 2: {
                this.iconLoc.x = grooveRect.x + (grooveRect.width - titleWidth) / 2;
                this.textLoc.x = this.iconLoc.x + this.icon.getIconWidth() + 4;
            }
        }
        if (border != null) {
            if (titlePos == 2 && grooveRect.y > this.textLoc.y - ascent || titlePos == 5 && grooveRect.y + grooveRect.height < this.textLoc.y + descent) {
                Rectangle clipRect = new Rectangle();
                Rectangle saveClip = g.getClipBounds();
                clipRect.setBounds(saveClip);
                if (TitledIconBorder.computeIntersection(clipRect, x, y, this.iconLoc.x - 4 - x, height)) {
                    g.setClip(clipRect);
                    border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                }
                clipRect.setBounds(saveClip);
                if (TitledIconBorder.computeIntersection(clipRect, this.iconLoc.x + titleWidth + 4 + 2, y, x + width - (this.iconLoc.x + titleWidth + 4 + 2), height)) {
                    g.setClip(clipRect);
                    border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                }
                if (titlePos == 2) {
                    clipRect.setBounds(saveClip);
                    if (TitledIconBorder.computeIntersection(clipRect, this.iconLoc.x - 4, this.textLoc.y + descent, titleWidth + 8 + 2, y + height - this.textLoc.y - descent)) {
                        g.setClip(clipRect);
                        border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                    }
                } else {
                    clipRect.setBounds(saveClip);
                    if (TitledIconBorder.computeIntersection(clipRect, this.iconLoc.x - 4, y, titleWidth + 8 + 2, this.textLoc.y - ascent - y)) {
                        g.setClip(clipRect);
                        border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                    }
                }
                g.setClip(saveClip);
            } else {
                border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
            }
        }
        g.setColor(this.getTitleColor());
        if (title.length() > 0) {
            g.drawString(this.getTitle(), this.textLoc.x, this.textLoc.y);
        }
        this.icon.paintIcon(c, g, this.iconLoc.x, this.iconLoc.y - 5);
        g.setFont(font);
        g.setColor(color);
    }

    private static boolean computeIntersection(Rectangle dest, int rx, int ry, int rw, int rh) {
        int x1 = Math.max(rx, dest.x);
        int x2 = Math.min(rx + rw, dest.x + dest.width);
        int y1 = Math.max(ry, dest.y);
        int y2 = Math.min(ry + rh, dest.y + dest.height);
        dest.x = x1;
        dest.y = y1;
        dest.width = x2 - x1;
        dest.height = y2 - y1;
        return dest.width > 0 && dest.height > 0;
    }
}

