/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.chat;

import com.limegroup.gnutella.chat.Chatter;
import com.limegroup.gnutella.gui.chat.ChatFrame;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class ChatUIManager {
    private static final ChatUIManager INSTANCE = new ChatUIManager();
    private Map _chats = Collections.synchronizedMap(new HashMap());

    private ChatUIManager() {
    }

    public static ChatUIManager instance() {
        return INSTANCE;
    }

    public void acceptChat(Chatter chatter) {
        if (this.frameAlreadyExists(chatter)) {
            this.raiseExistingFrame(chatter);
            return;
        }
        ChatFrame cframe = new ChatFrame(chatter);
        cframe.setVisible(true);
        this._chats.put(chatter, cframe);
    }

    private boolean frameAlreadyExists(Chatter chatter) {
        Set existingChats = this._chats.keySet();
        Iterator i = existingChats.iterator();
        while (i.hasNext()) {
            Chatter c = (Chatter)i.next();
            if (c.getHost().compareTo(chatter.getHost()) != 0) continue;
            return true;
        }
        return false;
    }

    private void raiseExistingFrame(Chatter chatter) {
        Set existingChats = this._chats.keySet();
        Iterator i = existingChats.iterator();
        while (i.hasNext()) {
            Chatter c = (Chatter)i.next();
            if (c.getHost().compareTo(chatter.getHost()) != 0) continue;
            ChatFrame frame = (ChatFrame)this._chats.get(c);
            frame.setState(0);
            frame.toFront();
            return;
        }
    }

    public void removeChat(Chatter chatter) {
        ChatFrame cframe = (ChatFrame)this._chats.remove(chatter);
        if (cframe != null) {
            cframe.dispose();
            cframe.setVisible(false);
        }
    }

    public void receiveMessage(Chatter chatter) {
        ChatFrame cframe = (ChatFrame)this._chats.get(chatter);
        if (cframe == null) {
            return;
        }
        cframe.addResponse(chatter.getMessage());
    }

    public void chatUnavailable(Chatter chatter) {
        ChatFrame cframe = (ChatFrame)this._chats.get(chatter);
        if (cframe == null) {
            return;
        }
        cframe.chatUnavailable();
    }

    public void chatErrorMessage(Chatter chatter, String str) {
        ChatFrame cframe = (ChatFrame)this._chats.get(chatter);
        if (cframe == null) {
            return;
        }
        cframe.displayErrorMessage(str);
    }
}

