/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.download;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileDetails;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.FileDetailsProvider;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.actions.BitziLookupAction;
import com.limegroup.gnutella.gui.actions.CopyMagnetLinkToClipboardAction;
import com.limegroup.gnutella.gui.actions.SearchAction;
import com.limegroup.gnutella.gui.download.DownloadButtons;
import com.limegroup.gnutella.gui.download.DownloadDataLine;
import com.limegroup.gnutella.gui.download.DownloadModel;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.playlist.PlaylistMediator;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.ColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.tables.DragManager;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.SimpleColumnListener;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.gui.util.CoreExceptionHandler;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Launcher;
import com.limegroup.gnutella.util.ProcessingQueue;
import com.limegroup.gnutella.util.StringUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DownloadMediator
extends AbstractTableMediator
implements FileDetailsProvider {
    private static final Log LOG = LogFactory.getLog(DownloadMediator.class);
    private static int _totalDownloads = 0;
    private static boolean _audioLaunched = false;
    private static DownloadMediator _instance = new DownloadMediator();
    private static final ProcessingQueue QUEUE = new ProcessingQueue("DownloadLauncher");
    private Action removeAction;
    private Action chatAction;
    private Action clearAction;
    private Action browseAction;
    private Action launchAction;
    private Action resumeAction;
    private Action pauseAction;
    private Action priorityUpAction;
    private Action priorityDownAction;
    private Action editLocationAction;
    private Action magnetAction;
    private Action bitziAction;
    private Action exploreAction;
    private DownloadButtons _downloadButtons;

    public static DownloadMediator instance() {
        return _instance;
    }

    protected void buildSettings() {
        this.SETTINGS = new TableSettings(this.ID){

            public boolean getDefaultTooltips() {
                return false;
            }
        };
    }

    protected void setupDragAndDrop() {
        DragManager.install(this.TABLE);
    }

    protected void buildListeners() {
        super.buildListeners();
        this.removeAction = new RemoveAction();
        this.chatAction = new ChatAction();
        this.clearAction = new ClearAction();
        this.browseAction = new BrowseAction();
        this.launchAction = new LaunchAction();
        this.resumeAction = new ResumeAction();
        this.pauseAction = new PauseAction();
        this.priorityUpAction = new PriorityUpAction();
        this.priorityDownAction = new PriorityDownAction();
        this.editLocationAction = new EditLocationAction();
        this.magnetAction = new CopyMagnetLinkToClipboardAction(this);
        this.exploreAction = new ExploreAction();
        this.bitziAction = new BitziLookupAction(this);
    }

    public Action[] getActions() {
        Action[] actions = CommonUtils.isWindows() || CommonUtils.isMacOSX() ? new Action[]{this.priorityUpAction, this.priorityDownAction, this.removeAction, this.resumeAction, this.pauseAction, this.launchAction, this.exploreAction, this.clearAction} : new Action[]{this.priorityUpAction, this.priorityDownAction, this.removeAction, this.resumeAction, this.pauseAction, this.launchAction, this.clearAction};
        return actions;
    }

    protected void setupConstants() {
        this.MAIN_PANEL = new PaddedPanel(GUIMediator.getStringResource("DOWNLOAD_TITLE"));
        this.DATA_MODEL = new DownloadModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        this._downloadButtons = new DownloadButtons(this);
        this.BUTTON_ROW = this._downloadButtons.getComponent();
    }

    protected void setupTableHeaders() {
        super.setupTableHeaders();
        Object pId = this.DATA_MODEL.getColumnId(0);
        this._downloadButtons.setQueuePanelVisible(this.TABLE.isColumnVisible(pId));
        ColumnPreferenceHandler cph = this.TABLE.getColumnPreferenceHandler();
        cph.setSimpleColumnListener(new SimpleColumnListener(){

            public void columnAdded(LimeTableColumn ltc, LimeJTable table) {
                Assert.that(table == DownloadMediator.this.TABLE);
                if (ltc.getModelIndex() == 0) {
                    DownloadMediator.this._downloadButtons.setQueuePanelVisible(true);
                }
            }

            public void columnRemoved(LimeTableColumn ltc, LimeJTable table) {
                Assert.that(table == DownloadMediator.this.TABLE);
                if (ltc.getModelIndex() == 0) {
                    DownloadMediator.this._downloadButtons.setQueuePanelVisible(false);
                }
            }
        });
    }

    protected void updateSplashScreen() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_DOWNLOAD_WINDOW"));
    }

    private DownloadMediator() {
        super("DOWNLOAD_TABLE");
        GUIMediator.addRefreshListener(this);
        ThemeMediator.addThemeObserver(this);
        if (this.SETTINGS.REAL_TIME_SORT.getValue()) {
            this.DATA_MODEL.sort(0);
        }
    }

    public void doRefresh() {
        boolean inactivePresent = (Boolean)this.DATA_MODEL.refresh();
        this.clearAction.setEnabled(inactivePresent);
        int[] selRows = this.TABLE.getSelectedRows();
        if (selRows.length > 0) {
            DownloadDataLine dataLine = (DownloadDataLine)this.DATA_MODEL.get(selRows[0]);
            if (dataLine.getState() == 13) {
                this.resumeAction.putValue("Name", GUIMediator.getStringResource("DOWNLOAD_POPUP_MENU_SOURCES"));
                this.resumeAction.putValue("LimeShortName", GUIMediator.getStringResource("DOWNLOAD_SOURCES_BUTTON_LABEL"));
                this.resumeAction.putValue("ShortDescription", GUIMediator.getStringResource("DOWNLOAD_SOURCES_BUTTON_TIP"));
            } else {
                this.resumeAction.putValue("Name", GUIMediator.getStringResource("DOWNLOAD_POPUP_MENU_RESUME"));
                this.resumeAction.putValue("LimeShortName", GUIMediator.getStringResource("DOWNLOAD_RESUME_BUTTON_LABEL"));
                this.resumeAction.putValue("ShortDescription", GUIMediator.getStringResource("DOWNLOAD_RESUME_BUTTON_TIP"));
            }
            boolean inactive = dataLine.isDownloaderInactive();
            boolean pausable = !dataLine.getDownloader().isPaused() && !dataLine.getDownloader().isCompleted();
            this.resumeAction.setEnabled(inactive);
            this.pauseAction.setEnabled(pausable);
            this.priorityUpAction.setEnabled(inactive && pausable);
            this.priorityDownAction.setEnabled(inactive && pausable);
            this.exploreAction.setEnabled(dataLine.getDownloader().isCompleted());
        }
    }

    public int getTotalDownloads() {
        return _totalDownloads;
    }

    public int getCurrentDownloads() {
        return ((DownloadModel)this.DATA_MODEL).getCurrentDownloads();
    }

    public int getActiveDownloads() {
        return ((DownloadModel)this.DATA_MODEL).getRowCount();
    }

    public Set getFileNames() {
        HashSet<String> names = new HashSet<String>();
        for (int c = 0; c < this.DATA_MODEL.getRowCount(); ++c) {
            names.add(((DownloadDataLine)this.DATA_MODEL.get(c)).getFileName());
        }
        return names;
    }

    public double getActiveDownloadsBandwidth() {
        return ((DownloadModel)this.DATA_MODEL).getActiveDownloadsBandwidth();
    }

    public void add(Object downloader) {
        if (!this.DATA_MODEL.contains(downloader)) {
            ++_totalDownloads;
            super.add(downloader);
        }
    }

    public void remove(Object downloader) {
        Downloader dloader = (Downloader)downloader;
        int state = dloader.getState();
        if (state == 4 && this.isThemeFile(dloader.getSaveFile().getName())) {
            File themeFile = dloader.getDownloadFragment();
            themeFile = this.copyToThemeDir(themeFile);
            if (OptionsMediator.instance().isOptionsVisible()) {
                GUIMediator.showFormattedMessage("DOWNLOAD_EXPLAIN_HOW_TO_CHANGE_THEME", new String[]{ThemeSettings.formatName(dloader.getSaveFile().getName()), GUIMediator.getStringResource("MENU_VIEW_THEMES_REFRESH"), GUIMediator.getStringResource("MENU_VIEW_TITLE"), GUIMediator.getStringResource("MENU_VIEW_THEMES_TITLE")});
            } else {
                int response = GUIMediator.showYesNoMessage("DOWNLOAD_APPLY_NEW_THEME_START", ThemeSettings.formatName(dloader.getSaveFile().getName()), "DOWNLOAD_APPLY_NEW_THEME_END", QuestionsHandler.THEME_DOWNLOADED);
                if (response == 101) {
                    ThemeMediator.changeTheme(themeFile);
                }
            }
        }
        if (SharingSettings.CLEAR_DOWNLOAD.getValue() && (state == 4 || state == 5)) {
            super.remove(downloader);
        } else {
            DownloadDataLine ddl = (DownloadDataLine)this.DATA_MODEL.get(downloader);
            if (ddl != null) {
                ddl.setEndTime(System.currentTimeMillis());
            }
        }
    }

    private File copyToThemeDir(File themeFile) {
        File themeDir = ThemeSettings.THEME_DIR_FILE;
        File realLoc = new File(themeDir, themeFile.getName());
        if (realLoc.equals(themeFile)) {
            return themeFile;
        }
        realLoc.delete();
        CommonUtils.copy(themeFile, realLoc);
        return realLoc;
    }

    private boolean isThemeFile(String name) {
        return name.toLowerCase().endsWith("lwtp");
    }

    void launchSelectedDownloads() {
        DataLine[] lines = this.TABLE.getSelectedDataLines();
        _audioLaunched = false;
        for (int i = 0; i < lines.length; ++i) {
            final Downloader dl = (Downloader)lines[i].getInitializeObject();
            QUEUE.add(new Runnable(){

                public void run() {
                    if (dl.getState() == 19) {
                        GUIMediator.openURL("http://filtered.limewire.com/removed");
                    } else {
                        File toLaunch = dl.getDownloadFragment();
                        if (toLaunch == null) {
                            GUIMediator.showMessage("NO_PREVIEW_BEGIN", dl.getSaveFile().getName(), "NO_PREVIEW_END", QuestionsHandler.NO_PREVIEW_REPORT);
                            return;
                        }
                        if (!_audioLaunched && PlaylistMediator.isPlayableFile(toLaunch) && GUIMediator.isPlaylistVisible()) {
                            GUIMediator.instance().launchAudio(toLaunch);
                            _audioLaunched = true;
                        } else {
                            try {
                                GUIMediator.launchFile(toLaunch);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }
            });
        }
    }

    void pauseSelectedDownloads() {
        DataLine[] lines = this.TABLE.getSelectedDataLines();
        for (int i = 0; i < lines.length; ++i) {
            ((Downloader)lines[i].getInitializeObject()).pause();
        }
    }

    void launchExplorer() {
        DataLine[] lines = this.TABLE.getSelectedDataLines();
        Downloader dl = (Downloader)lines[lines.length - 1].getInitializeObject();
        File toExplore = dl.getFile();
        if (toExplore == null) {
            return;
        }
        try {
            Launcher.launchExplorer(toExplore);
        }
        catch (SecurityException ignore) {
        }
        catch (IOException ignore) {
            // empty catch block
        }
    }

    void bumpPriority(final boolean up, int amt) {
        DataLine[] lines = this.TABLE.getSelectedDataLines();
        Arrays.sort(lines, new Comparator(){

            public int compare(Object a, Object b) {
                int pb;
                int pa = ((Downloader)((DataLine)a).getInitializeObject()).getInactivePriority();
                return (pa < (pb = ((Downloader)((DataLine)b).getInitializeObject()).getInactivePriority()) ? -1 : (pa > pb ? 1 : 0)) * (up ? 1 : -1);
            }
        });
        for (int i = 0; i < lines.length; ++i) {
            Downloader dl = (Downloader)lines[i].getInitializeObject();
            RouterService.getDownloadManager().bumpPriority(dl, up, amt);
        }
    }

    void resumeSelectedDownloads() {
        DataLine[] lines = this.TABLE.getSelectedDataLines();
        for (int i = 0; i < lines.length; ++i) {
            DownloadDataLine dd = (DownloadDataLine)lines[i];
            Downloader downloader = dd.getDownloader();
            if (dd.isCleaned()) continue;
            downloader.resume();
        }
    }

    void chatWithSelectedDownloads() {
        DataLine[] lines = this.TABLE.getSelectedDataLines();
        for (int i = 0; i < lines.length; ++i) {
            DataLine dl = lines[i];
            Downloader downloader = (Downloader)dl.getInitializeObject();
            Endpoint end = downloader.getChatEnabledHost();
            if (end == null) continue;
            RouterService.createChat(end.getAddress(), end.getPort());
        }
    }

    void editSelectedDownload() {
        DataLine[] lines = this.TABLE.getSelectedDataLines();
        Downloader dl = (Downloader)lines[0].getInitializeObject();
        File saveLocation = dl.getSaveFile();
        File saveFile = FileChooserHandler.getSaveAsFile(MessageService.getParentComponent(), "DOWNLOAD_LOCATION_DIALOG_TITLE", saveLocation);
        if (saveFile == null) {
            return;
        }
        try {
            if (!saveFile.equals(dl.getSaveFile())) {
                dl.setSaveFile(saveFile.getParentFile(), saveFile.getName(), false);
            }
        }
        catch (SaveLocationException sle) {
            CoreExceptionHandler.handleSaveLocationError(sle);
        }
    }

    void browseSelectedDownloads() {
        DataLine[] lines = this.TABLE.getSelectedDataLines();
        for (int i = 0; i < lines.length; ++i) {
            DataLine dl = lines[i];
            Downloader downloader = (Downloader)dl.getInitializeObject();
            RemoteFileDesc end = downloader.getBrowseEnabledHost();
            if (end == null) continue;
            SearchMediator.doBrowseHost(end);
        }
    }

    public void handleActionKey() {
        this.launchSelectedDownloads();
    }

    void clearCompletedDownloads() {
        ((DownloadModel)this.DATA_MODEL).clearCompleted();
        this.clearSelection();
        this.clearAction.setEnabled(false);
    }

    public FileDetails[] getFileDetails() {
        DataLine[] lines = this.TABLE.getSelectedDataLines();
        FileManager fmanager = RouterService.getFileManager();
        ArrayList<FileDesc> list = new ArrayList<FileDesc>(lines.length);
        for (int i = 0; i < lines.length; ++i) {
            URN urn = ((DownloadDataLine)lines[i]).getDownloader().getSHA1Urn();
            if (urn != null) {
                FileDesc fd = fmanager.getFileDescForUrn(urn);
                if (fd != null) {
                    list.add(fd);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("not filedesc for urn " + urn);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("no urn");
        }
        return list.toArray(new FileDetails[0]);
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new JMenuItem(this.removeAction));
        menu.add(new JMenuItem(this.resumeAction));
        menu.add(new JMenuItem(this.pauseAction));
        menu.add(new JMenuItem(this.launchAction));
        if (CommonUtils.isWindows() || CommonUtils.isMacOSX()) {
            menu.add(new JMenuItem(this.exploreAction));
        }
        menu.addSeparator();
        menu.add(new JMenuItem(this.clearAction));
        menu.addSeparator();
        menu.add(this.createSearchMenu());
        menu.add(new JMenuItem(this.chatAction));
        menu.add(new JMenuItem(this.browseAction));
        menu.add(new JMenuItem(this.editLocationAction));
        return menu;
    }

    private JMenu createSearchMenu() {
        SearchInformation info;
        String filename;
        int dotPos;
        JMenu menu = new JMenu(GUIMediator.getStringResource("DOWNLOAD_SEARCH_MENU"));
        DataLine[] lines = this.TABLE.getSelectedDataLines();
        if (lines.length == 0) {
            menu.setEnabled(false);
            return menu;
        }
        Downloader downloader = ((DownloadDataLine)lines[0]).getDownloader();
        Map searchInfoMap = (Map)downloader.getAttribute("searchInformationMap");
        if (searchInfoMap != null) {
            SearchInformation searchInfo = SearchInformation.createFromMap(searchInfoMap);
            menu.add(new JMenuItem(new SearchAction(searchInfo)));
        }
        if ((dotPos = (filename = ((DownloadDataLine)lines[0]).getFileName()).lastIndexOf(46)) > 0) {
            filename = filename.substring(0, dotPos);
        }
        if ((filename = StringUtils.removeIllegalChars(filename)).length() > SearchSettings.MAX_QUERY_LENGTH.getValue()) {
            filename = filename.substring(0, SearchSettings.MAX_QUERY_LENGTH.getValue());
        }
        if (SearchMediator.validateInfo(info = SearchInformation.createKeywordSearch(filename, null, MediaType.getAnyTypeMediaType())) == 0) {
            menu.add(new JMenuItem(new SearchAction(info, "SEARCH_FOR_KEYWORDS_ACTION_NAME")));
        }
        return menu;
    }

    private JMenu createAdvancedSubMenu() {
        JMenu menu = new JMenu(GUIMediator.getStringResource("GENERAL_ADVANCED_SUB_MENU"));
        menu.add(new JMenuItem(this.bitziAction));
        menu.add(new JMenuItem(this.magnetAction));
        return menu;
    }

    public void handleSelection(int row) {
        boolean pausable;
        DownloadDataLine dataLine = (DownloadDataLine)this.DATA_MODEL.get(row);
        this.chatAction.setEnabled(dataLine.getChatEnabled());
        this.browseAction.setEnabled(dataLine.getBrowseEnabled());
        boolean inactive = dataLine.isDownloaderInactive();
        boolean bl = pausable = !dataLine.getDownloader().isPaused() && !dataLine.getDownloader().isCompleted();
        if (dataLine.getState() == 13) {
            this.resumeAction.putValue("Name", GUIMediator.getStringResource("DOWNLOAD_POPUP_MENU_SOURCES"));
            this.resumeAction.putValue("LimeShortName", GUIMediator.getStringResource("DOWNLOAD_SOURCES_BUTTON_LABEL"));
            this.resumeAction.putValue("ShortDescription", GUIMediator.getStringResource("DOWNLOAD_SOURCES_BUTTON_TIP"));
        } else {
            this.resumeAction.putValue("Name", GUIMediator.getStringResource("DOWNLOAD_POPUP_MENU_RESUME"));
            this.resumeAction.putValue("LimeShortName", GUIMediator.getStringResource("DOWNLOAD_RESUME_BUTTON_LABEL"));
            this.resumeAction.putValue("ShortDescription", GUIMediator.getStringResource("DOWNLOAD_RESUME_BUTTON_TIP"));
        }
        if (dataLine.isCompleted()) {
            this.removeAction.putValue("Name", GUIMediator.getStringResource("DOWNLOAD_POPUP_MENU_KILL_COMPLETED_LABEL"));
            this.removeAction.putValue("LimeShortName", GUIMediator.getStringResource("DOWNLOAD_KILL_BUTTON_COMPLETED_LABEL"));
            this.removeAction.putValue("ShortDescription", GUIMediator.getStringResource("DOWNLOAD_KILL_BUTTON_COMPLETED_TIP"));
            this.launchAction.putValue("Name", GUIMediator.getStringResource("DOWNLOAD_POPUP_MENU_LAUNCH_COMPLETED_LABEL"));
            this.launchAction.putValue("LimeShortName", GUIMediator.getStringResource("DOWNLOAD_LAUNCH_BUTTON_COMPLETED_LABEL"));
            this.launchAction.putValue("ShortDescription", GUIMediator.getStringResource("DOWNLOAD_LAUNCH_BUTTON_COMPLETED_TIP"));
            this.exploreAction.setEnabled(this.TABLE.getSelectedRowCount() == 1);
        } else {
            this.removeAction.putValue("Name", GUIMediator.getStringResource("DOWNLOAD_POPUP_MENU_KILL_DOWNLOAD"));
            this.removeAction.putValue("LimeShortName", GUIMediator.getStringResource("DOWNLOAD_KILL_BUTTON_LABEL"));
            this.removeAction.putValue("ShortDescription", GUIMediator.getStringResource("DOWNLOAD_KILL_BUTTON_TIP"));
            this.launchAction.putValue("Name", GUIMediator.getStringResource("DOWNLOAD_POPUP_MENU_LAUNCH"));
            this.launchAction.putValue("LimeShortName", GUIMediator.getStringResource("DOWNLOAD_LAUNCH_BUTTON_LABEL"));
            this.launchAction.putValue("ShortDescription", GUIMediator.getStringResource("DOWNLOAD_LAUNCH_BUTTON_TIP"));
            this.exploreAction.setEnabled(false);
        }
        this.removeAction.setEnabled(true);
        this.resumeAction.setEnabled(inactive);
        this.pauseAction.setEnabled(pausable);
        this.priorityDownAction.setEnabled(inactive && pausable);
        this.priorityUpAction.setEnabled(inactive && pausable);
        Downloader dl = (Downloader)dataLine.getInitializeObject();
        this.editLocationAction.setEnabled(this.TABLE.getSelectedRowCount() == 1 && dl.isRelocatable());
        this.magnetAction.setEnabled(dl.getSHA1Urn() != null);
        this.bitziAction.setEnabled(dl.getSHA1Urn() != null);
        this.launchAction.setEnabled(dl.getAmountRead() > 0);
    }

    public void handleNoSelection() {
        this.removeAction.setEnabled(false);
        this.resumeAction.setEnabled(false);
        this.launchAction.setEnabled(false);
        this.pauseAction.setEnabled(false);
        this.chatAction.setEnabled(false);
        this.browseAction.setEnabled(false);
        this.priorityDownAction.setEnabled(false);
        this.priorityUpAction.setEnabled(false);
        this.editLocationAction.setEnabled(false);
        this.magnetAction.setEnabled(false);
        this.bitziAction.setEnabled(false);
        this.exploreAction.setEnabled(false);
    }

    private class EditLocationAction
    extends AbstractAction {
        public EditLocationAction() {
            this.putValue("Name", GUIMediator.getStringResource("DOWNLOAD_POPUP_MENU_EDIT_LOCATION_LABEL"));
            this.putValue("ShortDescription", GUIMediator.getStringResource("DOWNLOAD_POPUP_MENU_EDIT_LOCATION_TIP"));
        }

        public void actionPerformed(ActionEvent e) {
            DownloadMediator.this.editSelectedDownload();
        }
    }

    private class PriorityDownAction
    extends AbstractAction {
        public PriorityDownAction() {
            this.putValue("LimeShortName", "");
            this.putValue("ShortDescription", GUIMediator.getStringResource("DOWNLOAD_PRIORITY_DOWN_BUTTON_TIP"));
            this.putValue("LimeIconName", "DOWNLOAD_PRIORITY_DOWN");
        }

        public void actionPerformed(ActionEvent e) {
            if ((e.getModifiers() & 2) != 0) {
                DownloadMediator.this.bumpPriority(false, 10);
            } else if ((e.getModifiers() & 8) != 0) {
                DownloadMediator.this.bumpPriority(false, 0);
            } else {
                DownloadMediator.this.bumpPriority(false, 1);
            }
        }
    }

    private class PriorityUpAction
    extends AbstractAction {
        public PriorityUpAction() {
            this.putValue("LimeShortName", "");
            this.putValue("ShortDescription", GUIMediator.getStringResource("DOWNLOAD_PRIORITY_UP_BUTTON_TIP"));
            this.putValue("LimeIconName", "DOWNLOAD_PRIORITY_UP");
        }

        public void actionPerformed(ActionEvent e) {
            if ((e.getModifiers() & 2) != 0) {
                DownloadMediator.this.bumpPriority(true, 10);
            } else if ((e.getModifiers() & 8) != 0) {
                DownloadMediator.this.bumpPriority(true, 0);
            } else {
                DownloadMediator.this.bumpPriority(true, 1);
            }
        }
    }

    private class ExploreAction
    extends AbstractAction {
        public ExploreAction() {
            this.putValue("Name", GUIMediator.getStringResource("LIBRARY_EXPLORE_BUTTON_LABEL"));
            this.putValue("LimeShortName", GUIMediator.getStringResource("LIBRARY_EXPLORE_BUTTON_LABEL"));
            this.putValue("ShortDescription", GUIMediator.getStringResource("DOWNLOAD_EXPLORE_BUTTON_TIP"));
            this.putValue("LimeIconName", "LIBRARY_EXPLORE");
        }

        public void actionPerformed(ActionEvent e) {
            DownloadMediator.this.launchExplorer();
        }
    }

    private class PauseAction
    extends AbstractAction {
        public PauseAction() {
            this.putValue("Name", GUIMediator.getStringResource("DOWNLOAD_POPUP_MENU_PAUSE"));
            this.putValue("LimeShortName", GUIMediator.getStringResource("DOWNLOAD_PAUSE_BUTTON_LABEL"));
            this.putValue("ShortDescription", GUIMediator.getStringResource("DOWNLOAD_PAUSE_BUTTON_TIP"));
            this.putValue("LimeIconName", "DOWNLOAD_PAUSE");
        }

        public void actionPerformed(ActionEvent e) {
            DownloadMediator.this.pauseSelectedDownloads();
        }
    }

    private class ResumeAction
    extends AbstractAction {
        public ResumeAction() {
            this.putValue("Name", GUIMediator.getStringResource("DOWNLOAD_POPUP_MENU_RESUME"));
            this.putValue("LimeShortName", GUIMediator.getStringResource("DOWNLOAD_RESUME_BUTTON_LABEL"));
            this.putValue("ShortDescription", GUIMediator.getStringResource("DOWNLOAD_RESUME_BUTTON_TIP"));
            this.putValue("LimeIconName", "DOWNLOAD_FILE_MORE_SOURCES");
        }

        public void actionPerformed(ActionEvent e) {
            DownloadMediator.this.resumeSelectedDownloads();
        }
    }

    private class LaunchAction
    extends AbstractAction {
        public LaunchAction() {
            this.putValue("Name", GUIMediator.getStringResource("DOWNLOAD_POPUP_MENU_LAUNCH"));
            this.putValue("LimeShortName", GUIMediator.getStringResource("DOWNLOAD_LAUNCH_BUTTON_LABEL"));
            this.putValue("ShortDescription", GUIMediator.getStringResource("DOWNLOAD_LAUNCH_BUTTON_TIP"));
            this.putValue("LimeIconName", "DOWNLOAD_LAUNCH");
        }

        public void actionPerformed(ActionEvent e) {
            DownloadMediator.this.launchSelectedDownloads();
        }
    }

    private class BrowseAction
    extends AbstractAction {
        public BrowseAction() {
            this.putValue("Name", GUIMediator.getStringResource("DOWNLOAD_POPUP_MENU_BROWSE"));
        }

        public void actionPerformed(ActionEvent e) {
            DownloadMediator.this.browseSelectedDownloads();
        }
    }

    private class ClearAction
    extends AbstractAction {
        public ClearAction() {
            this.putValue("Name", GUIMediator.getStringResource("DOWNLOAD_POPUP_MENU_CLEAR"));
            this.putValue("LimeShortName", GUIMediator.getStringResource("DOWNLOAD_CLEAR_BUTTON_LABEL"));
            this.putValue("ShortDescription", GUIMediator.getStringResource("DOWNLOAD_CLEAR_BUTTON_TIP"));
            this.putValue("LimeIconName", "DOWNLOAD_CLEAR");
        }

        public void actionPerformed(ActionEvent e) {
            DownloadMediator.this.clearCompletedDownloads();
        }
    }

    private class ChatAction
    extends AbstractAction {
        public ChatAction() {
            this.putValue("Name", GUIMediator.getStringResource("DOWNLOAD_POPUP_MENU_CHAT"));
        }

        public void actionPerformed(ActionEvent e) {
            DownloadMediator.this.chatWithSelectedDownloads();
        }
    }

    private class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            this.putValue("Name", GUIMediator.getStringResource("DOWNLOAD_POPUP_MENU_KILL_DOWNLOAD"));
            this.putValue("LimeShortName", GUIMediator.getStringResource("DOWNLOAD_KILL_BUTTON_LABEL"));
            this.putValue("ShortDescription", GUIMediator.getStringResource("DOWNLOAD_KILL_BUTTON_TIP"));
            this.putValue("LimeIconName", "DOWNLOAD_KILL");
        }

        public void actionPerformed(ActionEvent e) {
            DownloadMediator.this.removeSelection();
        }
    }
}

