/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.download;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.download.DownloadMediator;
import com.limegroup.gnutella.gui.download.DownloaderFactory;
import com.limegroup.gnutella.gui.download.DownloaderUtils;
import com.limegroup.gnutella.gui.util.CoreExceptionHandler;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class DownloaderDialog
extends JDialog {
    public static final int DEFAULT_ASK = 0;
    public static final int DEFAULT_APPEND = 1;
    public static final int DEFAULT_SAVE_AS = 2;
    private DownloaderFactory factory;
    private Downloader downloader;
    private JLabel titleLabel = new JLabel();
    private JLabel descLabel = new JLabel();
    private JLabel noteLabel = new JLabel();
    private ButtonRow buttons;
    private File originalFile;

    private DownloaderDialog(DownloaderFactory factory, SaveLocationException sle) {
        super(GUIMediator.getAppFrame());
        this.factory = factory;
        this.originalFile = sle.getFile();
        int defaultAction = QuestionsHandler.DEFAULT_ACTION_FILE_EXISTS.getValue();
        if (defaultAction != 0) {
            if (defaultAction == 1) {
                new AppendAction().actionPerformed(new ActionEvent(this, 0, null));
            } else if (defaultAction == 2) {
                new SaveAsAction().actionPerformed(new ActionEvent(this, 0, null));
            }
            return;
        }
        this.setUpDialog(sle);
    }

    private void setUpDialog(SaveLocationException sle) {
        this.setModal(true);
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        GUIUtils.addHideAction((JComponent)this.getContentPane());
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)topPanel, "Center");
        JPanel mainPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)mainPanel, "North");
        Color bg = UIManager.getColor("TextField.background");
        Color fg = UIManager.getColor("TextField.foreground");
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBackground(bg);
        titlePanel.setBorder(BorderFactory.createEtchedBorder());
        JLabel icon = new JLabel(GUIMediator.getThemeImage("warning"));
        icon.setBackground(bg);
        icon.setBorder(new EmptyBorder(2, 5, 2, 5));
        titlePanel.add((Component)icon, "West");
        this.titleLabel.setBackground(bg);
        this.titleLabel.setForeground(fg);
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        titlePanel.add((Component)this.titleLabel, "Center");
        mainPanel.add((Component)titlePanel, "North");
        Box labelBox = Box.createVerticalBox();
        labelBox.add(this.descLabel);
        labelBox.add(Box.createVerticalStrut(10));
        labelBox.add(this.noteLabel);
        labelBox.add(Box.createVerticalStrut(5));
        labelBox.add(Box.createVerticalGlue());
        mainPanel.add((Component)labelBox, "Center");
        JRadioButton saveAs = new JRadioButton(GUIMediator.getStringResource("DOWNLOADER_DIALOG_DEFAULT_ACTION_SAVE_AS_LABEL"));
        JRadioButton append = new JRadioButton(GUIMediator.getStringResource("DOWNLOADER_DIALOG_DEFAULT_ACTION_APPEND_LABEL"));
        JRadioButton ask = new JRadioButton(GUIMediator.getStringResource("DOWNLOADER_DIALOG_DEFAULT_ACTION_ASK_LABEL"));
        this.setupDefaultOption(saveAs, 2);
        this.setupDefaultOption(append, 1);
        this.setupDefaultOption(ask, 0);
        ButtonGroup group = new ButtonGroup();
        group.add(ask);
        group.add(append);
        group.add(saveAs);
        JLabel alwaysLabel = new JLabel(GUIMediator.getStringResource("DOWNLOADER_DIALOG_DEFAULT_ACTION_LABEL"));
        Box alwaysLabelBox = Box.createHorizontalBox();
        alwaysLabelBox.add(alwaysLabel);
        alwaysLabelBox.add(Box.createHorizontalGlue());
        Box alwaysBox = Box.createHorizontalBox();
        alwaysBox.add(Box.createHorizontalStrut(20));
        alwaysBox.add(ask);
        alwaysBox.add(Box.createHorizontalStrut(15));
        alwaysBox.add(saveAs);
        alwaysBox.add(Box.createHorizontalStrut(15));
        alwaysBox.add(append);
        alwaysBox.add(Box.createHorizontalGlue());
        Box outerAlways = Box.createVerticalBox();
        outerAlways.add(alwaysLabelBox);
        outerAlways.add(alwaysBox);
        outerAlways.add(Box.createVerticalStrut(15));
        topPanel.add((Component)outerAlways, "Center");
        this.buttons = new ButtonRow(new Action[]{new OverWriteAction(), new SaveAsAction(), new AppendAction(), new CancelAction()}, 0, 12);
        topPanel.add((Component)this.buttons, "South");
        this.setContentFromException(sle);
        this.pack();
    }

    private void setupDefaultOption(JRadioButton button, final int option) {
        if (QuestionsHandler.DEFAULT_ACTION_FILE_EXISTS.getValue() == option) {
            button.setSelected(true);
        }
        button.setFocusable(false);
        button.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    QuestionsHandler.DEFAULT_ACTION_FILE_EXISTS.setValue(option);
                }
            }
        });
    }

    private void setLabel(JLabel label, String text) {
        StringBuffer buffer = new StringBuffer("<html><table><tr><td width=\"400\">");
        buffer.append(text);
        buffer.append("</td></tr></html>");
        label.setText(buffer.toString());
    }

    private void setContentFromException(SaveLocationException sle) {
        if (sle.getErrorCode() == 10) {
            this.dispose();
            DownloaderUtils.showIsAlreadyDownloadingWarning(this.factory);
            return;
        }
        if (this.buttons == null) {
            this.setUpDialog(sle);
            this.setLocationRelativeTo(MessageService.getParentComponent());
            this.setVisible(true);
            return;
        }
        String error = CoreExceptionHandler.getSaveLocationErrorString(sle, true);
        if (sle.getErrorCode() == 5) {
            this.setTitleLabel(MessageFormat.format(GUIMediator.getStringResource("DOWNLOADER_DIALOG_WARNING_LABEL"), CoreExceptionHandler.getShortSaveLocationErrorString(sle)));
            this.setDescLabel(error);
        } else {
            this.setTitleLabel(MessageFormat.format(GUIMediator.getStringResource("DOWNLOADER_DIALOG_ERROR_LABEL"), CoreExceptionHandler.getShortSaveLocationErrorString(sle)));
            this.setDescLabel(error);
        }
        FileDesc desc = DownloaderUtils.getFromLibrary(this.factory.getURN());
        if (desc != null) {
            this.setNoteLabel(MessageFormat.format(GUIMediator.getStringResource("DOWNLOADER_DIALOG_NOTE_LABEL"), "<i>" + GUIUtils.convertToNonBreakingSpaces(0, desc.getFile().toString()) + "</i>"));
        }
        this.buttons.getButtonAtIndex(0).setVisible(sle.getErrorCode() == 5);
    }

    private void setTitleLabel(String text) {
        this.setTitle(text);
        this.titleLabel.setText(text);
    }

    private void setDescLabel(String text) {
        this.setLabel(this.descLabel, text);
    }

    private void setNoteLabel(String text) {
        this.setLabel(this.noteLabel, text);
    }

    public static Downloader handle(DownloaderFactory factory, SaveLocationException sle) {
        if (sle.getErrorCode() == 10) {
            DownloaderUtils.showIsAlreadyDownloadingWarning(factory);
            return null;
        }
        int defaultAction = QuestionsHandler.DEFAULT_ACTION_FILE_EXISTS.getValue();
        DownloaderDialog dlg = new DownloaderDialog(factory, sle);
        if (defaultAction == 0) {
            dlg.setLocationRelativeTo(MessageService.getParentComponent());
            dlg.setVisible(true);
        }
        return dlg.getDownloader();
    }

    public Downloader getDownloader() {
        return this.downloader;
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", GUIMediator.getStringResource("GENERAL_CANCEL_BUTTON_LABEL"));
            this.putValue("ShortDescription", GUIMediator.getStringResource("DOWNLOADER_DIALOG_CANCEL_ACTION_SHORT_DESCRIPTION"));
        }

        public void actionPerformed(ActionEvent e) {
            DownloaderDialog.this.dispose();
        }
    }

    private class AppendAction
    extends AbstractAction {
        public AppendAction() {
            this.putValue("Name", GUIMediator.getStringResource("DOWNLOADER_DIALOG_APPEND_ACTION_NAME"));
            this.putValue("ShortDescription", GUIMediator.getStringResource("DOWNLOADER_DIALOG_APPEND_ACTION_SHORT_DESCRIPTION"));
        }

        public void actionPerformed(ActionEvent e) {
            String originalName;
            String preExt = originalName = DownloaderDialog.this.originalFile.getName();
            String ext = "";
            int dot = originalName.lastIndexOf(".");
            if (dot != -1) {
                preExt = originalName.substring(0, dot);
                ext = originalName.substring(dot);
            }
            Set downloads = DownloadMediator.instance().getFileNames();
            File newFile = DownloaderDialog.this.originalFile;
            String newName = originalName;
            int i = 1;
            while (newFile.exists() || downloads.contains(newName)) {
                newName = preExt + "(" + i + ")" + ext;
                newFile = new File(DownloaderDialog.this.originalFile.getParent(), newName);
                ++i;
            }
            try {
                DownloaderDialog.this.factory.setSaveFile(newFile);
                DownloaderDialog.this.downloader = DownloaderDialog.this.factory.createDownloader(false);
                DownloaderDialog.this.dispose();
            }
            catch (SaveLocationException sle) {
                DownloaderDialog.this.setContentFromException(sle);
            }
        }
    }

    private class SaveAsAction
    extends AbstractAction {
        public SaveAsAction() {
            this.putValue("Name", GUIMediator.getStringResource("DOWNLOADER_DIALOG_SAVE_AS_ACTION_NAME"));
            this.putValue("ShortDescription", GUIMediator.getStringResource("DOWNLOADER_DIALOG_SAVE_AS_ACTION_SHORT_DESCRIPTION"));
        }

        public void actionPerformed(ActionEvent e) {
            File file = DownloaderUtils.showFileChooser(DownloaderDialog.this.factory, DownloaderDialog.this);
            if (file != null) {
                try {
                    DownloaderDialog.this.factory.setSaveFile(file);
                    DownloaderDialog.this.downloader = DownloaderDialog.this.factory.createDownloader(CommonUtils.isAnyMac());
                    DownloaderDialog.this.dispose();
                }
                catch (SaveLocationException sle) {
                    DownloaderDialog.this.setContentFromException(sle);
                }
            }
        }
    }

    private class OverWriteAction
    extends AbstractAction {
        public OverWriteAction() {
            this.putValue("Name", GUIMediator.getStringResource("DOWNLOADER_DIALOG_OVERWRITE_ACTION_SHORT_NAME"));
            this.putValue("ShortDescription", GUIMediator.getStringResource("DOWNLOADER_DIALOG_OVERWRITE_ACTION_SHORT_DESCRIPTION"));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                DownloaderDialog.this.downloader = DownloaderDialog.this.factory.createDownloader(true);
                DownloaderDialog.this.dispose();
            }
            catch (SaveLocationException sle) {
                DownloaderDialog.this.setContentFromException(sle);
            }
        }
    }
}

