/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class SaveWindow
extends SetupWindow {
    private final JTextField SAVE_FIELD = new JTextField(20);
    private String _defaultSaveDir;

    SaveWindow(SetupManager manager) {
        super(manager, "SETUP_SAVE_TITLE", "SETUP_SAVE_LABEL");
    }

    protected void createWindow() {
        super.createWindow();
        File saveDir = SharingSettings.getSaveDirectory();
        try {
            this._defaultSaveDir = saveDir.getCanonicalPath();
        }
        catch (IOException e) {
            this._defaultSaveDir = saveDir.getAbsolutePath();
        }
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 6, 6);
        mainPanel.add((Component)new JLabel(GUIMediator.getStringResource("INIT_SAVE_DIRECTORY_FIELD_LABEL")), gbc);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 6, 0);
        gbc.gridwidth = 0;
        mainPanel.add((Component)this.SAVE_FIELD, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        mainPanel.add((Component)new ButtonRow(new Action[]{new DefaultAction(), new BrowseAction()}, 0, 12), gbc);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 3;
        gbc.weighty = 1.0;
        mainPanel.add((Component)new JPanel(), gbc);
        try {
            this.SAVE_FIELD.setText(this._defaultSaveDir);
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        this.setSetupComponent(mainPanel);
    }

    public void applySettings() throws ApplySettingsException {
        try {
            String saveDirString = this.SAVE_FIELD.getText();
            File saveDir = new File(saveDirString);
            if (!saveDir.isDirectory() && !saveDir.mkdirs()) {
                throw new IOException();
            }
            SharingSettings.setSaveDirectory(saveDir);
            SharingSettings.DIRECTORIES_TO_SHARE.add(saveDir);
        }
        catch (IOException ioe) {
            String msgKey = "MESSAGE_INVALID_SAVE_DIRECTORY";
            throw new ApplySettingsException(msgKey);
        }
    }

    private class BrowseAction
    extends AbstractAction {
        public BrowseAction() {
            this.putValue("Name", GUIMediator.getStringResource("INIT_SAVE_BROWSE_BUTTON_LABEL"));
            this.putValue("ShortDescription", GUIMediator.getStringResource("INIT_SAVE_BROWSE_BUTTON_TIP"));
        }

        public void actionPerformed(ActionEvent e) {
            File saveDir = FileChooserHandler.getInputDirectory(SaveWindow.this);
            if (saveDir == null || !saveDir.isDirectory()) {
                return;
            }
            SaveWindow.this.SAVE_FIELD.setText(saveDir.getAbsolutePath());
        }
    }

    private class DefaultAction
    extends AbstractAction {
        public DefaultAction() {
            this.putValue("Name", GUIMediator.getStringResource("INIT_SAVE_DEFAULT_BUTTON_LABEL"));
            this.putValue("ShortDescription", GUIMediator.getStringResource("INIT_SAVE_DEFAULT_BUTTON_TIP"));
        }

        public void actionPerformed(ActionEvent e) {
            SaveWindow.this.SAVE_FIELD.setText(SaveWindow.this._defaultSaveDir);
        }
    }
}

