/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.init.ScanConfirmWindow;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.limegroup.gnutella.gui.init.WaitWindow;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

final class ScanWindow
extends SetupWindow {
    private JRadioButton yesButton;
    private SetupWindow progressWindow;
    private SetupWindow confirmWindow;

    ScanWindow(SetupManager manager) {
        super(manager, "SETUP_SCAN_TITLE", "SETUP_SCAN_LABEL");
        this.progressWindow = new WaitWindow(manager);
        this.confirmWindow = new ScanConfirmWindow(manager);
        manager.add(this.progressWindow);
        manager.add(this.confirmWindow);
    }

    protected void createWindow() {
        super.createWindow();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.yesButton = new JRadioButton(GUIMediator.getStringResource("YES"));
        JRadioButton noButton = new JRadioButton(GUIMediator.getStringResource("NO"));
        JPanel mainPanel = new JPanel(new GridBagLayout());
        JPanel buttonPanel = new JPanel(new GridLayout(2, 1));
        buttonPanel.setBorder(new TitledBorder(GUIMediator.getStringResource("SETUP_SCAN_TITLED_BORDER")));
        buttonGroup.add(this.yesButton);
        buttonGroup.add(noButton);
        this.yesButton.setSelected(true);
        buttonPanel.add(this.yesButton);
        buttonPanel.add(noButton);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        mainPanel.add((Component)buttonPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 3;
        gbc.weighty = 1.0;
        gbc.gridwidth = 0;
        mainPanel.add((Component)new JPanel(), gbc);
        this.setSetupComponent(mainPanel);
    }

    public SetupWindow getNext() {
        if (this.yesButton.isSelected()) {
            this.progressWindow.setPrevious(this);
            this.progressWindow.setNext(this.confirmWindow);
            this.confirmWindow.setPrevious(this);
            if (super.getNext() != this) {
                this.confirmWindow.setNext(super.getNext());
                super.getNext().setPrevious(this.confirmWindow);
            } else {
                this.confirmWindow.setNext(this.confirmWindow);
            }
            return this.progressWindow;
        }
        super.getNext().setPrevious(this);
        return super.getNext();
    }
}

