/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.SplashWindow;
import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.FileScan;
import com.limegroup.gnutella.gui.init.FilterWindow;
import com.limegroup.gnutella.gui.init.FinishWindow;
import com.limegroup.gnutella.gui.init.FirewallWindow;
import com.limegroup.gnutella.gui.init.LanguageWindow;
import com.limegroup.gnutella.gui.init.ProgressMonitor;
import com.limegroup.gnutella.gui.init.SaveWindow;
import com.limegroup.gnutella.gui.init.ScanWindow;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.limegroup.gnutella.gui.init.SetupWindowHolder;
import com.limegroup.gnutella.gui.init.SpeedWindow;
import com.limegroup.gnutella.gui.init.StartupWindow;
import com.limegroup.gnutella.gui.init.WelcomeWindow;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.InstallSettings;
import com.limegroup.gnutella.settings.SettingsHandler;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.SystemUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class SetupManager {
    private JDialog _dialog;
    private SetupWindowHolder _setupWindowHolder = new SetupWindowHolder();
    private SetupWindow _currentWindow;
    private String[] _scannedPaths;
    public static final int ACTION_PREVIOUS = 1;
    public static final int ACTION_NEXT = 2;
    public static final int ACTION_FINISH = 4;
    public static final int ACTION_CANCEL = 8;
    private PreviousAction previousAction = new PreviousAction();
    private NextAction nextAction = new NextAction();
    private FinishAction finishAction = new FinishAction();
    private CancelAction cancelAction = new CancelAction();
    private LanguageAwareAction[] actions = new LanguageAwareAction[]{this.previousAction, this.nextAction, this.finishAction, this.cancelAction};

    public SetupManager() {
        if (ApplicationSettings.INSTALLED.getValue()) {
            InstallSettings.SAVE_DIRECTORY.setValue(true);
            InstallSettings.SPEED.setValue(true);
            InstallSettings.SCAN_FILES.setValue(true);
        }
    }

    private boolean shouldShowStartOnStartupWindow() {
        if (InstallSettings.START_STARTUP.getValue()) {
            return false;
        }
        return GUIUtils.shouldShowStartOnStartupWindow();
    }

    public boolean shouldShowFirewallWindow() {
        if (InstallSettings.FIREWALL_WARNING.getValue()) {
            return false;
        }
        if (!CommonUtils.isWindows()) {
            return false;
        }
        return !SystemUtils.isFirewallPresent() || !SystemUtils.isFirewallEnabled();
    }

    public void createIfNeeded() {
        LinkedList<SetupWindow> windows = new LinkedList<SetupWindow>();
        if (!InstallSettings.LANGUAGE_CHOICE.getValue()) {
            windows.add(new LanguageWindow(this));
        }
        if (!InstallSettings.SAVE_DIRECTORY.getValue()) {
            windows.add(new SaveWindow(this));
        }
        if (!InstallSettings.SPEED.getValue()) {
            windows.add(new SpeedWindow(this));
        }
        if (this.shouldShowStartOnStartupWindow()) {
            windows.add(new StartupWindow(this));
        }
        if (this.shouldShowFirewallWindow()) {
            windows.add(new FirewallWindow(this));
        }
        if (!InstallSettings.FILTER_OPTION.getValue()) {
            windows.add(new FilterWindow(this));
        }
        if (!InstallSettings.SCAN_FILES.getValue()) {
            windows.add(new ScanWindow(this));
        }
        if (windows.size() == 0) {
            return;
        }
        boolean partial = ApplicationSettings.INSTALLED.getValue();
        if (windows.get(0) instanceof LanguageWindow) {
            if (windows.size() > 1) {
                windows.add(1, new WelcomeWindow(this, partial));
                windows.add(new FinishWindow(this));
            }
        } else {
            windows.add(0, new WelcomeWindow(this, partial));
            windows.add(new FinishWindow(this));
        }
        SetupWindow prior = null;
        SetupWindow current = null;
        Iterator i = windows.iterator();
        while (i.hasNext()) {
            current = (SetupWindow)i.next();
            this._setupWindowHolder.add(current);
            if (prior == null) {
                current.setPrevious(current);
            } else {
                current.setPrevious(prior);
            }
            if (prior != null) {
                prior.setNext(current);
            }
            prior = current;
        }
        current.setNext(current);
        this.createDialog((SetupWindow)windows.get(0));
    }

    private void createDialog(SetupWindow firstWindow) {
        this._dialog = new JDialog();
        this._dialog.setModal(true);
        this._dialog.setTitle(GUIMediator.getStringResource("SETUP_DIALOG_TITLE"));
        if (!CommonUtils.isUnix()) {
            this._dialog.setResizable(false);
        }
        this._dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SetupManager.this.cancelSetup();
            }
        });
        GUIUtils.addHideAction((JComponent)this._dialog.getContentPane());
        Container container = this._dialog.getContentPane();
        BoxLayout containerLayout = new BoxLayout(container, 1);
        container.setLayout(containerLayout);
        JPanel setupPanel = new JPanel();
        setupPanel.setBorder(new EmptyBorder(1, 0, 0, 0));
        BoxLayout layout = new BoxLayout(setupPanel, 1);
        setupPanel.setLayout(layout);
        Dimension d = new Dimension(540, 360);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this._dialog.setLocation((screenSize.width - d.width) / 2, (screenSize.height - d.height) / 2);
        setupPanel.add(this._setupWindowHolder);
        setupPanel.add(Box.createVerticalStrut(17));
        ButtonRow buttons = new ButtonRow(this.actions, 0, 12);
        buttons.setBorder(new EmptyBorder(5, 5, 5, 5));
        setupPanel.add(buttons);
        this.show(firstWindow);
        container.add(setupPanel);
        ((JComponent)container).setPreferredSize(new Dimension(540, 360));
        this._dialog.pack();
        this._dialog.toFront();
        SplashWindow.instance().toBack();
        this._dialog.setVisible(true);
    }

    public void enableActions(int actions) {
        this.previousAction.setEnabled((actions & 1) != 0);
        this.nextAction.setEnabled((actions & 2) != 0);
        this.finishAction.setEnabled((actions & 4) != 0);
        this.cancelAction.setEnabled((actions & 8) != 0);
    }

    public int getEnabledActions() {
        int actions = 0;
        if (this.previousAction.isEnabled()) {
            actions |= 1;
        }
        if (this.nextAction.isEnabled()) {
            actions |= 2;
        }
        if (this.finishAction.isEnabled()) {
            actions |= 4;
        }
        if (this.cancelAction.isEnabled()) {
            actions |= 8;
        }
        return actions;
    }

    public void next() {
        SetupWindow newWindow = this._currentWindow.getNext();
        try {
            this._currentWindow.applySettings();
            this.show(newWindow);
        }
        catch (ApplySettingsException ase) {
            GUIMediator.showError(ase.getMessage());
        }
    }

    public void previous() {
        SetupWindow newWindow = this._currentWindow.getPrevious();
        this.show(newWindow);
    }

    public void scan(ProgressMonitor monitor) {
        this._scannedPaths = this.scanDrive(monitor);
    }

    public String[] getScannedPaths() {
        return this._scannedPaths;
    }

    public void cancelSetup() {
        this._dialog.dispose();
        System.exit(0);
    }

    public void finishSetup() {
        this._dialog.dispose();
        ApplicationSettings.INSTALLED.setValue(true);
        InstallSettings.SAVE_DIRECTORY.setValue(true);
        InstallSettings.SPEED.setValue(true);
        InstallSettings.SCAN_FILES.setValue(true);
        InstallSettings.LANGUAGE_CHOICE.setValue(true);
        InstallSettings.FILTER_OPTION.setValue(true);
        if (GUIUtils.shouldShowStartOnStartupWindow()) {
            // empty if block
        }
        InstallSettings.START_STARTUP.setValue(true);
        if (CommonUtils.isWindows()) {
            InstallSettings.FIREWALL_WARNING.setValue(true);
        }
        SettingsHandler.save();
    }

    public void updateLanguage() {
        for (int i = 0; i < this.actions.length; ++i) {
            this.actions[i].updateLanguage();
        }
    }

    private void show(SetupWindow window) {
        window.handleWindowOpeningEvent();
        this._setupWindowHolder.show(window.getKey());
        this._currentWindow = window;
    }

    void add(SetupWindow window) {
        this._setupWindowHolder.add((Component)window, window.getKey());
    }

    private String[] scanDrive(ProgressMonitor monitor) {
        FileScan fs = new FileScan(monitor);
        String[] filters = new String[]{"Recycle", "Incomplete", "LimeWire", "Microsoft", "bin", "system", "WINNT", "usr", "dev", "proc", "var"};
        fs.setDirectoryBlackList(filters);
        File root = this.getRoot(CommonUtils.getCurrentDirectory());
        fs.scan(root);
        return fs.getListAsArray();
    }

    private File getRoot(File f) {
        File parent = f.getParentFile();
        while (parent != null) {
            f = parent;
            parent = f.getParentFile();
        }
        return f;
    }

    private class FinishAction
    extends LanguageAwareAction {
        public FinishAction() {
            super("GENERAL_FINISH_BUTTON_LABEL");
        }

        public void actionPerformed(ActionEvent e) {
            SetupManager.this.finishSetup();
        }
    }

    private class PreviousAction
    extends LanguageAwareAction {
        public PreviousAction() {
            super("GENERAL_BACK_BUTTON_LABEL");
        }

        public void actionPerformed(ActionEvent e) {
            SetupManager.this.previous();
        }
    }

    private class NextAction
    extends LanguageAwareAction {
        public NextAction() {
            super("GENERAL_NEXT_BUTTON_LABEL");
        }

        public void actionPerformed(ActionEvent e) {
            SetupManager.this.next();
        }
    }

    private class CancelAction
    extends LanguageAwareAction {
        public CancelAction() {
            super("GENERAL_CANCEL_BUTTON_LABEL");
        }

        public void actionPerformed(ActionEvent e) {
            SetupManager.this.cancelSetup();
        }
    }

    private abstract class LanguageAwareAction
    extends AbstractAction {
        private String nameKey;

        public LanguageAwareAction(String nameKey) {
            super(GUIMediator.getStringResource(nameKey));
            this.nameKey = nameKey;
        }

        public void updateLanguage() {
            this.putValue("Name", GUIMediator.getStringResource(this.nameKey));
        }
    }
}

