/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.library.DirectoryHolder;
import com.limegroup.gnutella.gui.library.ExploreListener;
import com.limegroup.gnutella.gui.library.IncompleteDirectoryHolder;
import com.limegroup.gnutella.gui.library.LibraryTableMediator;
import com.limegroup.gnutella.gui.library.LibraryTree;
import com.limegroup.gnutella.gui.library.RefreshListener;
import com.limegroup.gnutella.gui.library.SavedFilesDirectoryHolder;
import com.limegroup.gnutella.gui.options.ConfigureOptionsAction;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.gui.util.DividerLocationSettingUpdater;
import com.limegroup.gnutella.settings.UISettings;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public final class LibraryMediator
implements ThemeObserver {
    private static final JPanel MAIN_PANEL = new JPanel(new GridBagLayout());
    private static final CardLayout viewLayout = new CardLayout();
    private static final JPanel viewPanel = new JPanel(viewLayout);
    private static final LibraryTree LIBRARY_TREE = LibraryTree.instance();
    private static final JScrollPane TREE_SCROLL_PANE;
    private static final LibraryTableMediator LIBRARY_TABLE;
    private static final String TABLE_KEY = "LIBRARY_TABLE";
    private static final String SHARED_KEY = "SHARED";
    private final HandleFileUpdate FILE_UPDATER = new HandleFileUpdate();
    private static JPanel jpShared;
    private static final LibraryMediator INSTANCE;

    public static LibraryMediator instance() {
        return INSTANCE;
    }

    private LibraryMediator() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_LIBRARY_WINDOW"));
        ThemeMediator.addThemeObserver(this);
        LibraryMediator.addView(LIBRARY_TABLE.getScrolledTablePane(), TABLE_KEY);
        JSplitPane splitPane = new JSplitPane(1, TREE_SCROLL_PANE, viewPanel);
        splitPane.setOneTouchExpandable(true);
        new DividerLocationSettingUpdater(splitPane, UISettings.UI_LIBRARY_TREE_DIVIDER_LOCATION);
        String[] refreshKey = new String[]{"LIBRARY_REFRESH_BUTTON_LABEL"};
        String[] refreshTip = new String[]{"LIBRARY_REFRESH_BUTTON_TIP"};
        ActionListener[] refreshListener = new ActionListener[]{new RefreshListener()};
        String[] refreshName = new String[]{"LIBRARY_REFRESH"};
        ButtonRow refreshButton = new ButtonRow(refreshKey, refreshTip, refreshListener, refreshName);
        String[] exploreKey = new String[]{"LIBRARY_EXPLORE_BUTTON_LABEL"};
        String[] exploreTip = new String[]{"LIBRARY_EXPLORE_BUTTON_TIP"};
        ActionListener[] exploreListener = new ActionListener[]{new ExploreListener()};
        String[] exploreName = new String[]{"LIBRARY_EXPLORE"};
        ButtonRow exploreButton = new ButtonRow(exploreKey, exploreTip, exploreListener, exploreName);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        buttonPanel.add((Component)refreshButton, gbc);
        gbc.gridx = -1;
        if (CommonUtils.isWindows() || CommonUtils.isMacOSX()) {
            buttonPanel.add((Component)exploreButton, gbc);
        }
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        gbc.fill = 2;
        buttonPanel.add((Component)LIBRARY_TABLE.getButtonRow(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(6, 6, 6, 6);
        MAIN_PANEL.add((Component)splitPane, gbc);
        gbc.gridy = 1;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 6, 6, 6);
        MAIN_PANEL.add((Component)buttonPanel, gbc);
        this.updateTheme();
        LIBRARY_TREE.setInitialSelection();
    }

    public void updateTheme() {
        LIBRARY_TREE.updateTheme();
        Color tableColor = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
        TREE_SCROLL_PANE.getViewport().setBackground(tableColor);
    }

    public JComponent getComponent() {
        return MAIN_PANEL;
    }

    public void launchLibraryFile() {
        LIBRARY_TABLE.launch();
    }

    public void deleteLibraryFile() {
        LIBRARY_TABLE.removeSelection();
    }

    public void clearLibrary() {
        LIBRARY_TREE.clear();
    }

    public void quickRefresh() {
        DirectoryHolder dh = LIBRARY_TREE.getSelectedDirectoryHolder();
        if (dh instanceof SavedFilesDirectoryHolder || dh instanceof IncompleteDirectoryHolder) {
            LibraryMediator.updateTableFiles(dh);
        }
    }

    public static void launchExplorer() {
        File exploreDir = LIBRARY_TREE.getSelectedDirectory();
        if (exploreDir == null) {
            return;
        }
        String explorePath = exploreDir.getPath();
        try {
            explorePath = exploreDir.getCanonicalPath();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            String cmdStr = "";
            if (CommonUtils.isWindows()) {
                cmdStr = "explorer";
            } else if (CommonUtils.isMacOSX()) {
                cmdStr = "open";
            }
            Runtime.getRuntime().exec(new String[]{cmdStr, explorePath});
        }
        catch (SecurityException se) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void handleFileManagerEvent(FileManagerEvent evt) {
        LIBRARY_TREE.handleFileManagerEvent(evt);
        LIBRARY_TABLE.handleFileManagerEvent(evt, LIBRARY_TREE.getSelectedDirectoryHolder());
    }

    public void addSharedLibraryFolder() {
        File dir = FileChooserHandler.getInputDirectory();
        if (dir == null) {
            return;
        }
        this.addSharedLibraryFolder(dir);
    }

    public void addSharedLibraryFolder(final File dir) {
        if (dir == null || !dir.isDirectory() || !dir.canRead()) {
            GUIMediator.showError("ERROR_INVALID_SHARED_DIRECTORY");
            return;
        }
        GUIMediator.instance().schedule(new Runnable(){

            public void run() {
                RouterService.getFileManager().addSharedFolder(dir);
            }
        });
    }

    public void updateSharedFile(File file) {
        DirectoryHolder dh = LIBRARY_TREE.getSelectedDirectoryHolder();
        if (LIBRARY_TABLE.getTable().isShowing() && dh != null && dh.accept(file)) {
            this.FILE_UPDATER.addFileUpdate(file);
        }
    }

    public void setAnnotateEnabled(boolean enabled) {
        LIBRARY_TABLE.setAnnotateEnabled(enabled);
    }

    public void unshareLibraryFolder() {
        LIBRARY_TREE.unshareLibraryFolder();
    }

    void addFileToPlayList(File toAdd) {
        GUIMediator.getPlayList().addFileToPlaylist(toAdd);
    }

    static void updateTableFiles(DirectoryHolder dirHolder) {
        LIBRARY_TABLE.updateTableFiles(dirHolder);
        LibraryMediator.showView(TABLE_KEY);
    }

    public static boolean incompleteDirectoryIsSelected() {
        return LIBRARY_TREE.incompleteDirectoryIsSelected();
    }

    public static void showSharedFiles() {
        if (jpShared == null) {
            jpShared = new JPanel(new BorderLayout());
            JPanel jpInternal = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(0, 0, 6, 0);
            jpInternal.add((Component)new JLabel(GUIMediator.getStringResource("LIBRARY_SHARED_FILES_CONFIGURE_EXPLAIN")), gbc);
            gbc.gridy = 1;
            jpInternal.add((Component)new JButton(new ConfigureOptionsAction("OPTIONS_SHARED_MAIN_TITLE", "LIBRARY_SHARED_FILES_CONFIGURE", "LIBRARY_SHARED_FILES_CONFIGURE_EXPLAIN")), gbc);
            jpShared.add((Component)jpInternal, "Center");
            jpShared.setBorder(BorderFactory.createEtchedBorder());
            LibraryMediator.addView(jpShared, SHARED_KEY);
        }
        LibraryMediator.showView(SHARED_KEY);
    }

    public static void showView(String key) {
        viewLayout.show(viewPanel, key);
    }

    public static void addView(Component c, String key) {
        viewPanel.add(c, key);
    }

    public static boolean setSelectedDirectory(File dir) {
        return LIBRARY_TREE.setSelectedDirectory(dir);
    }

    public void setPlayerEnabled(boolean value) {
        LIBRARY_TABLE.setPlayerEnabled(value);
        LIBRARY_TREE.setPlayerEnabled(value);
    }

    static {
        LIBRARY_TREE.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        TREE_SCROLL_PANE = new JScrollPane(LIBRARY_TREE);
        LIBRARY_TABLE = LibraryTableMediator.instance();
        jpShared = null;
        INSTANCE = new LibraryMediator();
    }

    private static final class HandleFileUpdate
    implements Runnable {
        private Vector list = new Vector();
        private boolean active = false;

        public void addFileUpdate(File f) {
            this.list.addElement(f);
            if (!this.active) {
                this.active = true;
                SwingUtilities.invokeLater(this);
            }
        }

        public void run() {
            try {
                while (this.list.size() > 0) {
                    File f = (File)this.list.firstElement();
                    this.list.removeElementAt(0);
                    LIBRARY_TABLE.update(f);
                }
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (Exception e) {
                GUIMediator.showInternalError(e);
            }
            this.active = false;
        }
    }
}

