/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileDetails;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.FileDetailsProvider;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LicenseWindow;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.actions.ActionUtils;
import com.limegroup.gnutella.gui.actions.BitziLookupAction;
import com.limegroup.gnutella.gui.actions.CopyMagnetLinkToClipboardAction;
import com.limegroup.gnutella.gui.actions.SearchAction;
import com.limegroup.gnutella.gui.library.DirectoryHolder;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.library.LibraryTableCellEditor;
import com.limegroup.gnutella.gui.library.LibraryTableDataLine;
import com.limegroup.gnutella.gui.library.LibraryTableModel;
import com.limegroup.gnutella.gui.playlist.PlaylistMediator;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.tables.DragManager;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.util.CoreExceptionHandler;
import com.limegroup.gnutella.gui.xml.MetaEditorFrame;
import com.limegroup.gnutella.gui.xml.editor.MetaEditor;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.VerificationListener;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.util.Launcher;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.MouseInputListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class LibraryTableMediator
extends AbstractTableMediator
implements VerificationListener,
FileDetailsProvider {
    private static final Log LOG = LogFactory.getLog(LibraryTableMediator.class);
    public static Action LAUNCH_ACTION;
    public static Action ENQUEUE_ACTION;
    public static Action DELETE_ACTION;
    public static Action ANNOTATE_ACTION;
    public static Action RESUME_ACTION;
    public static Action PUBLISH_ACTION;
    public static Action RENAME_ACTION;
    public static Action SHARE_ACTION;
    public static Action UNSHARE_ACTION;
    public static Action SHARE_FOLDER_ACTION;
    public static Action UNSHARE_FOLDER_ACTION;
    private Action BITZI_LOOKUP_ACTION;
    private Action MAGNET_LOOKUP_ACTION;
    private Action LICENSE_ACTION;
    private Action COPY_MAGNET_TO_CLIPBOARD_ACTION;
    private boolean _isIncomplete;
    private boolean _annotateEnabled = false;
    private static LibraryTableMediator _instance;

    public static LibraryTableMediator instance() {
        return _instance;
    }

    protected void buildListeners() {
        super.buildListeners();
        LAUNCH_ACTION = new LaunchAction();
        ENQUEUE_ACTION = new EnqueueAction();
        DELETE_ACTION = new RemoveAction();
        ANNOTATE_ACTION = new AnnotateAction();
        RESUME_ACTION = new ResumeAction();
        PUBLISH_ACTION = new PublishAction();
        RENAME_ACTION = new RenameAction();
        SHARE_ACTION = new ShareFileAction();
        UNSHARE_ACTION = new UnshareFileAction();
        this.BITZI_LOOKUP_ACTION = new BitziLookupAction(this);
        this.MAGNET_LOOKUP_ACTION = new MagnetLookupAction();
        this.LICENSE_ACTION = new LicenseAction();
        this.COPY_MAGNET_TO_CLIPBOARD_ACTION = new CopyMagnetLinkToClipboardAction(this);
        SHARE_FOLDER_ACTION = new ShareFolderAction();
        UNSHARE_FOLDER_ACTION = new UnshareFolderAction();
    }

    protected void setupConstants() {
        this.MAIN_PANEL = null;
        this.DATA_MODEL = new LibraryTableModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        ((LibraryTableModel)this.DATA_MODEL).setTable(this.TABLE);
        Action[] aa = new Action[]{LAUNCH_ACTION, ENQUEUE_ACTION, DELETE_ACTION, ANNOTATE_ACTION, PUBLISH_ACTION, RESUME_ACTION};
        this.BUTTON_ROW = new ButtonRow(aa, 0, 14);
    }

    protected JPopupMenu createPopupMenu() {
        if (this.TABLE.getSelectionModel().isSelectionEmpty()) {
            return null;
        }
        JPopupMenu menu = new JPopupMenu();
        menu.add(new JMenuItem(LAUNCH_ACTION));
        menu.add(new JMenuItem(ENQUEUE_ACTION));
        menu.addSeparator();
        menu.add(new JMenuItem(RESUME_ACTION));
        menu.addSeparator();
        menu.add(new JMenuItem(DELETE_ACTION));
        menu.add(new JMenuItem(RENAME_ACTION));
        menu.addSeparator();
        DataLine[] dls = this.TABLE.getSelectedDataLines();
        boolean dirSelected = false;
        boolean fileSelected = false;
        for (int i = 0; i < dls.length; ++i) {
            if (((LibraryTableDataLine)dls[i]).getFile().isDirectory()) {
                dirSelected = true;
            } else {
                fileSelected = true;
            }
            if (dirSelected && fileSelected) break;
        }
        if (dirSelected) {
            if (GUIMediator.isPlaylistVisible()) {
                ENQUEUE_ACTION.setEnabled(false);
            }
            DELETE_ACTION.setEnabled(false);
            RENAME_ACTION.setEnabled(false);
            if (fileSelected) {
                JMenu sharingMenu = new JMenu(GUIMediator.getStringResource("LIBRARY_TABLE_SHARING_SUB_MENU"));
                sharingMenu.add(new JMenuItem(SHARE_ACTION));
                sharingMenu.add(new JMenuItem(UNSHARE_ACTION));
                sharingMenu.add(new JMenuItem(ANNOTATE_ACTION));
                sharingMenu.add(new JMenuItem(PUBLISH_ACTION));
                sharingMenu.addSeparator();
                sharingMenu.add(new JMenuItem(SHARE_FOLDER_ACTION));
                sharingMenu.add(new JMenuItem(UNSHARE_FOLDER_ACTION));
                menu.add(sharingMenu);
            } else {
                menu.add(new JMenuItem(SHARE_FOLDER_ACTION));
                menu.add(new JMenuItem(UNSHARE_FOLDER_ACTION));
            }
        } else {
            if (GUIMediator.isPlaylistVisible()) {
                ENQUEUE_ACTION.setEnabled(true);
            }
            DELETE_ACTION.setEnabled(true);
            RENAME_ACTION.setEnabled(!this._isIncomplete);
            menu.add(new JMenuItem(SHARE_ACTION));
            menu.add(new JMenuItem(UNSHARE_ACTION));
            menu.add(new JMenuItem(ANNOTATE_ACTION));
            menu.add(new JMenuItem(PUBLISH_ACTION));
        }
        menu.addSeparator();
        menu.add(this.createSearchSubMenu((LibraryTableDataLine)dls[0]));
        menu.add(this.createAdvancedMenu((LibraryTableDataLine)dls[0]));
        this.LICENSE_ACTION.setEnabled(dls != null && dls[0] != null && ((LibraryTableDataLine)dls[0]).isLicensed());
        return menu;
    }

    private JMenu createAdvancedMenu(LibraryTableDataLine dl) {
        JMenu menu = new JMenu(GUIMediator.getStringResource("GENERAL_ADVANCED_SUB_MENU"));
        if (dl != null) {
            menu.add(new JMenuItem(this.LICENSE_ACTION));
            menu.add(new JMenuItem(this.BITZI_LOOKUP_ACTION));
            menu.add(new JMenuItem(this.MAGNET_LOOKUP_ACTION));
            menu.add(new JMenuItem(this.COPY_MAGNET_TO_CLIPBOARD_ACTION));
            File file = this.getFile(this.TABLE.getSelectedRow());
            menu.setEnabled(RouterService.getFileManager().isFileShared(file));
        }
        if (menu.getItemCount() == 0) {
            menu.setEnabled(false);
        }
        return menu;
    }

    private JMenu createSearchSubMenu(LibraryTableDataLine dl) {
        JMenu menu = new JMenu(GUIMediator.getStringResource("LIBRARY_TABLE_SEARCH_POPUP_MENU"));
        if (dl != null) {
            LimeXMLDocument doc;
            File f = (File)dl.getInitializeObject();
            String keywords = StringUtils.createQueryString(f.getName());
            if (keywords.length() > 2) {
                menu.add(new JMenuItem(new SearchAction(keywords)));
            }
            if ((doc = dl.getXMLDocument()) != null) {
                Action[] actions = ActionUtils.createSearchActions(doc);
                for (int i = 0; i < actions.length; ++i) {
                    menu.add(new JMenuItem(actions[i]));
                }
            }
        }
        if (menu.getItemCount() == 0) {
            menu.setEnabled(false);
        }
        return menu;
    }

    public JComponent getScrolledTablePane() {
        return super.getScrolledTablePane();
    }

    protected void updateSplashScreen() {
    }

    private LibraryTableMediator() {
        super("LIBRARY_TABLE");
        ThemeMediator.addThemeObserver(this);
    }

    protected void setupDragAndDrop() {
        DragManager.install(this.TABLE);
    }

    public JComponent getComponent() {
        return null;
    }

    protected void setDefaultEditors() {
        TableColumnModel model = this.TABLE.getColumnModel();
        TableColumn tc = model.getColumn(1);
        tc.setCellEditor(new LibraryTableCellEditor(this));
    }

    void cancelEditing() {
        if (this.TABLE.isEditing()) {
            TableCellEditor editor = this.TABLE.getCellEditor();
            editor.cancelCellEditing();
        }
    }

    void addMouseInputListener(MouseInputListener listener) {
        this.TABLE.addMouseListener(listener);
        this.TABLE.addMouseMotionListener(listener);
    }

    public void setAnnotateEnabled(boolean enabled) {
        this._annotateEnabled = enabled;
        LibraryTableDataLine.setXMLEnabled(enabled);
        this.DATA_MODEL.refresh();
        if (!enabled) {
            ANNOTATE_ACTION.setEnabled(false);
            PUBLISH_ACTION.setEnabled(false);
        } else if (!this._isIncomplete && this.TABLE.getSelectedRowCount() >= 1 && ((LibraryTableModel)this.DATA_MODEL).getFileDesc(this.TABLE.getSelectedRow()) != null) {
            ANNOTATE_ACTION.setEnabled(true);
            File currFile = ((LibraryTableModel)this.DATA_MODEL).getFile(this.TABLE.getSelectedRow());
            if (LimeXMLUtils.isFilePublishable(currFile.getName())) {
                PUBLISH_ACTION.setEnabled(true);
            }
        }
    }

    void setIncompleteSelected(boolean enabled) {
        if (enabled == this._isIncomplete) {
            return;
        }
        this._isIncomplete = enabled;
        if (!enabled) {
            RESUME_ACTION.setEnabled(false);
        } else if (!this.TABLE.getSelectionModel().isSelectionEmpty()) {
            RESUME_ACTION.setEnabled(true);
        }
    }

    void updateTableFiles(DirectoryHolder dirHolder) {
        if (dirHolder == null) {
            return;
        }
        this.clearTable();
        this.setIncompleteSelected(LibraryMediator.incompleteDirectoryIsSelected());
        File[] files = dirHolder.getFiles();
        for (int i = 0; i < files.length; ++i) {
            this.addUnsorted(files[i]);
        }
        this.forceResort();
    }

    void handleFileManagerEvent(FileManagerEvent evt, DirectoryHolder holder) {
        if (evt == null || holder == null) {
            return;
        }
        File[] files = evt.getFiles();
        FileDesc[] fds = evt.getFileDescs();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handling event: " + evt);
        }
        switch (evt.getKind()) {
            case 2: {
                File f = fds[0].getFile();
                if (holder.accept(f)) {
                    ((LibraryTableModel)this.DATA_MODEL).reinitialize(f);
                    this.handleSelection(-1);
                    break;
                }
                if (!this.DATA_MODEL.contains(f)) break;
                this.DATA_MODEL.remove(f);
                this.handleSelection(-1);
                break;
            }
            case 1: {
                if (!holder.accept(fds[0].getFile())) break;
                this.add(fds[0].getFile());
                this.handleSelection(-1);
                break;
            }
            case 4: {
                File changed = fds[0].getFile();
                ((LibraryTableModel)this.DATA_MODEL).reinitialize(changed);
                this.handleSelection(-1);
                break;
            }
            case 3: {
                File old = fds[0].getFile();
                File now = fds[1].getFile();
                if (!holder.accept(now)) break;
                ((LibraryTableModel)this.DATA_MODEL).reinitialize(old, now);
                this.handleSelection(-1);
                break;
            }
            case 7: {
                if (!holder.accept(files[0])) break;
                this.add(files[0]);
                this.handleSelection(-1);
                break;
            }
            case 8: {
                File f = files[0];
                if (holder.accept(f)) {
                    ((LibraryTableModel)this.DATA_MODEL).reinitialize(f);
                    this.handleSelection(-1);
                    break;
                }
                if (!this.DATA_MODEL.contains(f)) break;
                this.DATA_MODEL.remove(f);
                this.handleSelection(-1);
            }
        }
    }

    File getFile(int row) {
        return ((LibraryTableModel)this.DATA_MODEL).getFile(row);
    }

    private FileDesc getFileDesc(int row) {
        return ((LibraryTableModel)this.DATA_MODEL).getFileDesc(row);
    }

    public FileDetails[] getFileDetails() {
        int[] sel = this.TABLE.getSelectedRows();
        ArrayList<FileDesc> files = new ArrayList<FileDesc>(sel.length);
        for (int i = 0; i < sel.length; ++i) {
            FileDesc desc = this.getFileDesc(sel[i]);
            if (desc == null) continue;
            files.add(desc);
        }
        if (files.isEmpty()) {
            return new FileDetails[0];
        }
        return files.toArray(new FileDetails[0]);
    }

    JTable getTable() {
        return this.TABLE;
    }

    ButtonRow getButtonRow() {
        return this.BUTTON_ROW;
    }

    ListSelectionModel getSelectionModel() {
        return this.TABLE.getSelectionModel();
    }

    private boolean isSupportedFormat(FileDesc[] fds) {
        boolean audio = false;
        boolean video = false;
        boolean program = false;
        boolean document = false;
        boolean image = false;
        for (int i = 0; i < fds.length; ++i) {
            String name = fds[i].getFileName();
            if (!(!MediaType.getAudioMediaType().matches(name) || video || program || document || image)) {
                audio = true;
                continue;
            }
            if (!(!MediaType.getVideoMediaType().matches(name) || audio || program || document || image)) {
                video = true;
                continue;
            }
            if (!(!MediaType.getProgramMediaType().matches(name) || audio || video || document || image)) {
                program = true;
                continue;
            }
            if (!(!MediaType.getDocumentMediaType().matches(name) || audio || video || program || image)) {
                document = true;
                continue;
            }
            if (!(!MediaType.getImageMediaType().matches(name) || audio || video || program || document)) {
                image = true;
                continue;
            }
            return false;
        }
        return true;
    }

    void editMeta(boolean publish) {
        int[] rows = this.TABLE.getSelectedRows();
        ArrayList<FileDesc> fileDescs = new ArrayList<FileDesc>(rows.length);
        for (int i = 0; i < rows.length; ++i) {
            FileDesc fd = ((LibraryTableModel)this.DATA_MODEL).getFileDesc(rows[i]);
            if (fd == null) continue;
            fileDescs.add(fd);
        }
        if (fileDescs.isEmpty()) {
            return;
        }
        FileDesc[] fds = fileDescs.toArray(new FileDesc[0]);
        String name = fds[0].getFile().getName();
        JFrame mainFrame = GUIMediator.getAppFrame();
        if (this.isSupportedFormat(fds)) {
            MetaEditor metaEditor = new MetaEditor((Frame)mainFrame, fds, name, publish);
            metaEditor.setLocationRelativeTo(MessageService.getParentComponent());
            metaEditor.setVisible(true);
        } else {
            fds = new FileDesc[]{fds[fds.length - 1]};
            MetaEditorFrame metaEditor = new MetaEditorFrame(fds[fds.length - 1], name, mainFrame);
            metaEditor.setLocationRelativeTo(MessageService.getParentComponent());
            metaEditor.setVisible(true);
        }
    }

    void startRename() {
        int row = this.TABLE.getSelectedRow();
        if (row == -1) {
            return;
        }
        int viewIdx = this.TABLE.convertColumnIndexToView(1);
        this.TABLE.editCellAt(row, viewIdx, LibraryTableCellEditor.EVENT);
    }

    void showLicenseWindow() {
        DataLine dl = this.TABLE.getSelectedDataLine();
        if (dl == null) {
            return;
        }
        LibraryTableDataLine ldl = (LibraryTableDataLine)dl;
        FileDesc fd = ldl.getFileDesc();
        License license = fd.getLicense();
        URN urn = fd.getSHA1Urn();
        LimeXMLDocument doc = ldl.getXMLDocument();
        LicenseWindow window = LicenseWindow.create(license, urn, doc, this);
        window.setVisible(true);
    }

    public void licenseVerified(License license) {
        this.DATA_MODEL.refresh();
    }

    void doMagnetLookup() {
        this.doMagnetCommand("/magcmd/detail?");
    }

    void doMagnetCommand(String cmd) {
        int[] rows = this.TABLE.getSelectedRows();
        int k = rows.length;
        if (k == 0) {
            return;
        }
        boolean haveValidMagnet = false;
        int count = 0;
        int port = RouterService.getHTTPAcceptor().getPort();
        int eport = RouterService.getAcceptor().getPort(true);
        byte[] eaddr = RouterService.getAcceptor().getAddress(true);
        String lookupUrl = "http://localhost:" + port + cmd + "addr=" + NetworkUtils.ip2string(eaddr) + ":" + eport;
        for (int i = 0; i < k; ++i) {
            URN urn;
            FileDesc fd = ((LibraryTableModel)this.DATA_MODEL).getFileDesc(rows[i]);
            if (fd == null || (urn = fd.getSHA1Urn()) == null) continue;
            String urnStr = urn.toString();
            int hashstart = 1 + urnStr.indexOf(":", 4);
            String sha1 = urnStr.substring(hashstart);
            lookupUrl = lookupUrl + "&n" + count + "=" + URLEncoder.encode(fd.getFileName()) + "&u" + count + "=" + sha1;
            ++count;
            haveValidMagnet = true;
        }
        if (haveValidMagnet) {
            try {
                Launcher.openURL(lookupUrl);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    public void removeSelection() {
        int i;
        String msgKey = "MESSAGE_CONFIRM_FILE_DELETE";
        int response = GUIMediator.showYesNoMessage(msgKey);
        if (response != 101) {
            return;
        }
        int[] rows = this.TABLE.getSelectedRows();
        if (rows.length <= 0) {
            return;
        }
        Arrays.sort(rows);
        if (this.TABLE.isEditing()) {
            TableCellEditor editor = this.TABLE.getCellEditor();
            editor.cancelCellEditing();
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (i = rows.length - 1; i >= 0; --i) {
            File file = ((LibraryTableModel)this.DATA_MODEL).getFile(rows[i]);
            FileDesc fd = ((LibraryTableModel)this.DATA_MODEL).getFileDesc(rows[i]);
            if (fd instanceof IncompleteFileDesc) {
                RouterService.getDownloadManager().getIncompleteFileManager().removeEntry(file);
            } else {
                RouterService.getFileManager().removeFileIfShared(file);
            }
            boolean removed = file.delete();
            if (!removed && fd != null) {
                RouterService.getUploadManager().killUploadsForFileDesc(fd);
                removed = file.delete();
            }
            if (removed) {
                this.DATA_MODEL.remove(rows[i]);
                continue;
            }
            errors.add(file.getName());
        }
        this.clearSelection();
        for (i = 0; i < errors.size(); ++i) {
            String name = (String)errors.get(i);
            String key1 = "MESSAGE_UNABLE_TO_DELETE_FILE_START";
            String key2 = "MESSAGE_UNABLE_TO_DELETE_FILE_END";
            String msg = "'" + name + "'.";
            GUIMediator.showError("MESSAGE_UNABLE_TO_DELETE_FILE_START", (Object)msg, "MESSAGE_UNABLE_TO_DELETE_FILE_END");
        }
    }

    String handleNameChange(String newName) {
        int row = this.TABLE.getEditingRow();
        LibraryTableModel ltm = (LibraryTableModel)this.DATA_MODEL;
        File oldFile = ltm.getFile(row);
        String parent = oldFile.getParent();
        String nameWithExtension = newName + "." + ltm.getType(row);
        File newFile = new File(parent, nameWithExtension);
        if (!ltm.getName(row).equals(newName)) {
            if (!newFile.exists() && oldFile.renameTo(newFile)) {
                RouterService.getFileManager().renameFileIfShared(oldFile, newFile);
                ((LibraryTableModel)this.DATA_MODEL).reinitialize(oldFile);
                return newName;
            }
            GUIMediator.showError("MESSAGE_UNABLE_TO_RENAME_FILE_START", (Object)("'" + ltm.getName(row) + "'."), "MESSAGE_UNABLE_TO_RENAME_FILE_END");
            return ltm.getName(row);
        }
        return newName;
    }

    public void handleActionKey() {
        int[] rows = this.TABLE.getSelectedRows();
        LibraryTableModel ltm = (LibraryTableModel)this.DATA_MODEL;
        for (int i = 0; i < rows.length; ++i) {
            File file = ltm.getFile(rows[i]);
            if (!file.isDirectory() || !LibraryMediator.setSelectedDirectory(file)) continue;
            return;
        }
        this.launch();
    }

    void resumeIncomplete() {
        int i;
        int[] rows = this.TABLE.getSelectedRows();
        boolean startedDownload = false;
        ArrayList<Exception> errors = new ArrayList<Exception>();
        for (i = 0; i < rows.length; ++i) {
            File incomplete = ((LibraryTableModel)this.DATA_MODEL).getFile(rows[i]);
            try {
                RouterService.download(incomplete);
                startedDownload = true;
                continue;
            }
            catch (SaveLocationException e) {
                errors.add(e);
                continue;
            }
            catch (CantResumeException e) {
                errors.add(e);
            }
        }
        for (i = 0; i < errors.size(); ++i) {
            Exception e = (Exception)errors.get(i);
            if (e instanceof SaveLocationException) {
                SaveLocationException sle = (SaveLocationException)e;
                if (sle.getErrorCode() == 10) {
                    GUIMediator.showFormattedError("FORMATTED_ERROR_ALREADY_DOWNLOADING", new Object[]{sle.getFile()}, QuestionsHandler.ALREADY_DOWNLOADING);
                    continue;
                }
                String msg = CoreExceptionHandler.getSaveLocationErrorString(sle);
                GUIMediator.showTranslatedError(msg);
                continue;
            }
            if (!(e instanceof CantResumeException)) continue;
            GUIMediator.showError("ERROR_CANT_RESUME_START", "\"" + ((CantResumeException)e).getFilename() + "\"", "ERROR_CANT_RESUME_END", QuestionsHandler.CANT_RESUME);
        }
        if (startedDownload) {
            GUIMediator.instance().setWindow(0);
        }
    }

    void launch() {
        int[] rows = this.TABLE.getSelectedRows();
        boolean audioLaunched = false;
        int l = rows.length;
        for (int i = 0; i < l; ++i) {
            File currFile = ((LibraryTableModel)this.DATA_MODEL).getFile(rows[i]);
            if (!audioLaunched && GUIMediator.isPlaylistVisible() && PlaylistMediator.isPlayableFile(currFile)) {
                GUIMediator.instance().launchAudio(currFile);
                audioLaunched = true;
                continue;
            }
            try {
                GUIMediator.launchFile(currFile);
                continue;
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
    }

    public void handleSelection(int row) {
        if (this.TABLE.getSelectedRowCount() <= 0) {
            this.handleNoSelection();
            return;
        }
        LAUNCH_ACTION.setEnabled(true);
        DELETE_ACTION.setEnabled(true);
        int[] sel = this.TABLE.getSelectedRows();
        if (GUIMediator.isPlaylistVisible()) {
            boolean found = false;
            for (int i = 0; i < sel.length; ++i) {
                if (!PlaylistMediator.isPlayableFile(((LibraryTableModel)this.DATA_MODEL).getFile(sel[i]))) continue;
                found = true;
                break;
            }
            ENQUEUE_ACTION.setEnabled(found);
        } else {
            ENQUEUE_ACTION.setEnabled(false);
        }
        if (!this._isIncomplete && this._annotateEnabled && this.TABLE.getSelectedRowCount() >= 1 && ((LibraryTableModel)this.DATA_MODEL).getFileDesc(this.TABLE.getSelectedRow()) != null) {
            File currFile = ((LibraryTableModel)this.DATA_MODEL).getFile(this.TABLE.getSelectedRow());
            ANNOTATE_ACTION.setEnabled(true);
            PUBLISH_ACTION.setEnabled(LimeXMLUtils.isFilePublishable(currFile.getName()));
        } else {
            ANNOTATE_ACTION.setEnabled(false);
            PUBLISH_ACTION.setEnabled(false);
        }
        RESUME_ACTION.setEnabled(this._isIncomplete);
        RENAME_ACTION.setEnabled(!this._isIncomplete);
        boolean shareAllowed = false;
        boolean unshareAllowed = false;
        boolean shareFolderAllowed = false;
        boolean unshareFolderAllowed = false;
        boolean foundDir = false;
        for (int i = 0; i < sel.length; ++i) {
            File file = this.getFile(sel[i]);
            if (file.isDirectory()) {
                if (!foundDir) {
                    DELETE_ACTION.setEnabled(false);
                    foundDir = true;
                }
                if (!RouterService.getFileManager().isCompletelySharedDirectory(file)) {
                    shareFolderAllowed = true;
                    continue;
                }
                unshareFolderAllowed = true;
                continue;
            }
            if (!RouterService.getFileManager().isFileShared(file)) {
                if (!FileManager.isFilePhysicallyShareable(file) || this._isIncomplete) continue;
                shareAllowed = true;
            } else {
                unshareAllowed = true;
            }
            if (shareAllowed && unshareAllowed && shareFolderAllowed && unshareFolderAllowed) break;
        }
        SHARE_ACTION.setEnabled(shareAllowed);
        UNSHARE_ACTION.setEnabled(unshareAllowed);
        SHARE_FOLDER_ACTION.setEnabled(shareFolderAllowed);
        UNSHARE_FOLDER_ACTION.setEnabled(unshareFolderAllowed);
        File file = this.getFile(sel[0]);
        boolean firstShared = RouterService.getFileManager().isFileShared(file);
        this.MAGNET_LOOKUP_ACTION.setEnabled(firstShared);
        this.BITZI_LOOKUP_ACTION.setEnabled(firstShared);
        this.COPY_MAGNET_TO_CLIPBOARD_ACTION.setEnabled(!this._isIncomplete && this.getFileDesc(sel[0]) != null);
        LibraryTableDataLine dl = (LibraryTableDataLine)this.TABLE.getSelectedDataLine();
        boolean license = dl != null && dl.isLicensed();
        this.LICENSE_ACTION.setEnabled(license);
    }

    public void handleNoSelection() {
        LAUNCH_ACTION.setEnabled(false);
        ENQUEUE_ACTION.setEnabled(false);
        DELETE_ACTION.setEnabled(false);
        ANNOTATE_ACTION.setEnabled(false);
        PUBLISH_ACTION.setEnabled(false);
        RESUME_ACTION.setEnabled(false);
        RENAME_ACTION.setEnabled(false);
        SHARE_ACTION.setEnabled(false);
        UNSHARE_ACTION.setEnabled(false);
        SHARE_FOLDER_ACTION.setEnabled(false);
        UNSHARE_FOLDER_ACTION.setEnabled(false);
        this.COPY_MAGNET_TO_CLIPBOARD_ACTION.setEnabled(false);
        this.MAGNET_LOOKUP_ACTION.setEnabled(false);
        this.BITZI_LOOKUP_ACTION.setEnabled(false);
        this.LICENSE_ACTION.setEnabled(false);
    }

    public void setPlayerEnabled(boolean value) {
        this.handleSelection(this.TABLE.getSelectedRow());
    }

    static {
        _instance = new LibraryTableMediator();
    }

    private class LicenseAction
    extends AbstractAction {
        public LicenseAction() {
            this.putValue("Name", GUIMediator.getStringResource("LICENSE_VIEW_LICENSE"));
        }

        public void actionPerformed(ActionEvent e) {
            LibraryTableMediator.this.showLicenseWindow();
        }
    }

    private final class MagnetLookupAction
    extends AbstractAction {
        public MagnetLookupAction() {
            this.putValue("Name", GUIMediator.getStringResource("SEARCH_PUBLIC_MAGNET_LOOKUP_STRING"));
        }

        public void actionPerformed(ActionEvent e) {
            LibraryTableMediator.this.doMagnetLookup();
        }
    }

    private class UnshareFolderAction
    extends AbstractAction {
        public UnshareFolderAction() {
            this.putValue("Name", GUIMediator.getStringResource("UNSHARE_FOLDER_POPUP_MENU_LABEL"));
        }

        public void actionPerformed(ActionEvent e) {
            int[] sel = LibraryTableMediator.this.TABLE.getSelectedRows();
            File[] files = new File[sel.length];
            for (int i = sel.length - 1; i >= 0; --i) {
                files[i] = LibraryTableMediator.this.getFile(sel[i]);
            }
            GUIMediator.instance().schedule(new Runnable(this, files){
                private final /* synthetic */ File[] val$files;
                private final /* synthetic */ UnshareFolderAction this$1;
                {
                    this.this$1 = this$1;
                    this.val$files = val$files;
                }

                public void run() {
                    for (int i = 0; i < this.val$files.length; ++i) {
                        File file = this.val$files[i];
                        if (file == null || !file.isDirectory()) continue;
                        RouterService.getFileManager().removeFolderIfShared(file);
                    }
                }
            });
        }
    }

    private class ShareFolderAction
    extends AbstractAction {
        public ShareFolderAction() {
            this.putValue("Name", GUIMediator.getStringResource("SHARE_FOLDER_POPUP_MENU_LABEL"));
        }

        public void actionPerformed(ActionEvent e) {
            int[] sel = LibraryTableMediator.this.TABLE.getSelectedRows();
            File[] files = new File[sel.length];
            for (int i = 0; i < sel.length; ++i) {
                files[i] = LibraryTableMediator.this.getFile(sel[i]);
            }
            GUIMediator.instance().schedule(new Runnable(this, files){
                private final /* synthetic */ File[] val$files;
                private final /* synthetic */ ShareFolderAction this$1;
                {
                    this.this$1 = this$1;
                    this.val$files = val$files;
                }

                public void run() {
                    for (int i = 0; i < this.val$files.length; ++i) {
                        File file = this.val$files[i];
                        if (file == null || !file.isDirectory()) continue;
                        RouterService.getFileManager().addSharedFolder(file);
                    }
                }
            });
        }
    }

    private class UnshareFileAction
    extends AbstractAction {
        public UnshareFileAction() {
            this.putValue("Name", GUIMediator.getStringResource("UNSHARE_FILE_POPUP_MENU_LABEL"));
        }

        public void actionPerformed(ActionEvent e) {
            int[] sel = LibraryTableMediator.this.TABLE.getSelectedRows();
            File[] files = new File[sel.length];
            for (int i = sel.length - 1; i >= 0; --i) {
                files[i] = LibraryTableMediator.this.getFile(sel[i]);
            }
            GUIMediator.instance().schedule(new Runnable(this, files){
                private final /* synthetic */ File[] val$files;
                private final /* synthetic */ UnshareFileAction this$1;
                {
                    this.this$1 = this$1;
                    this.val$files = val$files;
                }

                public void run() {
                    for (int i = 0; i < this.val$files.length; ++i) {
                        File file = this.val$files[i];
                        if (file == null || file.isDirectory()) continue;
                        RouterService.getFileManager().stopSharingFile(file);
                    }
                }
            });
        }
    }

    private class ShareFileAction
    extends AbstractAction {
        public ShareFileAction() {
            this.putValue("Name", GUIMediator.getStringResource("SHARE_FILE_POPUP_MENU_LABEL"));
        }

        public void actionPerformed(ActionEvent e) {
            int[] sel = LibraryTableMediator.this.TABLE.getSelectedRows();
            File[] files = new File[sel.length];
            for (int i = 0; i < sel.length; ++i) {
                files[i] = LibraryTableMediator.this.getFile(sel[i]);
            }
            GUIMediator.instance().schedule(new Runnable(this, files){
                private final /* synthetic */ File[] val$files;
                private final /* synthetic */ ShareFileAction this$1;
                {
                    this.this$1 = this$1;
                    this.val$files = val$files;
                }

                public void run() {
                    for (int i = 0; i < this.val$files.length; ++i) {
                        File file = this.val$files[i];
                        if (file == null || file.isDirectory()) continue;
                        RouterService.getFileManager().addFileAlways(file);
                    }
                }
            });
        }
    }

    private final class RenameAction
    extends AbstractAction {
        public RenameAction() {
            this.putValue("Name", GUIMediator.getStringResource("LIBRARY_RENAME_BUTTON_LABEL"));
        }

        public void actionPerformed(ActionEvent ae) {
            LibraryTableMediator.this.startRename();
        }
    }

    private final class ResumeAction
    extends AbstractAction {
        public ResumeAction() {
            this.putValue("Name", GUIMediator.getStringResource("LIBRARY_RESUME_BUTTON_LABEL"));
            this.putValue("ShortDescription", GUIMediator.getStringResource("LIBRARY_RESUME_BUTTON_TIP"));
            this.putValue("LimeIconName", "LIBRARY_RESUME");
        }

        public void actionPerformed(ActionEvent ae) {
            LibraryTableMediator.this.resumeIncomplete();
        }
    }

    private final class PublishAction
    extends AbstractAction {
        public PublishAction() {
            this.putValue("Name", GUIMediator.getStringResource("LIBRARY_PUBLISH_BUTTON_LABEL"));
            this.putValue("ShortDescription", GUIMediator.getStringResource("LIBRARY_PUBLISH_BUTTON_TIP"));
            this.putValue("LimeIconName", "LIBRARY_PUBLISH");
        }

        public void actionPerformed(ActionEvent e) {
            LibraryTableMediator.this.editMeta(true);
        }
    }

    private final class AnnotateAction
    extends AbstractAction {
        public AnnotateAction() {
            this.putValue("Name", GUIMediator.getStringResource("LIBRARY_ANNOTATE_BUTTON_LABEL"));
            this.putValue("ShortDescription", GUIMediator.getStringResource("LIBRARY_ANNOTATE_BUTTON_TIP"));
            this.putValue("LimeIconName", "LIBRARY_ANNOTATE");
        }

        public void actionPerformed(ActionEvent ae) {
            LibraryTableMediator.this.editMeta(false);
        }
    }

    private final class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            this.putValue("Name", GUIMediator.getStringResource("LIBRARY_DELETE_BUTTON_LABEL"));
            this.putValue("ShortDescription", GUIMediator.getStringResource("LIBRARY_DELETE_BUTTON_TIP"));
            this.putValue("LimeIconName", "LIBRARY_DELETE");
        }

        public void actionPerformed(ActionEvent ae) {
            LibraryTableMediator.this.REMOVE_LISTENER.actionPerformed(ae);
        }
    }

    private final class EnqueueAction
    extends AbstractAction {
        public EnqueueAction() {
            this.putValue("Name", GUIMediator.getStringResource("LIBRARY_PLAYLIST_BUTTON_LABEL"));
            this.putValue("ShortDescription", GUIMediator.getStringResource("LIBRARY_PLAYLIST_BUTTON_TIP"));
            this.putValue("LimeIconName", "LIBRARY_TO_PLAYLIST");
        }

        public void actionPerformed(ActionEvent ae) {
            int[] rows = LibraryTableMediator.this.TABLE.getSelectedRows();
            for (int i = 0; i < rows.length; ++i) {
                int index = rows[i];
                File file = ((LibraryTableModel)LibraryTableMediator.this.DATA_MODEL).getFile(index);
                if (!GUIMediator.isPlaylistVisible() || !PlaylistMediator.isPlayableFile(file)) continue;
                LibraryMediator.instance().addFileToPlayList(file);
            }
        }
    }

    private final class LaunchAction
    extends AbstractAction {
        public LaunchAction() {
            this.putValue("Name", GUIMediator.getStringResource("LIBRARY_LAUNCH_BUTTON_LABEL"));
            this.putValue("ShortDescription", GUIMediator.getStringResource("LIBRARY_LAUNCH_BUTTON_TIP"));
            this.putValue("LimeIconName", "LIBRARY_LAUNCH");
        }

        public void actionPerformed(ActionEvent ae) {
            LibraryTableMediator.this.launch();
        }
    }
}

