/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.library.LibraryTableDataLine;
import com.limegroup.gnutella.gui.tables.ColoredCellImpl;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.tables.HashBasedDataLineModel;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import java.io.File;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;

final class LibraryTableModel
extends HashBasedDataLineModel {
    private JTable _table;

    LibraryTableModel() {
        super(LibraryTableDataLine.class);
    }

    public DataLine createDataLine() {
        return new LibraryTableDataLine(this);
    }

    void setTable(JTable table) {
        this._table = table;
    }

    public Object refresh() {
        this.fireTableRowsUpdated(0, this.getRowCount());
        return null;
    }

    public int add(Object o) {
        return this.add(o, this.getRowCount());
    }

    public int add(DataLine dl, int row) {
        Object init = dl.getInitializeObject();
        if (!this.contains(init)) {
            return this.forceAdd(dl, row);
        }
        FileDesc fd = ((LibraryTableDataLine)dl).getFileDesc();
        if (fd != null) {
            row = this.getRow(init);
            this.get(row).initialize(fd);
            this.fireTableRowsUpdated(row, row);
        }
        dl.cleanup();
        return -1;
    }

    void reinitialize(File f) {
        if (this.contains(f)) {
            int row = this.getRow(f);
            this.get(row).initialize(f);
            this.fireTableRowsUpdated(row, row);
        }
    }

    void reinitialize(File old, File now) {
        if (this.contains(old)) {
            int row = this.getRow(old);
            this.get(row).initialize(now);
            this.initializeObjectChanged(old, now);
            this.fireTableRowsUpdated(row, row);
        }
    }

    String getType(int row) {
        return (String)((ColoredCellImpl)this.get(row).getValueAt(3)).getValue();
    }

    File getFile(int row) {
        return (File)this.get(row).getInitializeObject();
    }

    String getName(int row) {
        return (String)((ColoredCellImpl)this.get(row).getValueAt(1)).getValue();
    }

    int getSize(int row) {
        return ((SizeHolder)((ColoredCellImpl)this.get(row).getValueAt(2)).getValue()).getSize();
    }

    FileDesc getFileDesc(int row) {
        return ((LibraryTableDataLine)this.get(row)).getFileDesc();
    }

    public boolean isCellEditable(int row, int col) {
        int max;
        if (LibraryMediator.incompleteDirectoryIsSelected()) {
            return false;
        }
        if (this.getFile(row).isDirectory()) {
            return false;
        }
        ListSelectionModel selModel = this._table.getSelectionModel();
        int min = selModel.getMinSelectionIndex();
        return min == (max = selModel.getMaxSelectionIndex()) && col == 1 && this._table.getSelectedRow() == row;
    }
}

