/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;

final class ThemeMenu
extends AbstractMenu {
    private static final String THEME_PROPERTY = "THEME_NAME";
    private static final String THEME_CLASSNAME = "THEME_CLASSNAME";
    private static final ActionListener THEME_CHANGER = new ThemeChangeListener();
    private static final ButtonGroup GROUP = new ButtonGroup();

    ThemeMenu(String key) {
        super(key);
        this.addMenuItem("VIEW_THEMES_GET_MORE", new GetThemesListener());
        this.addMenuItem("VIEW_THEMES_REFRESH", new RefreshThemesListener());
        JMenuItem def = this.addMenuItem("VIEW_THEMES_USE_DEFAULT", THEME_CHANGER);
        final String defaultVal = ThemeSettings.THEME_DEFAULT.getAbsolutePath();
        def.putClientProperty(THEME_PROPERTY, defaultVal);
        def.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ThemeMenu.setSelection(defaultVal);
            }
        });
        this.addSeparator();
        this.addThemeItems();
    }

    private static void setSelection(Object value) {
        Enumeration<AbstractButton> items = GROUP.getElements();
        while (items.hasMoreElements()) {
            JMenuItem item = (JMenuItem)items.nextElement();
            if (!value.equals(item.getClientProperty(THEME_PROPERTY))) continue;
            item.setSelected(true);
            break;
        }
    }

    private void addThemeItems() {
        File themeDir = ThemeSettings.THEME_DIR_FILE;
        if (!themeDir.exists()) {
            return;
        }
        LinkedList<String> allThemes = new LinkedList<String>(Arrays.asList(themeDir.list(new ThemeFileFilter())));
        ThemeMenu.addInstalledLFs(allThemes);
        Collections.sort(allThemes, new ThemeComparator());
        if (allThemes.isEmpty()) {
            return;
        }
        String otherClassName = ThemeSettings.getOtherLF();
        Iterator i = allThemes.iterator();
        while (i.hasNext()) {
            JRadioButtonMenuItem theme;
            File themeFile;
            Object next = i.next();
            if (next instanceof String) {
                themeFile = new File(themeDir, (String)next);
                theme = new JRadioButtonMenuItem(ThemeSettings.formatName(themeFile.getName()));
                if (themeFile.equals(ThemeSettings.THEME_FILE.getValue())) {
                    theme.setSelected(true);
                }
            } else {
                themeFile = new File(themeDir, "other_theme.lwtp");
                UIManager.LookAndFeelInfo lfi = (UIManager.LookAndFeelInfo)next;
                theme = new JRadioButtonMenuItem(lfi.getName());
                if (themeFile.equals(ThemeSettings.THEME_FILE.getValue()) && otherClassName != null && lfi.getClassName().equals(otherClassName)) {
                    theme.setSelected(true);
                }
                theme.putClientProperty(THEME_CLASSNAME, lfi.getClassName());
            }
            theme.setFont(AbstractMenu.FONT);
            GROUP.add(theme);
            theme.addActionListener(THEME_CHANGER);
            theme.putClientProperty(THEME_PROPERTY, themeFile.getAbsolutePath());
            this.MENU.add(theme);
        }
    }

    private void removeThemeItems() {
        Enumeration<AbstractButton> items = GROUP.getElements();
        LinkedList<JMenuItem> removed = new LinkedList<JMenuItem>();
        while (items.hasMoreElements()) {
            JMenuItem item = (JMenuItem)items.nextElement();
            this.MENU.remove(item);
            removed.add(item);
        }
        Iterator itr = removed.iterator();
        while (itr.hasNext()) {
            GROUP.remove((JMenuItem)itr.next());
        }
    }

    private static void addInstalledLFs(List themes) {
        UIManager.LookAndFeelInfo[] lfs = UIManager.getInstalledLookAndFeels();
        if (lfs == null) {
            return;
        }
        for (int i = 0; i < lfs.length; ++i) {
            UIManager.LookAndFeelInfo l = lfs[i];
            if (l.getClassName().equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel") || l.getClassName().startsWith("apple") || l.getClassName().equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel") && CommonUtils.isLinux() && CommonUtils.isJava15OrLater() || l.getClassName().equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel")) continue;
            themes.add(l);
        }
    }

    public static class ThemeFileFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            if (!name.endsWith("lwtp")) {
                return false;
            }
            if (name.startsWith("default_")) {
                return false;
            }
            if (name.equals("other_theme.lwtp")) {
                return false;
            }
            if (!CommonUtils.isMacOSX() && name.equals("pinstripes_theme_osx.lwtp")) {
                return false;
            }
            if (name.equals("brushed_metal_theme_osx.lwtp") && CommonUtils.isJaguarOrAbove()) {
                return false;
            }
            if (!CommonUtils.isWindows() && name.equals("windows_theme.lwtp")) {
                return false;
            }
            if (!CommonUtils.isPro() && name.equals("limewirePro_theme.lwtp")) {
                return false;
            }
            return !name.equals("GTK_theme.lwtp") || CommonUtils.isLinux() && CommonUtils.isJava15OrLater();
        }
    }

    private static class ThemeComparator
    implements Comparator {
        private ThemeComparator() {
        }

        public int compare(Object a, Object b) {
            String name1 = a instanceof String ? ThemeSettings.formatName((String)a) : ((UIManager.LookAndFeelInfo)a).getName();
            String name2 = b instanceof String ? ThemeSettings.formatName((String)b) : ((UIManager.LookAndFeelInfo)b).getName();
            return name1.compareTo(name2);
        }
    }

    protected static class ThemeChangeListener
    implements ActionListener {
        protected ThemeChangeListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem item = (JMenuItem)e.getSource();
            String themePath = (String)item.getClientProperty(ThemeMenu.THEME_PROPERTY);
            String className = (String)item.getClientProperty(ThemeMenu.THEME_CLASSNAME);
            ThemeMediator.changeTheme(new File(themePath), className);
        }
    }

    private class RefreshThemesListener
    implements ActionListener {
        private RefreshThemesListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ThemeMenu.this.removeThemeItems();
            ThemeMenu.this.addThemeItems();
        }
    }

    private static class GetThemesListener
    implements ActionListener {
        private GetThemesListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String url = "http://www.limewire.com/skins2";
            GUIMediator.openURL(url);
        }
    }
}

