/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.notify;

import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.notify.LinuxNotifyUser;
import com.limegroup.gnutella.gui.notify.NonWindowsNotifyUser;
import com.limegroup.gnutella.gui.notify.NotifyUser;
import com.limegroup.gnutella.gui.notify.WindowsNotifyUser;
import com.limegroup.gnutella.util.CommonUtils;

public class NotifyUserProxy
implements NotifyUser {
    private NotifyUser _notifier;
    private boolean _inTray = false;
    private static final NotifyUserProxy INSTANCE = new NotifyUserProxy();

    public static NotifyUserProxy instance() {
        return INSTANCE;
    }

    private NotifyUserProxy() {
        if (CommonUtils.supportsTray() && ResourceManager.instance().isTrayLibraryLoaded()) {
            this._notifier = CommonUtils.isWindows() ? new WindowsNotifyUser() : new LinuxNotifyUser();
            this.addNotify();
        } else {
            this._notifier = new NonWindowsNotifyUser();
        }
    }

    public void addNotify() {
        if (this._inTray) {
            return;
        }
        this._notifier.addNotify();
        this._inTray = true;
    }

    public void removeNotify() {
        if (!this._inTray) {
            return;
        }
        this._notifier.removeNotify();
        this._inTray = false;
    }

    public void updateNotify(String imageFileName, String desc) {
        this._notifier.updateNotify(imageFileName, desc);
    }

    public void updateDesc(String desc) {
        this._notifier.updateDesc(desc);
    }

    public void updateImage(String imageFileName) {
        this._notifier.updateImage(imageFileName);
    }

    public void hideNotify() {
        if (!this._inTray) {
            return;
        }
        this._notifier.hideNotify();
    }
}

