/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.options.OptionsButtonPanel;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.options.OptionsPaneManager;
import com.limegroup.gnutella.gui.options.OptionsTreeManager;
import com.limegroup.gnutella.settings.SettingsHandler;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;

public final class OptionsConstructor {
    private final JDialog DIALOG;
    private final int OPTIONS_WIDTH = 600;
    private final int OPTIONS_HEIGHT = 460;
    private final OptionsTreeManager TREE_MANAGER;
    private final OptionsPaneManager PANE_MANAGER;
    static final String SAVE_KEY = "OPTIONS_SAVE_MAIN_TITLE";
    static final String SAVE_BASIC_KEY = "OPTIONS_SAVE_BASIC_MAIN_TITLE";
    static final String SAVE_ADVANCED_KEY = "OPTIONS_SAVE_ADVANCED_MAIN_TITLE";
    static final String SHARED_KEY = "OPTIONS_SHARED_MAIN_TITLE";
    static final String SPEED_KEY = "OPTIONS_SPEED_MAIN_TITLE";
    static final String DOWNLOAD_KEY = "OPTIONS_DOWNLOAD_MAIN_TITLE";
    static final String UPLOAD_KEY = "OPTIONS_UPLOAD_MAIN_TITLE";
    static final String UPLOAD_BASIC_KEY = "OPTIONS_UPLOAD_BASIC_MAIN_TITLE";
    static final String UPLOAD_SLOTS_KEY = "OPTIONS_UPLOAD_SLOTS_MAIN_TITLE";
    static final String CONNECTIONS_KEY = "OPTIONS_CONNECTIONS_MAIN_TITLE";
    static final String SHUTDOWN_KEY = "OPTIONS_SHUTDOWN_MAIN_TITLE";
    static final String UPDATE_KEY = "OPTIONS_UPDATE_MAIN_TITLE";
    static final String CHAT_KEY = "OPTIONS_CHAT_MAIN_TITLE";
    static final String PLAYER_KEY = "OPTIONS_PLAYER_MAIN_TITLE";
    static final String STATUS_BAR_KEY = "OPTIONS_STATUS_BAR_MAIN_TITLE";
    static final String ITUNES_KEY = "OPTIONS_ITUNES_MAIN_TITLE";
    static final String ITUNES_IMPORT_KEY = "OPTIONS_ITUNES_PREFERENCE_MAIN_TITLE";
    static final String ITUNES_DAAP_KEY = "OPTIONS_ITUNES_DAAP_MAIN_TITLE";
    static final String POPUPS_KEY = "OPTIONS_POPUPS_MAIN_TITLE";
    static final String BUGS_KEY = "OPTIONS_BUGS_MAIN_TITLE";
    static final String APPS_KEY = "OPTIONS_APPS_MAIN_TITLE";
    static final String SEARCH_KEY = "OPTIONS_SEARCH_MAIN_TITLE";
    static final String SEARCH_LIMIT_KEY = "OPTIONS_SEARCH_LIMIT_MAIN_TITLE";
    static final String SEARCH_QUALITY_KEY = "OPTIONS_SEARCH_QUALITY_MAIN_TITLE";
    static final String SEARCH_SPEED_KEY = "OPTIONS_SEARCH_SPEED_MAIN_TITLE";
    static final String CONTENT_FILTER_KEY = "OPTIONS_CONTENT_FILTER_MAIN_TITLE";
    static final String SEARCH_JUNK_KEY = "OPTIONS_SEARCH_JUNK_MAIN_TITLE";
    static final String FILTERS_KEY = "OPTIONS_FILTERS_MAIN_TITLE";
    static final String RESULTS_KEY = "OPTIONS_RESULTS_MAIN_TITLE";
    static final String MESSAGES_KEY = "OPTIONS_MESSAGES_MAIN_TITLE";
    static final String ADVANCED_KEY = "OPTIONS_ADVANCED_MAIN_TITLE";
    static final String PREFERENCING_KEY = "OPTIONS_PREFERENCING_MAIN_TITLE";
    static final String FIREWALL_KEY = "OPTIONS_FIREWALL_MAIN_TITLE";
    static final String GUI_KEY = "OPTIONS_GUI_MAIN_TITLE";
    static final String AUTOCOMPLETE_KEY = "OPTIONS_AUTOCOMPLETE_MAIN_TITLE";
    static final String STARTUP_KEY = "OPTIONS_STARTUP_MAIN_TITLE";
    static final String PROXY_KEY = "OPTIONS_PROXY_MAIN_TITLE";

    public OptionsConstructor(OptionsTreeManager treeManager, OptionsPaneManager paneManager) {
        this.TREE_MANAGER = treeManager;
        this.PANE_MANAGER = paneManager;
        String title = GUIMediator.getStringResource("OPTIONS_TITLE");
        boolean shouldBeModal = !CommonUtils.isMacOSX();
        this.DIALOG = new JDialog(GUIMediator.getAppFrame(), title, shouldBeModal);
        this.DIALOG.setDefaultCloseOperation(0);
        GUIUtils.addHideAction((JComponent)this.DIALOG.getContentPane());
        if (CommonUtils.isWindows() || CommonUtils.isMacOSX()) {
            this.DIALOG.setResizable(false);
        }
        this.DIALOG.setSize(600, 460);
        this.DIALOG.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                try {
                    int answer = -1;
                    if (OptionsMediator.instance().isDirty() && (answer = GUIMediator.showYesNoCancelMessage("OPTIONS_SAVE_ON_CLOSE")) == 101) {
                        OptionsMediator.instance().applyOptions();
                        SettingsHandler.save();
                    }
                    if (answer != 103) {
                        OptionsConstructor.this.DIALOG.dispose();
                        OptionsMediator.instance().disposeOptions();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        PaddedPanel mainPanel = new PaddedPanel();
        Box splitBox = new Box(0);
        Component treeComponent = this.TREE_MANAGER.getComponent();
        Component paneComponent = this.PANE_MANAGER.getComponent();
        splitBox.add(treeComponent);
        splitBox.add(paneComponent);
        mainPanel.add(splitBox);
        mainPanel.add(Box.createVerticalStrut(17));
        mainPanel.add(new OptionsButtonPanel().getComponent());
        this.DIALOG.getContentPane().add(mainPanel);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", SAVE_KEY);
        this.addOption(SAVE_KEY, SAVE_BASIC_KEY);
        this.addOption(SAVE_KEY, SAVE_ADVANCED_KEY);
        this.addOption("OPTIONS_ROOT_NODE", SHARED_KEY);
        this.addOption("OPTIONS_ROOT_NODE", SPEED_KEY);
        this.addOption("OPTIONS_ROOT_NODE", DOWNLOAD_KEY);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", UPLOAD_KEY);
        this.addOption(UPLOAD_KEY, UPLOAD_BASIC_KEY);
        this.addOption(UPLOAD_KEY, UPLOAD_SLOTS_KEY);
        this.addOption("OPTIONS_ROOT_NODE", CONNECTIONS_KEY);
        this.addOption("OPTIONS_ROOT_NODE", SHUTDOWN_KEY);
        this.addOption("OPTIONS_ROOT_NODE", UPDATE_KEY);
        this.addOption("OPTIONS_ROOT_NODE", CHAT_KEY);
        this.addOption("OPTIONS_ROOT_NODE", PLAYER_KEY);
        this.addOption("OPTIONS_ROOT_NODE", STATUS_BAR_KEY);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", ITUNES_KEY);
        if (CommonUtils.isMacOSX()) {
            this.addOption(ITUNES_KEY, ITUNES_IMPORT_KEY);
        }
        this.addOption(ITUNES_KEY, ITUNES_DAAP_KEY);
        if (!CommonUtils.isWindows() && !CommonUtils.isAnyMac()) {
            this.addOption("OPTIONS_ROOT_NODE", APPS_KEY);
        }
        this.addOption("OPTIONS_ROOT_NODE", BUGS_KEY);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", GUI_KEY);
        this.addOption(GUI_KEY, POPUPS_KEY);
        this.addOption(GUI_KEY, AUTOCOMPLETE_KEY);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", SEARCH_KEY);
        this.addOption(SEARCH_KEY, SEARCH_LIMIT_KEY);
        this.addOption(SEARCH_KEY, SEARCH_QUALITY_KEY);
        this.addOption(SEARCH_KEY, SEARCH_SPEED_KEY);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", FILTERS_KEY);
        this.addOption(FILTERS_KEY, CONTENT_FILTER_KEY);
        this.addOption(FILTERS_KEY, SEARCH_JUNK_KEY);
        this.addOption(FILTERS_KEY, RESULTS_KEY);
        this.addOption(FILTERS_KEY, MESSAGES_KEY);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", ADVANCED_KEY);
        this.addOption(ADVANCED_KEY, PREFERENCING_KEY);
        this.addOption(ADVANCED_KEY, FIREWALL_KEY);
        this.addOption(ADVANCED_KEY, PROXY_KEY);
        if (GUIUtils.shouldShowStartOnStartupWindow()) {
            this.addOption(ADVANCED_KEY, STARTUP_KEY);
        }
        this.PANE_MANAGER.show(SAVE_BASIC_KEY);
    }

    private final void addGroupTreeNode(String parentKey, String childKey) {
        this.TREE_MANAGER.addNode(parentKey, childKey, GUIMediator.getStringResource(childKey));
    }

    private final void addOption(String parentKey, String childKey) {
        this.TREE_MANAGER.addNode(parentKey, childKey, GUIMediator.getStringResource(childKey));
    }

    final void setOptionsVisible(boolean visible, String key) {
        if (!visible) {
            this.DIALOG.dispose();
            OptionsMediator.instance().disposeOptions();
        } else {
            if (GUIMediator.isAppVisible()) {
                this.DIALOG.setLocationRelativeTo(GUIMediator.getAppFrame());
            } else {
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Dimension dialogSize = this.DIALOG.getSize();
                this.DIALOG.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
            }
            if (key == null) {
                this.TREE_MANAGER.setDefaultSelection();
            } else {
                this.TREE_MANAGER.setSelection(key);
            }
            this.DIALOG.setVisible(true);
        }
    }

    public final boolean isOptionsVisible() {
        return this.DIALOG.isVisible();
    }

    JDialog getMainOptionsComponent() {
        return this.DIALOG;
    }
}

