/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.options.OptionsPane;
import com.limegroup.gnutella.gui.options.OptionsPaneFactory;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.CardLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;

public final class OptionsPaneManager {
    private final JPanel MAIN_PANEL = new JPanel();
    private final CardLayout CARD_LAYOUT = new CardLayout();
    private final ArrayList OPTIONS_PANE_LIST = new ArrayList();
    private final Map panesByKey = new HashMap();
    private final OptionsPaneFactory FACTORY = new OptionsPaneFactory();
    private Set sharedDirs;

    public OptionsPaneManager() {
        this.MAIN_PANEL.setLayout(this.CARD_LAYOUT);
        this.sharedDirs = new HashSet(SharingSettings.DIRECTORIES_TO_SHARE.getValue());
    }

    public final void show(String name) {
        if (!this.panesByKey.containsKey(name)) {
            OptionsPane pane = this.FACTORY.createOptionsPane(name);
            pane.initOptions();
            this.addPane(pane);
            this.panesByKey.put(name, pane);
            if (name.equals("OPTIONS_SAVE_BASIC_MAIN_TITLE") && !this.panesByKey.containsKey("OPTIONS_SHARED_MAIN_TITLE")) {
                OptionsPane shared = this.FACTORY.createOptionsPane("OPTIONS_SHARED_MAIN_TITLE");
                shared.initOptions();
                this.addPane(shared);
                this.panesByKey.put(name, shared);
            }
        }
        this.CARD_LAYOUT.show(this.MAIN_PANEL, name);
    }

    public void initOptions() {
        int size = this.OPTIONS_PANE_LIST.size();
        for (int i = 0; i < size; ++i) {
            OptionsPane op = (OptionsPane)this.OPTIONS_PANE_LIST.get(i);
            op.initOptions();
        }
    }

    public final void applyOptions() throws IOException {
        boolean restartRequired = false;
        int size = this.OPTIONS_PANE_LIST.size();
        for (int i = 0; i < size; ++i) {
            OptionsPane op = (OptionsPane)this.OPTIONS_PANE_LIST.get(i);
            restartRequired |= op.applyOptions();
        }
        Set shared = this.FACTORY.getSharedPane().getDirectoriesToShare();
        if (!((Object)this.sharedDirs).equals(shared)) {
            this.sharedDirs = shared;
            RouterService.getFileManager().loadWithNewDirectories(shared);
        }
        if (restartRequired) {
            GUIMediator.showMessage("OPTIONS_RESTART_REQUIRED");
        }
    }

    public final boolean isDirty() {
        int size = this.OPTIONS_PANE_LIST.size();
        for (int i = 0; i < size; ++i) {
            OptionsPane op = (OptionsPane)this.OPTIONS_PANE_LIST.get(i);
            if (!op.isDirty()) continue;
            return true;
        }
        return false;
    }

    public final Component getComponent() {
        return this.MAIN_PANEL;
    }

    public final void addPane(OptionsPane pane) {
        this.MAIN_PANEL.add((Component)pane.getContainer(), pane.getName());
        this.OPTIONS_PANE_LIST.add(pane);
    }
}

