/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options;

import com.limegroup.gnutella.gui.options.OptionsTreeModel;
import com.limegroup.gnutella.gui.options.OptionsTreeNode;
import com.limegroup.gnutella.gui.options.OptionsTreeSelectionListener;
import com.limegroup.gnutella.gui.trees.LimeTreeCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

final class OptionsTreeManager {
    private final JScrollPane SCROLL_PANE;
    private final JTree TREE;
    private final OptionsTreeModel TREE_MODEL = new OptionsTreeModel();

    OptionsTreeManager() {
        this.TREE = new JTree();
        this.TREE.setEditable(false);
        this.TREE.setShowsRootHandles(true);
        this.TREE.setRootVisible(false);
        this.TREE.putClientProperty("JTree.lineStyle", "None");
        this.TREE.getSelectionModel().setSelectionMode(1);
        this.TREE.addTreeSelectionListener(new OptionsTreeSelectionListener(this.TREE));
        this.TREE.setCellRenderer(new LimeTreeCellRenderer());
        this.TREE.setModel(this.TREE_MODEL);
        this.SCROLL_PANE = new JScrollPane(this.TREE);
        this.SCROLL_PANE.getViewport().setBackground(Color.white);
        this.SCROLL_PANE.setPreferredSize(new Dimension(125, 2000));
        this.SCROLL_PANE.setMinimumSize(new Dimension(125, 300));
    }

    final void addNode(String parentKey, String childKey, String displayName) {
        this.TREE_MODEL.addNode(parentKey, childKey, displayName);
    }

    final Component getComponent() {
        return this.SCROLL_PANE;
    }

    void setSelection(String key) {
        if (key == null) {
            return;
        }
        OptionsTreeNode root = (OptionsTreeNode)this.TREE_MODEL.getRoot();
        OptionsTreeNode node = null;
        Enumeration<TreeNode> en = root.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            node = (OptionsTreeNode)en.nextElement();
            if (!key.equals(node.getTitleKey())) continue;
            TreePath tp = new TreePath(node.getPath());
            this.TREE.expandPath(tp);
            this.TREE.scrollPathToVisible(tp);
            this.TREE.setSelectionPath(tp);
            return;
        }
    }

    void setDefaultSelection() {
        OptionsTreeNode root = (OptionsTreeNode)this.TREE_MODEL.getRoot();
        if (root == null) {
            return;
        }
        OptionsTreeNode node = null;
        Enumeration<TreeNode> en = root.children();
        if (!en.hasMoreElements()) {
            return;
        }
        node = (OptionsTreeNode)en.nextElement();
        if (node == null) {
            return;
        }
        TreePath tp = new TreePath(node.getPath());
        this.TREE.scrollPathToVisible(tp);
        this.TREE.setSelectionPath(tp);
        this.TREE.collapsePath(tp);
    }
}

