/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.TitledPaddedPanel;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.options.panes.PaneItem;
import com.limegroup.gnutella.gui.options.panes.PaneItemMainLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.Box;

public abstract class AbstractPaneItem
implements PaneItem {
    protected static final OptionsMediator MEDIATOR = OptionsMediator.instance();
    private final TitledPaddedPanel CONTAINER = new TitledPaddedPanel();
    private static final Component HORIZONTAL_SEPARATOR = Box.createRigidArea(new Dimension(6, 0));
    private static final Component VERTICAL_SEPARATOR = Box.createRigidArea(new Dimension(0, 6));

    protected AbstractPaneItem(String key) {
        this(key, null);
    }

    protected AbstractPaneItem(String key, String url) {
        String title = "OPTIONS_" + key + "_TITLE";
        String label = "OPTIONS_" + key + "_LABEL";
        this.CONTAINER.setTitle(GUIMediator.getStringResource(title));
        this.add(new PaneItemMainLabel(GUIMediator.getStringResource(label), url).getLabel());
    }

    public Container getContainer() {
        return this.CONTAINER;
    }

    public abstract void initOptions();

    public abstract boolean applyOptions() throws IOException;

    protected final void add(Component comp) {
        this.CONTAINER.add(comp);
    }

    protected final Component getHorizontalSeparator() {
        return HORIZONTAL_SEPARATOR;
    }

    protected final Component getVerticalSeparator() {
        return VERTICAL_SEPARATOR;
    }
}

