/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedWholeNumberField;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;

public final class ConnectionPreferencingPaneItem
extends AbstractPaneItem {
    private final String BOX_LABEL_KEY = "OPTIONS_CONNECT_PREF_BOX_LABEL";
    private final String SLIDER_LABEL_KEY = "OPTIONS_CONNECT_PREF_SLIDER_LABEL";
    private final String SLIDER_MIN_LABEL_KEY = "OPTIONS_CONNECT_PREF_SLIDER_MIN_LABEL";
    private final String SLIDER_MAX_LABEL_KEY = "OPTIONS_CONNECT_PREF_SLIDER_MAX_LABEL";
    private final WholeNumberField FILES_FIELD = new SizedWholeNumberField(SharingSettings.FREELOADER_FILES.getValue(), 3);
    private JSlider _slider;

    public ConnectionPreferencingPaneItem(String key) {
        super(key);
        int MIN_VALUE = 10;
        int MAX_VALUE = 100;
        int initialValue = Math.max(10, SharingSettings.FREELOADER_ALLOWED.getValue());
        this._slider = new JSlider(10, 100, initialValue);
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        String labelMinStr = GUIMediator.getStringResource("OPTIONS_CONNECT_PREF_SLIDER_MIN_LABEL");
        String labelMaxStr = GUIMediator.getStringResource("OPTIONS_CONNECT_PREF_SLIDER_MAX_LABEL");
        JLabel minLabel = new JLabel(labelMinStr);
        JLabel maxLabel = new JLabel(labelMaxStr);
        labels.put(new Integer(10), minLabel);
        labels.put(new Integer(100), maxLabel);
        this._slider.setLabelTable(labels);
        this._slider.setPaintLabels(true);
        LabeledComponent comp0 = new LabeledComponent("OPTIONS_CONNECT_PREF_BOX_LABEL", this.FILES_FIELD);
        LabeledComponent comp1 = new LabeledComponent("OPTIONS_CONNECT_PREF_SLIDER_LABEL", this._slider);
        this.add(comp0.getComponent());
        this.add(this.getVerticalSeparator());
        this.add(comp1.getComponent());
    }

    public void initOptions() {
        this.FILES_FIELD.setValue(SharingSettings.FREELOADER_FILES.getValue());
        this._slider.setValue(SharingSettings.FREELOADER_ALLOWED.getValue());
    }

    public boolean applyOptions() throws IOException {
        try {
            SharingSettings.FREELOADER_FILES.setValue(this.FILES_FIELD.getValue());
            SharingSettings.FREELOADER_ALLOWED.setValue(this._slider.getValue());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    public boolean isDirty() {
        return SharingSettings.FREELOADER_FILES.getValue() != this.FILES_FIELD.getValue() || SharingSettings.FREELOADER_ALLOWED.getValue() != this._slider.getValue();
    }
}

