/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.spam.SpamManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;

public final class EnableSpamFilterPaneItem
extends AbstractPaneItem {
    private JRadioButton DISPLAY_IN_PLACE = new JRadioButton();
    private JRadioButton MOVE_TO_BOTTOM = new JRadioButton();
    private JRadioButton HIDE_SPAM = new JRadioButton();
    private JSlider THRESHOLD = new JSlider(0, 50);
    private JButton RESET = new JButton();

    public EnableSpamFilterPaneItem(String key) {
        super(key);
        this.DISPLAY_IN_PLACE.setText(GUIMediator.getStringResource("OPTIONS_SEARCH_JUNK_DISPLAY_IN_PLACE"));
        this.MOVE_TO_BOTTOM.setText(GUIMediator.getStringResource("OPTIONS_SEARCH_JUNK_MOVE_TO_BOTTOM"));
        this.HIDE_SPAM.setText(GUIMediator.getStringResource("OPTIONS_SEARCH_JUNK_HIDE_SPAM"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.DISPLAY_IN_PLACE);
        group.add(this.MOVE_TO_BOTTOM);
        group.add(this.HIDE_SPAM);
        BoxPanel buttonPanel = new BoxPanel();
        buttonPanel.add(this.DISPLAY_IN_PLACE);
        buttonPanel.add(this.MOVE_TO_BOTTOM);
        buttonPanel.add(this.HIDE_SPAM);
        this.RESET.setText(GUIMediator.getStringResource("OPTIONS_SEARCH_JUNK_RESET_LABEL"));
        this.RESET.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SpamManager.instance().clearFilterData();
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setOpaque(false);
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = null;
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(10, 0, 3, 0);
        mainPanel.add((Component)new JLabel(GUIMediator.getStringResource("OPTIONS_SEARCH_JUNK_DISPLAY")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        mainPanel.add(Box.createHorizontalStrut(10), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        mainPanel.add((Component)buttonPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(10, 0, 3, 0);
        mainPanel.add((Component)new JLabel(GUIMediator.getStringResource("OPTIONS_SEARCH_JUNK_THRESHOLD")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        mainPanel.add(Box.createHorizontalStrut(10), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        LabeledComponent comp = new LabeledComponent("OPTIONS_SEARCH_JUNK_THRESHOLD_LAX", this.THRESHOLD);
        this.THRESHOLD.setToolTipText(GUIMediator.getStringResource("OPTIONS_SEARCH_JUNK_THRESHOLD_TOOLTIP"));
        mainPanel.add(comp.getComponent(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        mainPanel.add((Component)new JLabel(GUIMediator.getStringResource("OPTIONS_SEARCH_JUNK_THRESHOLD_STRICT")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.anchor = 15;
        gbc.fill = 0;
        gbc.gridwidth = 3;
        gbc.weighty = 1.0;
        mainPanel.add((Component)this.RESET, gbc);
        this.add(mainPanel);
    }

    public void initOptions() {
        switch (SearchSettings.DISPLAY_JUNK_MODE.getValue()) {
            case 0: {
                this.DISPLAY_IN_PLACE.setSelected(true);
                break;
            }
            case 2: {
                this.HIDE_SPAM.setSelected(true);
                break;
            }
            default: {
                this.MOVE_TO_BOTTOM.setSelected(true);
            }
        }
        this.THRESHOLD.setValue((int)(100.0f - 100.0f * SearchSettings.FILTER_SPAM_RESULTS.getValue()));
    }

    public boolean applyOptions() throws IOException {
        if (this.DISPLAY_IN_PLACE.isSelected()) {
            SearchSettings.DISPLAY_JUNK_MODE.setValue(0);
        } else if (this.HIDE_SPAM.isSelected()) {
            SearchSettings.DISPLAY_JUNK_MODE.setValue(2);
        } else {
            SearchSettings.DISPLAY_JUNK_MODE.setValue(1);
        }
        SearchSettings.FILTER_SPAM_RESULTS.setValue((float)(100 - this.THRESHOLD.getValue()) / 100.0f);
        return false;
    }

    public boolean isDirty() {
        boolean modeChange = false;
        modeChange = this.DISPLAY_IN_PLACE.isSelected() ? SearchSettings.DISPLAY_JUNK_MODE.getValue() != 0 : (this.HIDE_SPAM.isSelected() ? SearchSettings.DISPLAY_JUNK_MODE.getValue() != 2 : SearchSettings.DISPLAY_JUNK_MODE.getValue() != 1);
        return modeChange || SearchSettings.FILTER_SPAM_RESULTS.getValue() != (float)(100 - this.THRESHOLD.getValue()) / 100.0f;
    }
}

