/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.tables.AbstractDataLine;
import com.limegroup.gnutella.gui.tables.IconAndNameHolder;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.settings.FileSetting;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;
import java.io.IOException;
import java.util.Set;

public class MediaTypeDownloadDirDataLine
extends AbstractDataLine {
    private NamedMediaType nm;
    private String dir;
    private FileSetting setting;
    private boolean isReset;
    private String defaultDir;
    private static final LimeTableColumn[] columns = new LimeTableColumn[]{new LimeTableColumn(0, "OPTIONS_SAVE_MEDIATYPE", 60, true, IconAndNameHolder.class), new LimeTableColumn(1, "OPTIONS_SAVE_DIRECTORY", 100, true, String.class)};

    public int getColumnCount() {
        return columns.length;
    }

    public void setDefaultDir(String text) {
        this.defaultDir = text;
    }

    public void reset() {
        this.dir = null;
        this.isReset = true;
    }

    public void saveDirectory(Set newDirs) throws IOException {
        boolean dirty = this.isDirty();
        if (this.isReset) {
            this.setting.revertToDefault();
        } else if (this.dir != null && !this.setting.getValue().equals(new File(this.dir))) {
            this.setting.setValue(new File(this.dir));
        }
        if (dirty) {
            newDirs.add(this.setting.getValue());
        }
    }

    public LimeTableColumn getColumn(int col) {
        return columns[col];
    }

    public boolean isDynamic(int col) {
        return false;
    }

    public boolean isClippable(int col) {
        return true;
    }

    public void initialize(Object obj) {
        super.initialize(obj);
        this.nm = (NamedMediaType)obj;
        this.setting = SharingSettings.getFileSettingForMediaType(this.nm.getMediaType());
        this.isReset = false;
    }

    public Object getValueAt(int col) {
        switch (col) {
            case 0: {
                return this.nm;
            }
            case 1: {
                return this.getVisibleDirectoryString();
            }
        }
        return null;
    }

    boolean isDirty() {
        return this.dir != null && !this.setting.getValue().equals(new File(this.dir));
    }

    public void setDirectory(String dir) {
        this.dir = dir;
        this.isReset = false;
    }

    String getVisibleDirectoryString() {
        if (this.dir != null) {
            return this.dir;
        }
        if (this.isReset || this.setting.isDefault()) {
            return this.defaultDir;
        }
        return this.setting.getValue().getAbsolutePath();
    }

    String getDirectory() {
        return this.dir;
    }

    public int getTypeAheadColumn() {
        return 0;
    }
}

