/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.SaveDirectoryHandler;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.options.panes.MediaTypeDownloadDirDataLine;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.BasicDataLineModel;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.TableSettings;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class MediaTypeDownloadDirMediator
extends AbstractTableMediator {
    private final JTextField saveField;
    private BrowseDirectoryAction browseAction;
    private ResetDirectoryAction resetAction;
    private static TableSettings cachedSettings = null;

    public MediaTypeDownloadDirMediator(JTextField field) {
        super("MEDIA_TYPE_DOWNLOAD_DIR_TABLE");
        this.saveField = field;
        this.saveField.getDocument().addDocumentListener(new DocumentHandler());
    }

    public boolean isDirty() {
        for (int i = 0; i < this.DATA_MODEL.getRowCount(); ++i) {
            if (!((MediaTypeDownloadDirDataLine)this.DATA_MODEL.get(i)).isDirty()) continue;
            return true;
        }
        return false;
    }

    protected void buildSettings() {
        if (cachedSettings == null) {
            super.buildSettings();
            cachedSettings = this.SETTINGS;
        }
        this.SETTINGS = cachedSettings;
    }

    protected void setupConstants() {
        this.MAIN_PANEL = new PaddedPanel(0);
        this.DATA_MODEL = new MediaTypeDownloadDirModel(MediaTypeDownloadDirDataLine.class);
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        this.TABLE.setSelectionMode(0);
        this.browseAction = new BrowseDirectoryAction();
        this.resetAction = new ResetDirectoryAction();
    }

    public boolean applyOptions(Set newDirs) throws IOException {
        for (int i = 0; i < this.DATA_MODEL.getRowCount(); ++i) {
            MediaTypeDownloadDirDataLine dl = (MediaTypeDownloadDirDataLine)this.DATA_MODEL.get(i);
            dl.saveDirectory(newDirs);
        }
        return false;
    }

    void addSaveDirs(Set set) {
        for (int i = 0; i < this.DATA_MODEL.getRowCount(); ++i) {
            String dir = ((MediaTypeDownloadDirDataLine)this.DATA_MODEL.get(i)).getDirectory();
            if (dir == null) continue;
            set.add(new File(dir));
        }
    }

    public void initOptions() {
        this.DATA_MODEL.clear();
        Iterator i = NamedMediaType.getAllNamedMediaTypes().iterator();
        while (i.hasNext()) {
            NamedMediaType nm = (NamedMediaType)i.next();
            if (nm.getMediaType().getMimeType().equals("*")) continue;
            this.DATA_MODEL.add(nm);
        }
        this.DATA_MODEL.sort(0);
        this.DATA_MODEL.sort(0);
        this.updateModel();
    }

    public Action getBrowseDirectoryAction() {
        return this.browseAction;
    }

    public Action getResetDirectoryAction() {
        return this.resetAction;
    }

    public void removeSelection() {
    }

    protected void updateSplashScreen() {
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new JMenuItem(this.browseAction));
        menu.add(new JMenuItem(this.resetAction));
        return menu;
    }

    public void handleHeaderPopupMenu(Point p) {
    }

    public void handleActionKey() {
    }

    public void handleSelection(int row) {
        this.browseAction.setEnabled(true);
        this.resetAction.setEnabled(true);
    }

    public void handleNoSelection() {
        this.browseAction.setEnabled(false);
        this.resetAction.setEnabled(false);
    }

    private void setDirectory(DataLine line, File dir) {
        if (!SaveDirectoryHandler.isSaveDirectoryValid(dir)) {
            GUIMediator.showError("ERROR_INVALID_SAVE_DIRECTORY_SELECTION");
            return;
        }
        try {
            String newDir = dir.getCanonicalPath();
            MediaTypeDownloadDirDataLine dl = (MediaTypeDownloadDirDataLine)line;
            dl.setDirectory(newDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void updateModel() {
        String text = this.saveField.getText();
        for (int i = 0; i < this.TABLE.getRowCount(); ++i) {
            MediaTypeDownloadDirDataLine line = (MediaTypeDownloadDirDataLine)this.DATA_MODEL.get(i);
            line.setDefaultDir(text);
        }
        this.DATA_MODEL.fireTableDataChanged();
    }

    private class DocumentHandler
    implements DocumentListener {
        private DocumentHandler() {
        }

        public void insertUpdate(DocumentEvent e) {
            MediaTypeDownloadDirMediator.this.updateModel();
        }

        public void removeUpdate(DocumentEvent e) {
            MediaTypeDownloadDirMediator.this.updateModel();
        }

        public void changedUpdate(DocumentEvent e) {
        }
    }

    private class ResetDirectoryAction
    extends AbstractAction {
        public ResetDirectoryAction() {
            this.putValue("Name", GUIMediator.getStringResource("OPTIONS_SAVE_RESET_BUTTON_LABEL"));
            this.putValue("ShortDescription", GUIMediator.getStringResource("OPTIONS_SAVE_RESET_BUTTON_TIP"));
        }

        public void actionPerformed(ActionEvent e) {
            DataLine line = MediaTypeDownloadDirMediator.this.TABLE.getSelectedDataLine();
            if (line == null) {
                throw new IllegalArgumentException("reset action was not correctly disabled");
            }
            MediaTypeDownloadDirDataLine mediaLine = (MediaTypeDownloadDirDataLine)line;
            mediaLine.reset();
            MediaTypeDownloadDirMediator.this.DATA_MODEL.fireTableDataChanged();
        }
    }

    private class BrowseDirectoryAction
    extends AbstractAction {
        public BrowseDirectoryAction() {
            this.putValue("Name", GUIMediator.getStringResource("GENERAL_BROWSE_BUTTON_LABEL"));
            this.putValue("ShortDescription", GUIMediator.getStringResource("OPTIONS_SAVE_MEDIATYPE_BROWSE_TIP"));
        }

        public void actionPerformed(ActionEvent e) {
            MediaTypeDownloadDirDataLine line = (MediaTypeDownloadDirDataLine)MediaTypeDownloadDirMediator.this.TABLE.getSelectedDataLine();
            if (line == null) {
                throw new IllegalArgumentException("browse action was not correctly disabled");
            }
            File dir = FileChooserHandler.getInputDirectory(OptionsMediator.instance().getMainOptionsComponent(), new File(line.getVisibleDirectoryString()));
            if (dir != null) {
                MediaTypeDownloadDirMediator.this.setDirectory(line, dir);
            }
        }
    }

    class MediaTypeDownloadDirModel
    extends BasicDataLineModel {
        public MediaTypeDownloadDirModel(Class dataLineClass) {
            super(dataLineClass);
        }

        public DataLine createDataLine() {
            return new MediaTypeDownloadDirDataLine();
        }

        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        public void setValueAt(Object value, int row, int col) {
            MediaTypeDownloadDirMediator.this.setDirectory(this.get(row), new File((String)value));
        }
    }
}

