/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SaveDirectoryHandler;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.gui.options.panes.MediaTypeDownloadDirMediator;
import com.limegroup.gnutella.gui.options.panes.SharedDirPaneItem;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTextField;

public final class SaveDirPaneItem
extends AbstractPaneItem {
    private final String OPTION_LABEL = "OPTIONS_SAVE_DIR_BOX_LABEL";
    private final SharedDirPaneItem _shareData;
    private JTextField _saveField;
    private String _saveDirectory;
    private MediaTypeDownloadDirMediator _mtddMediator;
    private final String MEDIA_OPTION_LABEL = "OPTIONS_SAVE_MEDIATYPE_DIR_LABEL";

    public SaveDirPaneItem(String key, SharedDirPaneItem shareStuff) {
        super(key);
        this._shareData = shareStuff;
        this._saveField = new SizedTextField();
        LabeledComponent comp = new LabeledComponent("OPTIONS_SAVE_DIR_BOX_LABEL", this._saveField, 13);
        String[] labelKeys = new String[]{"OPTIONS_SAVE_DIR_BROWSE_BUTTON_LABEL", "OPTIONS_SAVE_DIR_DEFAULT_BUTTON_LABEL"};
        String[] toolTipKeys = new String[]{"OPTIONS_SAVE_DIR_BROWSE_BUTTON_TIP", "OPTIONS_SAVE_DIR_DEFAULT_BUTTON_TIP"};
        ActionListener[] listeners = new ActionListener[]{new SelectSaveDirectoryListener(), new DefaultListener()};
        ButtonRow br = new ButtonRow(labelKeys, toolTipKeys, listeners, 0, 12);
        this.add(comp.getComponent());
        this.add(this.getVerticalSeparator());
        this.add(br);
        this.add(this.getVerticalSeparator());
        this._mtddMediator = new MediaTypeDownloadDirMediator(this._saveField);
        comp = new LabeledComponent("OPTIONS_SAVE_MEDIATYPE_DIR_LABEL", this._mtddMediator.getComponent(), 13, 140);
        this.add(comp.getComponent());
        Action[] actions = new AbstractAction[]{this._mtddMediator.getBrowseDirectoryAction(), this._mtddMediator.getResetDirectoryAction()};
        br = new ButtonRow(actions, 0, 12);
        this.add(this.getVerticalSeparator());
        this.add(br);
    }

    public void initOptions() {
        try {
            File file = SharingSettings.getSaveDirectory();
            if (file == null) {
                throw new FileNotFoundException();
            }
            this._saveDirectory = file.getCanonicalPath();
        }
        catch (FileNotFoundException fnfe) {
            this._saveDirectory = "";
        }
        catch (IOException ioe) {
            this._saveDirectory = "";
        }
        this._saveField.setText(this._saveDirectory);
        this._mtddMediator.initOptions();
    }

    public boolean applyOptions() throws IOException {
        String save = this._saveField.getText();
        HashSet<File> newDirs = new HashSet<File>();
        if (!save.equals(this._saveDirectory)) {
            try {
                File saveDir = new File(save);
                if (!saveDir.isDirectory() && !saveDir.mkdirs()) {
                    throw new IOException();
                }
                if (!this._shareData.isGoingToBeShared(saveDir)) {
                    newDirs.add(saveDir);
                }
                SharingSettings.setSaveDirectory(saveDir);
                this._saveDirectory = save;
            }
            catch (IOException ioe) {
                GUIMediator.showError("ERROR_INVALID_SAVE_DIRECTORY");
                this._saveField.setText(this._saveDirectory);
                throw new IOException();
            }
            catch (NullPointerException npe) {
                GUIMediator.showError("ERROR_INVALID_SAVE_DIRECTORY");
                this._saveField.setText(this._saveDirectory);
                throw new IOException();
            }
        }
        boolean restart = this._mtddMediator.applyOptions(newDirs);
        if (!newDirs.isEmpty()) {
            String format = "";
            Iterator i = newDirs.iterator();
            while (i.hasNext()) {
                format = format + GUIUtils.convertToNonBreakingSpaces(4, i.next().toString()) + "\n";
            }
            int response = GUIMediator.showYesNoMessage("OPTIONS_SHARED_NEW_SAVE_FOLDERS", format);
            if (response == 101) {
                Iterator i2 = newDirs.iterator();
                while (i2.hasNext()) {
                    this._shareData.addAndKeepDirtyStatus((File)i2.next());
                }
            }
        }
        return restart;
    }

    Collection getSaveDirectories() {
        HashSet<File> dirs = new HashSet<File>();
        dirs.add(new File(this._saveDirectory));
        this._mtddMediator.addSaveDirs(dirs);
        return dirs;
    }

    public boolean isDirty() {
        return !SharingSettings.getSaveDirectory().equals(new File(this._saveField.getText())) || this._mtddMediator.isDirty();
    }

    private class SelectSaveDirectoryListener
    implements ActionListener {
        private SelectSaveDirectoryListener() {
        }

        public void actionPerformed(ActionEvent e) {
            File dir = FileChooserHandler.getInputDirectory(AbstractPaneItem.MEDIATOR.getMainOptionsComponent());
            if (dir == null) {
                return;
            }
            if (!SaveDirectoryHandler.isSaveDirectoryValid(dir)) {
                GUIMediator.showError("ERROR_INVALID_SAVE_DIRECTORY_SELECTION");
                return;
            }
            try {
                String newDir = dir.getCanonicalPath();
                if (!newDir.equals(SaveDirPaneItem.this._saveDirectory)) {
                    SaveDirPaneItem.this._saveField.setText(newDir);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class DefaultListener
    implements ActionListener {
        private DefaultListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SaveDirPaneItem.this._saveField.setText(SharingSettings.DEFAULT_SAVE_DIR.getAbsolutePath());
        }
    }
}

