/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.SearchSettings;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public final class SearchSpeedPaneItem
extends AbstractPaneItem {
    private final JRadioButton T3_BUTTON = new JRadioButton();
    private final JRadioButton T1_BUTTON = new JRadioButton();
    private final JRadioButton CABLE_BUTTON = new JRadioButton();
    private final JRadioButton ALL_BUTTON = new JRadioButton();

    public SearchSpeedPaneItem(String key) {
        super(key);
        String t3LabelKey = "OPTIONS_SEARCH_SPEED_T3_LABEL";
        String t1LabelKey = "OPTIONS_SEARCH_SPEED_T1_LABEL";
        String cableLabelKey = "OPTIONS_SEARCH_SPEED_CABLE_LABEL";
        String allLabelKey = "OPTIONS_SEARCH_SPEED_ALL_LABEL";
        String t3Label = GUIMediator.getStringResource(t3LabelKey);
        String t1Label = GUIMediator.getStringResource(t1LabelKey);
        String cableLabel = GUIMediator.getStringResource(cableLabelKey);
        String allLabel = GUIMediator.getStringResource(allLabelKey);
        this.T3_BUTTON.setText(t3Label);
        this.T1_BUTTON.setText(t1Label);
        this.CABLE_BUTTON.setText(cableLabel);
        this.ALL_BUTTON.setText(allLabel);
        ButtonGroup group = new ButtonGroup();
        group.add(this.T3_BUTTON);
        group.add(this.T1_BUTTON);
        group.add(this.CABLE_BUTTON);
        group.add(this.ALL_BUTTON);
        BoxPanel buttonPanel = new BoxPanel();
        buttonPanel.add(this.T3_BUTTON);
        buttonPanel.add(this.T1_BUTTON);
        buttonPanel.add(this.CABLE_BUTTON);
        buttonPanel.add(this.ALL_BUTTON);
        BoxPanel mainPanel = new BoxPanel(0);
        mainPanel.add(Box.createHorizontalGlue());
        mainPanel.add(buttonPanel);
        mainPanel.add(Box.createHorizontalGlue());
        this.add(mainPanel);
    }

    public void initOptions() {
        int minSpeed = SearchSettings.MINIMUM_SEARCH_SPEED.getValue();
        switch (minSpeed) {
            case 3000: {
                this.T3_BUTTON.setSelected(true);
                break;
            }
            case 1000: {
                this.T1_BUTTON.setSelected(true);
                break;
            }
            case 350: {
                this.CABLE_BUTTON.setSelected(true);
                break;
            }
            default: {
                this.ALL_BUTTON.setSelected(true);
            }
        }
    }

    public boolean applyOptions() throws IOException {
        int speed = 3;
        speed = this.T3_BUTTON.isSelected() ? 3000 : (this.T1_BUTTON.isSelected() ? 1000 : (this.CABLE_BUTTON.isSelected() ? 350 : 0));
        SearchSettings.MINIMUM_SEARCH_SPEED.setValue(speed);
        return false;
    }

    public boolean isDirty() {
        switch (SearchSettings.MINIMUM_SEARCH_SPEED.getValue()) {
            case 3000: {
                return !this.T3_BUTTON.isSelected();
            }
            case 1000: {
                return !this.T1_BUTTON.isSelected();
            }
            case 350: {
                return !this.CABLE_BUTTON.isSelected();
            }
            case 0: {
                return !this.ALL_BUTTON.isSelected();
            }
        }
        return true;
    }
}

