/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.StandardListEditor;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class SharedDirPaneItem
extends AbstractPaneItem {
    private final StandardListEditor DIR_LIST = new StandardListEditor(new SelectSharedDirectoryListener());

    public SharedDirPaneItem(String key) {
        super(key);
        this.add(this.DIR_LIST.getComponent());
    }

    private void addDirectory(File dir) {
        if (!dir.isDirectory()) {
            return;
        }
        if (!this.isGoingToBeShared(dir)) {
            this.DIR_LIST.addFile(dir);
        }
    }

    void addAndKeepDirtyStatus(File dir) {
        boolean wasDirty = this.DIR_LIST.getListChanged();
        this.addDirectory(dir);
        if (!wasDirty) {
            this.DIR_LIST.resetList();
        }
    }

    boolean isGoingToBeShared(File dir) {
        File[] dirs = this.DIR_LIST.getDataAsFileArray();
        for (int i = 0; i < dirs.length; ++i) {
            if (!dirs[i].equals(dir)) continue;
            return true;
        }
        return false;
    }

    public void initOptions() {
        File[] dirs = SharingSettings.DIRECTORIES_TO_SHARE.getValueAsArray();
        this.DIR_LIST.setListData(dirs);
        this.DIR_LIST.resetList();
    }

    public Set getDirectoriesToShare() {
        return new HashSet<File>(Arrays.asList(this.DIR_LIST.getDataAsFileArray()));
    }

    public boolean applyOptions() throws IOException {
        if (this.DIR_LIST.getListChanged()) {
            this.DIR_LIST.resetList();
        }
        return false;
    }

    public boolean isDirty() {
        return this.DIR_LIST.getListChanged();
    }

    private class SelectSharedDirectoryListener
    implements ActionListener {
        private SelectSharedDirectoryListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            File dir = FileChooserHandler.getInputDirectory(AbstractPaneItem.MEDIATOR.getMainOptionsComponent());
            if (dir == null) {
                return;
            }
            if (!dir.isDirectory() || !dir.canRead()) {
                GUIMediator.showError("ERROR_INVALID_SHARED_DIRECTORY");
                return;
            }
            if (FileManager.isSensitiveDirectory(dir) && !RouterService.getCallback().warnAboutSharingSensitiveDirectory(dir)) {
                return;
            }
            SharedDirPaneItem.this.addDirectory(dir);
        }
    }
}

