/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.UpdateSettings;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class UpdatePaneItem
extends AbstractPaneItem {
    private JRadioButton beta = new JRadioButton(GUIMediator.getStringResource("OPTIONS_UPDATE_BETA"));
    private JRadioButton service = new JRadioButton(GUIMediator.getStringResource("OPTIONS_UPDATE_SERVICE"));
    private JRadioButton major = new JRadioButton(GUIMediator.getStringResource("OPTIONS_UPDATE_MAJOR"));

    public UpdatePaneItem(String key) {
        super(key);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.beta);
        bg.add(this.service);
        bg.add(this.major);
        BoxPanel panel = new BoxPanel();
        panel.add(this.major);
        panel.add(this.service);
        panel.add(this.beta);
        BoxPanel outer = new BoxPanel(0);
        outer.add(panel);
        outer.add(Box.createHorizontalGlue());
        this.add(outer);
    }

    public boolean applyOptions() throws IOException {
        if (this.beta.isSelected()) {
            UpdateSettings.UPDATE_STYLE.setValue(0);
        } else if (this.service.isSelected()) {
            UpdateSettings.UPDATE_STYLE.setValue(1);
        } else {
            UpdateSettings.UPDATE_STYLE.setValue(2);
        }
        return false;
    }

    public void initOptions() {
        int style = UpdateSettings.UPDATE_STYLE.getValue();
        if (style <= 0) {
            this.beta.setSelected(true);
        } else if (style == 1) {
            this.service.setSelected(true);
        } else {
            this.major.setSelected(true);
        }
    }

    public boolean isDirty() {
        int style = UpdateSettings.UPDATE_STYLE.getValue();
        if (style <= 0) {
            return !this.beta.isSelected();
        }
        if (style == 1) {
            return !this.service.isSelected();
        }
        return !this.major.isSelected();
    }
}

