/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.playlist;

import com.limegroup.gnutella.gui.mp3.MediaPlayerComponent;
import com.limegroup.gnutella.gui.tables.AbstractDataLine;
import com.limegroup.gnutella.gui.tables.ColoredCell;
import com.limegroup.gnutella.gui.tables.ColoredCellImpl;
import com.limegroup.gnutella.gui.tables.FileTransfer;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.TimeRemainingHolder;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.metadata.AudioMetaData;
import java.awt.Color;
import java.io.File;
import java.io.IOException;

public final class PlaylistDataLine
extends AbstractDataLine
implements FileTransfer {
    static final int NAME_IDX = 0;
    private static final LimeTableColumn NAME_COLUMN = new LimeTableColumn(0, "PLAYLIST_TABLE_NAME", 450, true, ColoredCell.class);
    static final int LENGTH_IDX = 1;
    private static final LimeTableColumn LENGTH_COLUMN = new LimeTableColumn(1, "PLAYLIST_TABLE_LENGTH", 20, true, String.class);
    static final int BITRATE_IDX = 2;
    private static final LimeTableColumn BITRATE_COLUMN = new LimeTableColumn(2, "PLAYLIST_TABLE_BITRATE", 20, true, Integer.class);
    static final int NUMBER_OF_COLUMNS = 3;
    private File FILE;
    private int length;
    private String name;
    private int bitrate;
    private Color _cellColor;
    private Color _othercellColor;

    public int getColumnCount() {
        return 3;
    }

    public void initialize(Object file) {
        super.initialize(file);
        this.FILE = (File)file;
        try {
            AudioMetaData amd = AudioMetaData.parseAudioFile(this.FILE);
            if (amd != null) {
                this.length = amd.getLength();
                this.bitrate = amd.getBitrate();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.name = this.FILE.getName();
        this.updateTheme();
    }

    public Object getValueAt(int idx) {
        switch (idx) {
            case 0: {
                Color color = this.getColor(MediaPlayerComponent.isPlaying(this.FILE));
                return new ColoredCellImpl(this.name, color);
            }
            case 1: {
                return new TimeRemainingHolder(this.length);
            }
            case 2: {
                return new Integer(this.bitrate);
            }
        }
        return null;
    }

    private Color getColor(boolean playing) {
        return playing ? this._othercellColor : this._cellColor;
    }

    public void updateTheme() {
        this._cellColor = ThemeFileHandler.WINDOW8_COLOR.getValue();
        this._othercellColor = ThemeFileHandler.SEARCH_RESULT_SPEED_COLOR.getValue();
    }

    public LimeTableColumn getColumn(int idx) {
        switch (idx) {
            case 0: {
                return NAME_COLUMN;
            }
            case 1: {
                return LENGTH_COLUMN;
            }
            case 2: {
                return BITRATE_COLUMN;
            }
        }
        return null;
    }

    public boolean isClippable(int idx) {
        return idx == 0;
    }

    public int getTypeAheadColumn() {
        return 0;
    }

    public boolean isDynamic(int idx) {
        return false;
    }

    public File getFile() {
        return this.FILE;
    }
}

