/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.AllowFilter;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.TableLineFilter;

class CompositeFilter
implements TableLineFilter {
    private TableLineFilter[] delegates;

    CompositeFilter(int depth) {
        this.delegates = new TableLineFilter[depth];
        this.reset();
    }

    public void reset() {
        for (int i = 0; i < this.delegates.length; ++i) {
            this.delegates[i] = AllowFilter.instance();
        }
    }

    public boolean allow(TableLine line) {
        for (int i = 0; i < this.delegates.length; ++i) {
            if (this.delegates[i].allow(line)) continue;
            return false;
        }
        return true;
    }

    boolean setFilter(int depth, TableLineFilter filter) {
        if (this.delegates[depth].equals(filter)) {
            return false;
        }
        this.delegates[depth] = filter;
        return true;
    }
}

