/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.browser.ExternalControl;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.download.DownloaderUtils;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.util.ProcessingQueue;
import com.limegroup.gnutella.util.StringUtils;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MagnetClipboardListener
extends WindowAdapter {
    private static final Log LOG = LogFactory.getLog(MagnetClipboardListener.class);
    private static final MagnetClipboardListener instance = new MagnetClipboardListener();
    private final Clipboard CLIPBOARD = Toolkit.getDefaultToolkit().getSystemClipboard();
    private final StringSelection empty = new StringSelection("");
    private volatile String copiedText;
    private final ProcessingQueue clipboardParser = new ProcessingQueue("clipboard parser");
    private Runnable parser = new Runnable(){

        public void run() {
            MagnetClipboardListener.this.parseAndLaunch();
        }
    };

    private void parseAndLaunch() {
        Transferable data = null;
        try {
            data = this.CLIPBOARD.getContents(this);
        }
        catch (IllegalStateException isx) {
            return;
        }
        if (data == null) {
            return;
        }
        if (!data.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return;
        }
        String contents = null;
        try {
            contents = (String)data.getTransferData(DataFlavor.stringFlavor);
        }
        catch (IOException iox) {
            LOG.info("problem occured while trying to parse clipboard, do nothing", iox);
            return;
        }
        catch (UnsupportedFlavorException ufx) {
            LOG.error("UnsupportedFlavor??", ufx);
            return;
        }
        if (contents == null) {
            return;
        }
        String copied = this.copiedText;
        if (copied != null && copied.equals(contents)) {
            return;
        }
        final MagnetOptions[] opts = ExternalControl.parseMagnets(contents);
        if (opts.length == 0) {
            return;
        }
        LOG.info("clipboard contains " + contents);
        this.purgeClipboard();
        String address = contents;
        final MagnetOptions[] downloadCandidates = this.extractDownloadableMagnets(opts);
        Runnable r = new Runnable(){

            public void run() {
                if (downloadCandidates.length > 0 && MagnetClipboardListener.this.showStartDownloadsDialog(downloadCandidates)) {
                    for (int i = 0; i < downloadCandidates.length; ++i) {
                        DownloaderUtils.createDownloader(downloadCandidates[i]);
                    }
                }
                boolean oneSearchStarted = false;
                for (int i = 0; i < opts.length; ++i) {
                    String query;
                    SearchInformation info;
                    if (opts[i].isDownloadable() || !opts[i].isKeywordTopicOnly() || oneSearchStarted || SearchMediator.validateInfo(info = SearchInformation.createKeywordSearch(query = StringUtils.createQueryString(opts[i].getKeywordTopic()), null, MediaType.getAnyTypeMediaType())) != 0) continue;
                    oneSearchStarted = true;
                    SearchMediator.triggerSearch(info);
                }
                GUIMediator.instance().setWindow(0);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    private MagnetClipboardListener() {
    }

    public static MagnetClipboardListener getInstance() {
        return instance;
    }

    public void setCopiedText(String text) {
        this.copiedText = text;
    }

    public void windowActivated(WindowEvent e) {
        this.clipboardParser.add(this.parser);
    }

    private void purgeClipboard() {
        try {
            this.CLIPBOARD.setContents(this.empty, this.empty);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private MagnetOptions[] extractDownloadableMagnets(MagnetOptions[] magnets) {
        ArrayList<MagnetOptions> dls = new ArrayList<MagnetOptions>(magnets.length);
        for (int i = 0; i < magnets.length; ++i) {
            MagnetOptions magnet = magnets[i];
            if (magnet.isKeywordTopicOnly()) continue;
            dls.add(magnets[i]);
        }
        if (dls.size() == magnets.length) {
            return magnets;
        }
        return dls.toArray(new MagnetOptions[0]);
    }

    private boolean showStartDownloadsDialog(MagnetOptions[] opts) {
        JList<MagnetOptions> magnetList = new JList<MagnetOptions>(opts);
        magnetList.setCellRenderer(new MagnetOptionsListCellRenderer());
        magnetList.setVisibleRowCount(Math.min(6, opts.length));
        magnetList.setFixedCellWidth(400);
        Object[] content = new Object[]{new MultiLineLabel(GUIMediator.getStringResource("DOWNLOAD_MAGNET_DIALOG_MESSAGE"), 400), new JScrollPane(magnetList)};
        int response = JOptionPane.showConfirmDialog(MessageService.getParentComponent(), content, GUIMediator.getStringResource("MESSAGE_CAPTION"), 0);
        return response == 0;
    }

    private class MagnetOptionsListCellRenderer
    extends DefaultListCellRenderer {
        private MagnetOptionsListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            MagnetOptions magnet = (MagnetOptions)value;
            String fileName = magnet.getDisplayName();
            if (fileName == null) {
                fileName = GUIMediator.getStringResource("NO_FILENAME_LABEL");
            }
            super.getListCellRendererComponent((JList<?>)list, fileName, index, false, false);
            this.setToolTipText("<html><table width=\"400\"><tr><td>" + magnet.toString() + "</td></tr></table></html>");
            return this;
        }
    }
}

