/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.BrowseHostHandler;
import com.limegroup.gnutella.FileDetails;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.FileDetailsProvider;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.IconButton;
import com.limegroup.gnutella.gui.LicenseWindow;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.ProgTabUIFactory;
import com.limegroup.gnutella.gui.search.CompositeFilter;
import com.limegroup.gnutella.gui.search.DateRenderer;
import com.limegroup.gnutella.gui.search.EndpointHolder;
import com.limegroup.gnutella.gui.search.EndpointRenderer;
import com.limegroup.gnutella.gui.search.MetadataModel;
import com.limegroup.gnutella.gui.search.PercentageRenderer;
import com.limegroup.gnutella.gui.search.QualityHolder;
import com.limegroup.gnutella.gui.search.QualityRenderer;
import com.limegroup.gnutella.gui.search.ResultPanelModel;
import com.limegroup.gnutella.gui.search.ResultSpeed;
import com.limegroup.gnutella.gui.search.ResultSpeedRenderer;
import com.limegroup.gnutella.gui.search.SearchButtons;
import com.limegroup.gnutella.gui.search.SearchColumnPreferenceHandler;
import com.limegroup.gnutella.gui.search.SearchColumnSelectionMenu;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResultMenu;
import com.limegroup.gnutella.gui.search.SearchTableColumns;
import com.limegroup.gnutella.gui.search.SpamFilter;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.TableLineFilter;
import com.limegroup.gnutella.gui.search.TableRowFilter;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.ColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.VerificationListener;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.OverlayLayout;

public class ResultPanel
extends AbstractTableMediator
implements VerificationListener,
FileDetailsProvider {
    static final GUID STOPPED_GUID = new GUID(GUID.makeGuid());
    private static final DateRenderer DATE_RENDERER = new DateRenderer();
    private static final QualityRenderer QUALITY_RENDERER = new QualityRenderer();
    private static final EndpointRenderer ENDPOINT_RENDERER = new EndpointRenderer();
    private static final ResultSpeedRenderer RESULT_SPEED_RENDERER = new ResultSpeedRenderer();
    private static final PercentageRenderer PERCENTAGE_RENDERER = new PercentageRenderer();
    static final TableSettings SEARCH_SETTINGS = new TableSettings("SEARCH_TABLE");
    private final SearchInformation SEARCH_INFO;
    private final SpamFilter SPAM_FILTER;
    private volatile GUID guid;
    private long timeLastResultReceived;
    private BrowseHostHandler browseHandler = null;
    private long startTime = System.currentTimeMillis();
    private CompositeFilter FILTER;
    ActionListener DOWNLOAD_LISTENER;
    ActionListener DOWNLOAD_AS_LISTENER;
    ActionListener CHAT_LISTENER;
    ActionListener BROWSE_HOST_LISTENER;
    ActionListener STOP_LISTENER;
    ActionListener MARK_AS_SPAM_LISTENER;
    ActionListener MARK_AS_NOT_SPAM_LISTENER;
    private JButton SPAM_BUTTON;

    ResultPanel(JPanel overlay) {
        super("SEARCH_TABLE");
        this.setupFakeTable(overlay);
        this.SEARCH_INFO = SearchInformation.createKeywordSearch("", null, MediaType.getAnyTypeMediaType());
        this.SPAM_FILTER = null;
        this.FILTER = null;
        this.guid = STOPPED_GUID;
        this.setButtonEnabled(2, false);
    }

    ResultPanel(GUID guid, SearchInformation info) {
        super("SEARCH_TABLE");
        this.SEARCH_INFO = info;
        this.SPAM_FILTER = this.SEARCH_INFO.isBrowseHostSearch() || this.SEARCH_INFO.isWhatsNewSearch() ? null : new SpamFilter();
        this.guid = guid;
        this.setupRealTable();
        this.resetFilters();
    }

    protected void setDefaultRenderers() {
        super.setDefaultRenderers();
        this.TABLE.setDefaultRenderer(QualityHolder.class, QUALITY_RENDERER);
        this.TABLE.setDefaultRenderer(EndpointHolder.class, ENDPOINT_RENDERER);
        this.TABLE.setDefaultRenderer(ResultSpeed.class, RESULT_SPEED_RENDERER);
        this.TABLE.setDefaultRenderer(Date.class, DATE_RENDERER);
        this.TABLE.setDefaultRenderer(Float.class, PERCENTAGE_RENDERER);
    }

    protected void updateSplashScreen() {
    }

    protected void setupConstants() {
        this.FILTER = new CompositeFilter(4);
        this.MAIN_PANEL = new PPP();
        this.DATA_MODEL = new TableRowFilter(this.FILTER);
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        ((ResultPanelModel)this.DATA_MODEL).setTable(this.TABLE);
        this.BUTTON_ROW = new SearchButtons(this).getComponent();
        this.SPAM_BUTTON = new IconButton(GUIMediator.getStringResource("SEARCH_NOT_SPAM_BUTTON_LABEL"), "SEARCH_SPAM");
        this.transformSpamButton(GUIMediator.getStringResource("SEARCH_SPAM_BUTTON_LABEL"), GUIMediator.getStringResource("SEARCH_SPAM_BUTTON_TIP"));
        this.SPAM_BUTTON.setEnabled(false);
        this.SPAM_BUTTON.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableLine[] lines = ResultPanel.this.getAllSelectedLines();
                if (lines.length > 0) {
                    if (SpamFilter.isAboveSpamThreshold(lines[0])) {
                        ResultPanel.this.MARK_AS_NOT_SPAM_LISTENER.actionPerformed(e);
                    } else {
                        ResultPanel.this.MARK_AS_SPAM_LISTENER.actionPerformed(e);
                    }
                }
            }
        });
    }

    protected void buildSettings() {
        this.SETTINGS = SEARCH_SETTINGS;
    }

    protected JPopupMenu createColumnSelectionMenu() {
        return new SearchColumnSelectionMenu(this.TABLE).getComponent();
    }

    protected ColumnPreferenceHandler createDefaultColumnPreferencesHandler() {
        return new SearchColumnPreferenceHandler(this.TABLE);
    }

    protected void buildListeners() {
        super.buildListeners();
        this.DOWNLOAD_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchMediator.doDownload(ResultPanel.this);
            }
        };
        this.DOWNLOAD_AS_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchMediator.doDownloadAs(ResultPanel.this);
            }
        };
        this.CHAT_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResultPanel.this.doChat();
            }
        };
        this.BROWSE_HOST_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchMediator.doBrowseHost(ResultPanel.this);
            }
        };
        this.STOP_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResultPanel.this.stopSearch();
            }
        };
        this.MARK_AS_SPAM_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableLine[] lines = ResultPanel.this.getAllSelectedLines();
                for (int i = 0; i < lines.length; ++i) {
                    ResultPanel.this.SPAM_FILTER.markAsSpamUser(lines[i], true);
                }
                if (SearchSettings.hideJunk()) {
                    ResultPanel.this.filtersChanged();
                } else {
                    ResultPanel.this.DATA_MODEL.refresh();
                    ResultPanel.this.transformSpamButton(GUIMediator.getStringResource("SEARCH_NOT_SPAM_BUTTON_LABEL"), GUIMediator.getStringResource("SEARCH_NOT_SPAM_BUTTON_TIP"));
                }
            }
        };
        this.MARK_AS_NOT_SPAM_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableLine[] lines = ResultPanel.this.getAllSelectedLines();
                for (int i = 0; i < lines.length; ++i) {
                    ResultPanel.this.SPAM_FILTER.markAsSpamUser(lines[i], false);
                }
                ResultPanel.this.DATA_MODEL.refresh();
                ResultPanel.this.transformSpamButton(GUIMediator.getStringResource("SEARCH_SPAM_BUTTON_LABEL"), GUIMediator.getStringResource("SEARCH_SPAM_BUTTON_TIP"));
            }
        };
    }

    public JPopupMenu createPopupMenu() {
        if (!this.isKillable()) {
            return null;
        }
        TableLine[] lines = this.getAllSelectedLines();
        boolean allSpam = true;
        boolean allNot = true;
        if (this.SPAM_FILTER != null) {
            for (int i = 0; i < lines.length; ++i) {
                if (!SpamFilter.isAboveSpamThreshold(lines[i])) {
                    allSpam = false;
                    continue;
                }
                allNot = false;
            }
        }
        return new SearchResultMenu(this).createMenu(lines, !allSpam, !allNot);
    }

    public void add(Object o) {
        super.add(o);
        this.timeLastResultReceived = System.currentTimeMillis();
    }

    public void removeSelection() {
    }

    public void clearTable() {
        super.clearTable();
    }

    public void handleNoSelection() {
        this.setButtonEnabled(0, false);
        this.setButtonEnabled(1, false);
        this.SPAM_BUTTON.setEnabled(false);
        if (SearchSettings.ENABLE_SPAM_FILTER.getValue() && this.SPAM_FILTER != null) {
            this.transformSpamButton(GUIMediator.getStringResource("SEARCH_SPAM_BUTTON_LABEL"), GUIMediator.getStringResource("SEARCH_SPAM_BUTTON_TIP"));
        }
    }

    public void handleSelection(int i) {
        this.setButtonEnabled(0, true);
        TableLine line = (TableLine)this.DATA_MODEL.get(i);
        this.setButtonEnabled(1, line.isBrowseHostEnabled());
        if (SearchSettings.ENABLE_SPAM_FILTER.getValue() && this.SPAM_FILTER != null) {
            this.SPAM_BUTTON.setEnabled(true);
            if (SpamFilter.isAboveSpamThreshold(line)) {
                this.transformSpamButton(GUIMediator.getStringResource("SEARCH_NOT_SPAM_BUTTON_LABEL"), GUIMediator.getStringResource("SEARCH_NOT_SPAM_BUTTON_TIP"));
            } else {
                this.transformSpamButton(GUIMediator.getStringResource("SEARCH_SPAM_BUTTON_LABEL"), GUIMediator.getStringResource("SEARCH_SPAM_BUTTON_TIP"));
            }
        }
    }

    public void handleActionKey() {
        this.DOWNLOAD_LISTENER.actionPerformed(null);
    }

    SearchInformation getSearchInformation() {
        return this.SEARCH_INFO;
    }

    String getQuery() {
        return this.SEARCH_INFO.getQuery();
    }

    String getTitle() {
        return this.SEARCH_INFO.getTitle();
    }

    String getRichQuery() {
        return this.SEARCH_INFO.getXML();
    }

    void stopSearch() {
        final GUID guidToStop = this.guid;
        GUIMediator.instance().schedule(new Runnable(){

            public void run() {
                RouterService.stopQuery(guidToStop);
            }
        });
        this.setGUID(STOPPED_GUID);
        SearchMediator.checkToStopLime();
        this.setButtonEnabled(2, false);
    }

    void doChat() {
        TableLine line = this.getSelectedLine();
        if (line == null) {
            return;
        }
        if (!line.isChatEnabled()) {
            return;
        }
        line.doChat();
    }

    void blockHost() {
        TableLine line = this.getSelectedLine();
        if (line == null) {
            return;
        }
        String host = line.getHostname();
        int answer = GUIMediator.showYesNoMessage("SEARCH_BLOCK_HOST", " " + host + "?");
        if (answer == 101 && host != null) {
            String[] bannedIps = FilterSettings.BLACK_LISTED_IP_ADDRESSES.getValue();
            for (int i = 0; i < bannedIps.length; ++i) {
                if (!host.equalsIgnoreCase(bannedIps[i])) continue;
                return;
            }
            String[] newBannedIps = new String[bannedIps.length + 1];
            System.arraycopy(bannedIps, 0, newBannedIps, 0, bannedIps.length);
            newBannedIps[bannedIps.length] = host;
            FilterSettings.BLACK_LISTED_IP_ADDRESSES.setValue(newBannedIps);
            RouterService.adjustSpamFilters();
        }
    }

    void showLicense() {
        TableLine line = this.getSelectedLine();
        if (line == null) {
            return;
        }
        URN urn = line.getSHA1Urn();
        LimeXMLDocument doc = line.getXMLDocument();
        LicenseWindow window = LicenseWindow.create(line.getLicense(), urn, doc, this);
        window.setVisible(true);
    }

    public void licenseVerified(License license) {
        if (license.isValid(null)) {
            ((ResultPanelModel)this.DATA_MODEL).slowRefresh();
        }
    }

    boolean isStopped() {
        return this.guid.equals(STOPPED_GUID);
    }

    boolean isEmpty() {
        return this.DATA_MODEL.getRowCount() == 0;
    }

    boolean isKillable() {
        return this.FILTER != null;
    }

    boolean filterChanged(TableLineFilter filter, int depth) {
        int i;
        if (!this.FILTER.setFilter(depth, filter)) {
            return false;
        }
        int[] rows = this.TABLE.getSelectedRows();
        DataLine[] lines = new DataLine[rows.length];
        LinkedList<DataLine> inView = new LinkedList<DataLine>();
        for (i = 0; i < rows.length; ++i) {
            DataLine line;
            int row = rows[i];
            lines[i] = line = this.DATA_MODEL.get(row);
            if (!this.TABLE.isRowVisible(row)) continue;
            inView.add(line);
        }
        ((TableRowFilter)this.DATA_MODEL).filtersChanged();
        for (i = 0; i < rows.length; ++i) {
            DataLine line = lines[i];
            int row = this.DATA_MODEL.getRow(line);
            if (row == -1) continue;
            this.TABLE.addRowSelectionInterval(row, row);
            if (inView == null || !inView.contains(line)) continue;
            this.TABLE.ensureRowVisible(row);
            inView = null;
        }
        SearchMediator.setTabDisplayCount(this);
        return true;
    }

    int totalSources() {
        return ((ResultPanelModel)this.DATA_MODEL).getTotalSources();
    }

    int filteredSources() {
        return ((TableRowFilter)this.DATA_MODEL).getFilteredSources();
    }

    boolean isRepeatSearchEnabled() {
        return this.FILTER != null;
    }

    void repeatSearch() {
        this.repeatSearch(true);
    }

    void repeatSearch(boolean clearTable) {
        if (clearTable) {
            this.clearTable();
            this.resetFilters();
        }
        this.startTime = System.currentTimeMillis();
        SearchMediator.setTabDisplayCount(this);
        SearchMediator.repeatSearch(this, this.SEARCH_INFO, clearTable);
        this.setButtonEnabled(2, true);
    }

    void resetFilters() {
        this.FILTER.reset();
        if (!this.SEARCH_INFO.isBrowseHostSearch() && !this.SEARCH_INFO.isWhatsNewSearch()) {
            ((TableRowFilter)this.DATA_MODEL).setJunkFilter(this.SPAM_FILTER);
        } else {
            ((TableRowFilter)this.DATA_MODEL).setJunkFilter(null);
        }
    }

    private void filtersChanged() {
        ((TableRowFilter)this.DATA_MODEL).filtersChanged();
        SearchMediator.setTabDisplayCount(this);
    }

    MetadataModel getMetadataModel() {
        return ((ResultPanelModel)this.DATA_MODEL).getMetadataModel();
    }

    boolean matches(GUID otherGuid) {
        return this.guid.equals(otherGuid);
    }

    void setGUID(GUID guid) {
        this.guid = guid;
    }

    byte[] getGUID() {
        return this.guid.bytes();
    }

    MediaType getMediaType() {
        return this.SEARCH_INFO.getMediaType();
    }

    void setBrowseHostHandler(BrowseHostHandler bhh) {
        this.browseHandler = bhh;
    }

    TableLine[] getAllSelectedLines() {
        int[] rows = this.TABLE.getSelectedRows();
        if (rows == null) {
            return new TableLine[0];
        }
        TableLine[] lines = new TableLine[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            lines[i] = (TableLine)this.DATA_MODEL.get(rows[i]);
        }
        return lines;
    }

    TableLine getSelectedLine() {
        int selected = this.TABLE.getSelectedRow();
        if (selected != -1) {
            return (TableLine)this.DATA_MODEL.get(selected);
        }
        return null;
    }

    double calculatePercentage(long currentTime) {
        if (this.guid.equals(STOPPED_GUID)) {
            return 1.0;
        }
        if (this.SEARCH_INFO.isBrowseHostSearch()) {
            if (this.browseHandler != null) {
                return this.browseHandler.getPercentComplete(currentTime);
            }
            return 0.0;
        }
        int ideal = 150;
        double resultPerc = (double)this.totalSources() / (double)ideal;
        long spent = currentTime - this.startTime;
        double timePerc = (double)spent / 200000.0;
        if (resultPerc >= 1.0) {
            return 1.0;
        }
        return resultPerc + (timePerc *= 1.0 - resultPerc);
    }

    private void setupRealTable() {
        SearchTableColumns columns = ((ResultPanelModel)this.DATA_MODEL).getColumns();
        LimeTableColumn countColumn = columns.getColumn(1);
        if (this.SETTINGS.REAL_TIME_SORT.getValue() && this.TABLE.isColumnVisible(countColumn.getId())) {
            this.DATA_MODEL.sort(1);
            this.DATA_MODEL.sort(1);
        }
        MouseListener filterDisplayer = new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                e.consume();
                SearchMediator.panelSelected(ResultPanel.this);
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        };
        this.MAIN_PANEL.addMouseListener(filterDisplayer);
        this.SCROLL_PANE.addMouseListener(filterDisplayer);
        this.TABLE.addMouseListener(filterDisplayer);
        this.TABLE.getTableHeader().addMouseListener(filterDisplayer);
    }

    protected void setupMainPanel() {
        if (SearchSettings.ENABLE_SPAM_FILTER.getValue() && this.MAIN_PANEL != null) {
            this.MAIN_PANEL.add(this.getScrolledTablePane());
            this.addButtonRow();
            this.MAIN_PANEL.setMinimumSize(ZERO_DIMENSION);
        } else {
            super.setupMainPanel();
        }
    }

    private void setupFakeTable(JPanel overlay) {
        this.MAIN_PANEL.removeAll();
        JPanel background = new JPanel();
        background.setLayout(new OverlayLayout(background));
        BoxPanel overlayPanel = new BoxPanel(1);
        overlayPanel.setOpaque(false);
        overlayPanel.add(Box.createVerticalStrut(20));
        overlayPanel.add(overlay);
        overlayPanel.setMinimumSize(new Dimension(0, 0));
        JComponent table = this.getScrolledTablePane();
        table.setOpaque(false);
        background.add(overlayPanel);
        background.add(table);
        this.MAIN_PANEL.add(background);
        this.addButtonRow();
        this.MAIN_PANEL.setMinimumSize(ZERO_DIMENSION);
    }

    private void addButtonRow() {
        if (this.BUTTON_ROW != null) {
            this.MAIN_PANEL.add(Box.createVerticalStrut(6));
            if (SearchSettings.ENABLE_SPAM_FILTER.getValue() && this.SPAM_BUTTON != null) {
                JPanel buttonPanel = new JPanel();
                buttonPanel.setOpaque(false);
                buttonPanel.setLayout(new GridBagLayout());
                GridBagConstraints gbc = null;
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.anchor = 10;
                gbc.fill = 0;
                gbc.gridwidth = -1;
                gbc.weightx = 1.0;
                buttonPanel.add((Component)this.BUTTON_ROW, gbc);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 0;
                gbc.anchor = 13;
                gbc.fill = 0;
                gbc.gridwidth = 0;
                buttonPanel.add((Component)this.SPAM_BUTTON, gbc);
                buttonPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 64));
                this.MAIN_PANEL.add(buttonPanel);
            } else {
                this.MAIN_PANEL.add(this.BUTTON_ROW);
            }
        }
    }

    public FileDetails[] getFileDetails() {
        int[] sel = this.TABLE.getSelectedRows();
        ArrayList<RemoteFileDesc> list = new ArrayList<RemoteFileDesc>(sel.length);
        for (int i = 0; i < sel.length; ++i) {
            TableLine line = (TableLine)this.DATA_MODEL.get(sel[i]);
            RemoteFileDesc rfd = line.getNonFirewalledRFD();
            if (rfd != null) {
                list.add(rfd);
                continue;
            }
            rfd = line.getRemoteFileDesc();
            if (rfd == null) continue;
            list.add(rfd);
        }
        if (list.isEmpty()) {
            return new FileDetails[0];
        }
        return list.toArray(new FileDetails[0]);
    }

    private void transformSpamButton(String text, String tip) {
        Dimension oldDim = this.SPAM_BUTTON.getPreferredSize();
        this.SPAM_BUTTON.setText(text);
        this.SPAM_BUTTON.setToolTipText(tip);
        Dimension newDim = this.SPAM_BUTTON.getPreferredSize();
        newDim.width = Math.max(oldDim.width, newDim.width);
        this.SPAM_BUTTON.setPreferredSize(newDim);
    }

    private class PPP
    extends PaddedPanel
    implements ProgTabUIFactory.Progressor {
        private PPP() {
        }

        public double calculatePercentage(long now) {
            return ResultPanel.this.calculatePercentage(now);
        }
    }
}

