/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.search.MetadataModel;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.search.SearchTableColumns;
import com.limegroup.gnutella.gui.search.SpamFilter;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.TableLineGrouper;
import com.limegroup.gnutella.gui.tables.BasicDataLineModel;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.settings.UISettings;
import java.util.HashMap;

class ResultPanelModel
extends BasicDataLineModel {
    protected final MetadataModel METADATA;
    private LimeJTable TABLE;
    protected final SearchTableColumns COLUMNS = new SearchTableColumns();
    protected boolean _useMetadata = true;
    private final HashMap _indexes = new HashMap();
    private TableLineGrouper _grouper;
    private int _numSources;

    ResultPanelModel() {
        this(new MetadataModel());
    }

    ResultPanelModel(MetadataModel mm) {
        super(TableLine.class);
        this.METADATA = mm;
    }

    void setUseMetadata(boolean use) {
        this._useMetadata = use;
    }

    void setTable(LimeJTable table) {
        this.TABLE = table;
    }

    SearchTableColumns getColumns() {
        return this.COLUMNS;
    }

    public DataLine createDataLine() {
        return new TableLine(this.COLUMNS);
    }

    public LimeTableColumn getTableColumn(int idx) {
        return this.COLUMNS.getColumn(idx);
    }

    public int compare(Object a, Object b) {
        TableLine ta = (TableLine)a;
        TableLine tb = (TableLine)b;
        int spamRet = this.compareSpam(ta, tb);
        if (spamRet != 0) {
            return spamRet;
        }
        if (!this.isSorted() || this._activeColumn != 1) {
            return super.compare(ta, tb);
        }
        return this.compareCount(ta, tb, false);
    }

    MetadataModel getMetadataModel() {
        return this.METADATA;
    }

    public void remove(int row) {
        TableLine tl = (TableLine)this.get(row);
        URN sha1 = this.getSHA1(row);
        if (sha1 != null) {
            this._indexes.remove(sha1);
        }
        super.remove(row);
        this._numSources -= tl.getLocationCount();
        this.remapIndexes(row);
    }

    public int add(Object o) {
        return this.add(o, this.getRowCount());
    }

    public int add(DataLine dl) {
        return super.add(dl);
    }

    public Object refresh() {
        this.fireTableRowsUpdated(0, this.getRowCount());
        return null;
    }

    public void slowRefresh() {
        super.refresh();
    }

    public DataLine getNewDataLine(Object o) {
        SearchResult sr = (SearchResult)o;
        URN sha1 = sr.getRemoteFileDesc().getSHA1Urn();
        int idx = -1;
        if (UISettings.UI_GROUP_RESULTS.getValue()) {
            idx = sha1 == null ? this.slowMatch(sr) : this.fastMatch(sha1);
        }
        if (idx != -1) {
            TableLine line = (TableLine)this.get(idx);
            int added = this.addNewResult(line, sr);
            if (added != 0 && this.isSorted() && this.TABLE.getTableSettings().REAL_TIME_SORT.getValue() && this.getSortColumn() == 1) {
                this.move(line, idx);
            } else if (added != 0) {
                this.fireTableRowsUpdated(idx, idx);
            }
            return null;
        }
        return super.getNewDataLine(o);
    }

    protected int addNewResult(TableLine line, SearchResult sr) {
        int oldCount = line.getLocationCount();
        line.addNewResult(sr, this.METADATA);
        int newCount = line.getLocationCount();
        int added = newCount - oldCount;
        this._numSources += added;
        return added;
    }

    public int add(DataLine dl, int row) {
        TableLine tl = (TableLine)dl;
        this._numSources += tl.getLocationCount();
        URN sha1 = tl.getSHA1Urn();
        if (sha1 != null) {
            this._indexes.put(sha1, new Integer(row));
        }
        int addedAt = super.add(dl, row);
        this.remapIndexes(addedAt + 1);
        if (this._useMetadata) {
            this.METADATA.addNew(tl);
        }
        return addedAt;
    }

    public int getRow(DataLine dl) {
        TableLine tl = (TableLine)dl;
        URN sha1 = tl.getSHA1Urn();
        if (sha1 != null) {
            return this.fastMatch(sha1);
        }
        return super.getRow(dl);
    }

    public int getRow(Object o) {
        SearchResult sr = (SearchResult)o;
        URN sha1 = sr.getRemoteFileDesc().getSHA1Urn();
        if (sha1 != null) {
            return this.fastMatch(sha1);
        }
        return super.getRow(o);
    }

    int getTotalSources() {
        return this._numSources;
    }

    protected void doResort() {
        super.doResort();
        this._indexes.clear();
        this.remapIndexes(0);
    }

    public void clear() {
        if (this.METADATA != null) {
            this.METADATA.clear();
        }
        if (this._grouper != null) {
            this._grouper.clear();
        }
        this.simpleClear();
    }

    protected void cleanup() {
    }

    protected void simpleClear() {
        this._numSources = 0;
        this._indexes.clear();
        super.clear();
    }

    private void move(TableLine dl, int oldIdx) {
        TableLine current;
        int newIdx;
        if (!this.isSortAscending()) {
            if (oldIdx == 0) {
                this.fireTableRowsUpdated(0, 0);
                return;
            }
            int i = 0;
            while (newIdx > 0 && this.compareCount(dl, current = (TableLine)this.get(newIdx - 1), true) < 0) {
                --newIdx;
                ++i;
            }
        } else {
            int end = this.getRowCount() - 1;
            if (oldIdx == end) {
                this.fireTableRowsUpdated(end, end);
                return;
            }
            for (newIdx = oldIdx; newIdx < end && this.compareCount(dl, current = (TableLine)this.get(newIdx + 1), true) < 0; ++newIdx) {
            }
        }
        if (oldIdx == newIdx) {
            this.fireTableRowsUpdated(newIdx, newIdx);
            return;
        }
        boolean selected = this.TABLE.isRowSelected(oldIdx);
        boolean inView = this.TABLE.isSelectionVisible();
        super.remove(oldIdx);
        super.add(dl, newIdx);
        if (selected) {
            this.TABLE.clearSelection();
            this.TABLE.addRowSelectionInterval(newIdx, newIdx);
            if (inView) {
                this.TABLE.ensureSelectionVisible();
            }
        } else {
            this.TABLE.removeRowSelectionInterval(newIdx, newIdx);
            int selRow = this.TABLE.getSelectedRow();
            if (selRow != -1) {
                this.TABLE.addRowSelectionInterval(selRow, selRow);
                if (inView) {
                    this.TABLE.ensureSelectionVisible();
                }
            }
        }
        if (oldIdx < newIdx) {
            this.remapIndexes(oldIdx, newIdx + 1);
        } else {
            this.remapIndexes(newIdx, oldIdx + 1);
        }
    }

    private void remapIndexes(int start) {
        this.remapIndexes(start, this.getRowCount());
    }

    private void remapIndexes(int start, int end) {
        for (int i = start; i < end; ++i) {
            URN sha1 = this.getSHA1(i);
            if (sha1 == null) continue;
            this._indexes.put(sha1, new Integer(i));
        }
    }

    private URN getSHA1(int idx) {
        if (idx >= this.getRowCount()) {
            return null;
        }
        return ((TableLine)this.get(idx)).getSHA1Urn();
    }

    private int compareSpam(TableLine a, TableLine b) {
        if (SearchSettings.moveJunkToBottom()) {
            if (SpamFilter.isAboveSpamThreshold(a)) {
                if (!SpamFilter.isAboveSpamThreshold(b)) {
                    return 1;
                }
            } else if (SpamFilter.isAboveSpamThreshold(b)) {
                return -1;
            }
        }
        return 0;
    }

    private int compareCount(TableLine a, TableLine b, boolean spamCompare) {
        int spamRet;
        if (spamCompare && (spamRet = this.compareSpam(a, b)) != 0) {
            return spamRet;
        }
        int c1 = this.normalizeLocationCount(a.getLocationCount(), a.getQuality());
        int c2 = this.normalizeLocationCount(b.getLocationCount(), b.getQuality());
        return (c1 - c2) * this._ascending;
    }

    private int normalizeLocationCount(int count, int quality) {
        switch (quality) {
            case 999: {
                return Integer.MAX_VALUE;
            }
            case 4: {
                return 0x7FFFFFFE;
            }
        }
        return count;
    }

    private int slowMatch(SearchResult sr) {
        SearchResult group;
        if (this._grouper == null) {
            this._grouper = new TableLineGrouper();
        }
        if ((group = this._grouper.match(sr)) == null) {
            this._grouper.add(sr);
        }
        return super.getRow(group);
    }

    private int fastMatch(URN sha1) {
        Integer idx = (Integer)this._indexes.get(sha1);
        if (idx == null) {
            return -1;
        }
        return idx;
    }
}

