/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.ResultSpeed;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class ResultSpeedRenderer
extends DefaultTableCellRenderer
implements ThemeObserver {
    public static Color _measuredColor;
    public static Color _unmeasuredColor;

    ResultSpeedRenderer() {
        this.updateTheme();
        ThemeMediator.addThemeObserver(this);
    }

    public void updateTheme() {
        _measuredColor = ThemeFileHandler.SEARCH_RESULT_SPEED_COLOR.getValue();
        _unmeasuredColor = ThemeFileHandler.WINDOW8_COLOR.getValue();
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSel, boolean hasFocus, int row, int column) {
        ResultSpeed speed = (ResultSpeed)value;
        String tag = speed == null ? "" : speed.stringValue();
        Component ret = super.getTableCellRendererComponent(table, tag, isSel, hasFocus, row, column);
        if (speed != null && speed.isMeasured()) {
            ret.setForeground(_measuredColor);
        } else {
            ret.setForeground(_unmeasuredColor);
        }
        return ret;
    }
}

