/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.actions.ActionUtils;
import com.limegroup.gnutella.gui.actions.BitziLookupAction;
import com.limegroup.gnutella.gui.actions.CopyMagnetLinkToClipboardAction;
import com.limegroup.gnutella.gui.actions.SearchAction;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

final class SearchResultMenu {
    final ResultPanel PANEL;

    SearchResultMenu(ResultPanel rp) {
        this.PANEL = rp;
    }

    private static void add(String s, ActionListener l, JPopupMenu m, boolean enable) {
        JMenuItem item = new JMenuItem(s);
        item.addActionListener(l);
        item.setEnabled(enable);
        m.add(item);
    }

    private static void add(String s, ActionListener l, JMenu m, boolean enable) {
        JMenuItem item = new JMenuItem(s);
        item.addActionListener(l);
        item.setEnabled(enable);
        m.add(item);
    }

    JPopupMenu createMenu(TableLine[] lines, boolean markAsSpam, boolean markAsNot) {
        JPopupMenu menu = new JPopupMenu();
        SearchResultMenu.add(SearchMediator.DOWNLOAD_STRING, this.PANEL.DOWNLOAD_LISTENER, menu, lines.length > 0);
        SearchResultMenu.add(GUIMediator.getStringResource("SEARCH_DOWNLOAD_AS_LABEL"), this.PANEL.DOWNLOAD_AS_LISTENER, menu, lines.length == 1);
        SearchResultMenu.add(GUIMediator.getStringResource("LICENSE_VIEW_LICENSE"), (ActionListener)new LicenseListener(), menu, lines.length > 0 && lines[0].isLicenseAvailable());
        SearchResultMenu.add(SearchMediator.CHAT_STRING, this.PANEL.CHAT_LISTENER, menu, lines.length > 0 && lines[0].isChatEnabled());
        SearchResultMenu.add(SearchMediator.BROWSE_HOST_STRING, this.PANEL.BROWSE_HOST_LISTENER, menu, lines.length > 0 && lines[0].isBrowseHostEnabled());
        SearchResultMenu.add(SearchMediator.BLOCK_STRING, (ActionListener)new BlockListener(), menu, lines.length > 0);
        JMenu spamMenu = new JMenu(SearchMediator.MARK_AS_STRING);
        spamMenu.setEnabled(markAsSpam || markAsNot);
        SearchResultMenu.add(SearchMediator.SPAM_STRING, this.PANEL.MARK_AS_SPAM_LISTENER, spamMenu, markAsSpam);
        SearchResultMenu.add(SearchMediator.NOT_SPAM_STRING, this.PANEL.MARK_AS_NOT_SPAM_LISTENER, spamMenu, markAsNot);
        menu.add(SearchMediator.MARK_AS_STRING, spamMenu);
        menu.addSeparator();
        TableLine line = lines.length > 0 ? lines[0] : null;
        menu.add(this.createSearchAgainMenu(line));
        menu.add(this.createAdvancedMenu(line));
        menu.addSeparator();
        SearchResultMenu.add(SearchMediator.STOP_STRING, this.PANEL.STOP_LISTENER, menu, !this.PANEL.isStopped());
        SearchResultMenu.add(SearchMediator.KILL_STRING, (ActionListener)new CancelListener(), menu, this.PANEL.isKillable());
        return menu;
    }

    private JMenu createSearchAgainMenu(TableLine line) {
        LimeXMLDocument doc;
        JMenu menu = new JMenu(GUIMediator.getStringResource("SEARCH_RESULT_MENU_SEARCH_MORE_LABEL"));
        menu.add(new JMenuItem(new RepeatSearchAction()));
        menu.add(new JMenuItem(new RepeatSearchNoClearAction()));
        if (line == null) {
            menu.setEnabled(this.PANEL.isRepeatSearchEnabled());
            return menu;
        }
        menu.addSeparator();
        String keywords = StringUtils.createQueryString(line.getFilename());
        SearchInformation info = SearchInformation.createKeywordSearch(keywords, null, MediaType.getAnyTypeMediaType());
        if (SearchMediator.validateInfo(info) == 0) {
            menu.add(new JMenuItem(new SearchAction(info, "SEARCH_FOR_KEYWORDS_ACTION_NAME")));
        }
        if ((doc = line.getXMLDocument()) != null) {
            Action[] actions = ActionUtils.createSearchActions(doc);
            for (int i = 0; i < actions.length; ++i) {
                menu.add(new JMenuItem(actions[i]));
            }
        }
        return menu;
    }

    private JMenu createAdvancedMenu(TableLine line) {
        JMenu menu = new JMenu(GUIMediator.getStringResource("GENERAL_ADVANCED_SUB_MENU"));
        if (line == null) {
            menu.setEnabled(false);
            return menu;
        }
        BitziLookupAction bitziAction = new BitziLookupAction(this.PANEL);
        bitziAction.setEnabled(line.getRemoteFileDesc().getSHA1Urn() != null);
        menu.add(new JMenuItem(bitziAction));
        CopyMagnetLinkToClipboardAction magnet = new CopyMagnetLinkToClipboardAction(this.PANEL);
        magnet.setEnabled(line.hasNonFirewalledRFD());
        menu.add(new JMenuItem(magnet));
        if (line.isLaunchable()) {
            menu.addSeparator();
            SearchResultMenu.add(SearchMediator.LAUNCH_STRING, this.PANEL.DOWNLOAD_LISTENER, menu.getPopupMenu(), true);
        }
        return menu;
    }

    private class RepeatSearchNoClearAction
    extends AbstractAction {
        public RepeatSearchNoClearAction() {
            this.putValue("Name", SearchMediator.REPEAT_SEARCH_NO_CLEAR_STRING);
            this.setEnabled(SearchResultMenu.this.PANEL.isRepeatSearchEnabled());
        }

        public void actionPerformed(ActionEvent e) {
            SearchResultMenu.this.PANEL.repeatSearch(false);
        }
    }

    private class RepeatSearchAction
    extends AbstractAction {
        public RepeatSearchAction() {
            this.putValue("Name", SearchMediator.REPEAT_SEARCH_STRING);
            this.setEnabled(SearchResultMenu.this.PANEL.isRepeatSearchEnabled());
        }

        public void actionPerformed(ActionEvent e) {
            SearchResultMenu.this.PANEL.repeatSearch(true);
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SearchMediator.killSearch();
        }
    }

    private class BlockListener
    implements ActionListener {
        private BlockListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SearchResultMenu.this.PANEL.blockHost();
        }
    }

    private class LicenseListener
    implements ActionListener {
        private LicenseListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SearchResultMenu.this.PANEL.showLicense();
        }
    }
}

