/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.EndpointHolder;
import com.limegroup.gnutella.gui.search.QualityHolder;
import com.limegroup.gnutella.gui.search.ResultNameHolder;
import com.limegroup.gnutella.gui.search.SearchColumn;
import com.limegroup.gnutella.gui.search.XMLSearchColumn;
import com.limegroup.gnutella.gui.tables.ChatHolder;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;

final class SearchTableColumns {
    static final int QUALITY_IDX = 0;
    private final LimeTableColumn QUALITY_COLUMN = new SearchColumn(0, "RESULT_PANEL_QUALITY", 55, true, QualityHolder.class);
    static final int COUNT_IDX = 1;
    private final LimeTableColumn COUNT_COLUMN = new SearchColumn(1, "RESULT_PANEL_COUNT", 24, true, Integer.class);
    static final int LICENSE_IDX = 2;
    private final LimeTableColumn LICENSE_COLUMN = new SearchColumn(2, "RESULT_PANEL_LICENSE", 40, true, License.class);
    static final int ICON_IDX = 3;
    private final LimeTableColumn ICON_COLUMN = new SearchColumn(3, "RESULT_PANEL_ICON", GUIMediator.getThemeImage("question_mark"), 18, true, Icon.class);
    static final int NAME_IDX = 4;
    private final LimeTableColumn NAME_COLUMN = new SearchColumn(4, "RESULT_PANEL_NAME", 272, true, ResultNameHolder.class);
    static final int TYPE_IDX = 5;
    private final LimeTableColumn TYPE_COLUMN = new SearchColumn(5, "RESULT_PANEL_TYPE", 42, true, String.class);
    static final int SIZE_IDX = 6;
    private final LimeTableColumn SIZE_COLUMN = new SearchColumn(6, "RESULT_PANEL_SIZE", 53, true, String.class);
    static final int SPEED_IDX = 7;
    private final LimeTableColumn SPEED_COLUMN = new SearchColumn(7, "RESULT_PANEL_SPEED", 61, true, String.class);
    static final int CHAT_IDX = 8;
    private final LimeTableColumn CHAT_COLUMN = new SearchColumn(8, "RESULT_PANEL_CHAT", 40, false, ChatHolder.class);
    static final int LOCATION_IDX = 9;
    private final LimeTableColumn LOCATION_COLUMN = new SearchColumn(9, "RESULT_PANEL_LOCATION", 86, false, EndpointHolder.class);
    static final int VENDOR_IDX = 10;
    private final LimeTableColumn VENDOR_COLUMN = new SearchColumn(10, "RESULT_PANEL_VENDOR", 55, false, String.class);
    static final int ADDED_IDX = 11;
    private final LimeTableColumn ADDED_COLUMN = new SearchColumn(11, "RESULT_PANEL_ADDED", 55, false, Date.class);
    static final int SPAM_IDX = 12;
    private final LimeTableColumn SPAM_COLUMN = new SearchColumn(12, "RESULT_PANEL_SPAM", 40, false, Float.class);
    static final int DEFAULT_COLUMN_COUNT = 12;
    static final int EXTRA_COLUMN_COUNT;
    private final List EXTRA_COLUMNS = new ArrayList();
    static final int COLUMN_COUNT;

    SearchTableColumns() {
        SearchTableColumns.addColumns(this.EXTRA_COLUMNS);
    }

    private static void addColumns(List columns) {
        Collection schemas = LimeXMLSchemaRepository.instance().getAvailableSchemas();
        int idx = 12;
        Iterator i = schemas.iterator();
        while (i.hasNext()) {
            LimeXMLSchema schema = (LimeXMLSchema)i.next();
            Iterator fields = schema.getCanonicalizedFields().iterator();
            while (fields.hasNext()) {
                SchemaFieldInfo sfi = (SchemaFieldInfo)fields.next();
                if (sfi.isHidden()) continue;
                XMLSearchColumn ltc = new XMLSearchColumn(idx, sfi);
                columns.add(ltc);
                ++idx;
            }
        }
    }

    LimeTableColumn getColumn(int idx) {
        switch (idx) {
            case 0: {
                return this.QUALITY_COLUMN;
            }
            case 1: {
                return this.COUNT_COLUMN;
            }
            case 3: {
                return this.ICON_COLUMN;
            }
            case 4: {
                return this.NAME_COLUMN;
            }
            case 5: {
                return this.TYPE_COLUMN;
            }
            case 6: {
                return this.SIZE_COLUMN;
            }
            case 7: {
                return this.SPEED_COLUMN;
            }
            case 8: {
                return this.CHAT_COLUMN;
            }
            case 9: {
                return this.LOCATION_COLUMN;
            }
            case 10: {
                return this.VENDOR_COLUMN;
            }
            case 11: {
                return this.ADDED_COLUMN;
            }
            case 2: {
                return this.LICENSE_COLUMN;
            }
            case 12: {
                return this.SPAM_COLUMN;
            }
        }
        if (idx == -1 && SearchSettings.moveJunkToBottom()) {
            return this.QUALITY_COLUMN;
        }
        if (idx >= 12 && idx < COLUMN_COUNT) {
            return (LimeTableColumn)this.EXTRA_COLUMNS.get(idx - 12);
        }
        throw new IllegalStateException("illegal idx: " + idx);
    }

    static {
        LinkedList columns = new LinkedList();
        SearchTableColumns.addColumns(columns);
        EXTRA_COLUMN_COUNT = columns.size();
        COLUMN_COUNT = EXTRA_COLUMN_COUNT + 12;
    }
}

