/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.statistics;

import com.limegroup.gnutella.gui.statistics.StatisticsPane;
import com.limegroup.gnutella.gui.statistics.StatisticsTreeModel;
import com.limegroup.gnutella.gui.statistics.StatisticsTreeSelectionListener;
import com.limegroup.gnutella.gui.trees.LimeTreeCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JScrollPane;
import javax.swing.JTree;

final class StatisticsTreeManager {
    private JScrollPane _scrollPane;
    private final StatisticsTreeModel TREE_MODEL = new StatisticsTreeModel();
    private final JTree TREE = new JTree();

    StatisticsTreeManager() {
        this.TREE.setCellRenderer(new LimeTreeCellRenderer());
        this.TREE.setEditable(false);
        this.TREE.setShowsRootHandles(true);
        this.TREE.setRootVisible(false);
        this.TREE.putClientProperty("JTree.lineStyle", "Angled");
        this.TREE.getSelectionModel().setSelectionMode(1);
        this.TREE.addTreeSelectionListener(new StatisticsTreeSelectionListener(this.TREE));
        this.TREE.setModel(this.TREE_MODEL.getTreeModel());
        this._scrollPane = new JScrollPane(this.TREE);
        this._scrollPane.getViewport().setBackground(Color.white);
        this._scrollPane.setPreferredSize(new Dimension(125, 2000));
        this._scrollPane.setMinimumSize(new Dimension(125, 300));
    }

    void advancedSize() {
        this._scrollPane.setPreferredSize(new Dimension(200, 2000));
        this._scrollPane.setMinimumSize(new Dimension(200, 300));
    }

    void defaultSize() {
        this._scrollPane.setPreferredSize(new Dimension(125, 2000));
        this._scrollPane.setMinimumSize(new Dimension(125, 300));
    }

    void addNode(String parentKey, StatisticsPane pane) {
        this.TREE_MODEL.addNode(parentKey, pane);
    }

    Component getComponent() {
        return this._scrollPane;
    }

    void removeAllChildren(String parentKey) {
        this.TREE_MODEL.removeAllChildren(parentKey);
    }

    JTree getTree() {
        return this.TREE;
    }
}

