/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.statistics.panes;

import com.limegroup.gnutella.gui.statistics.StatisticsMediator;
import com.limegroup.gnutella.gui.statistics.panes.GraphAxisData;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;

final class GraphBorder
extends AbstractBorder {
    private static final int OFFSET = 30;
    private final int NUM_X_TICKS;
    private final GraphAxisData DATA;

    GraphBorder(GraphAxisData data) {
        this.DATA = data;
        this.NUM_X_TICKS = this.DATA.getTotalXValues() / this.DATA.getXIncrement();
    }

    public void paintBorder(Component comp, Graphics g, int x, int y, int width, int height) {
        int thickness = 2;
        int yVal = 0;
        int xVal = 0;
        int yBase = y + height - 30;
        JComponent component = StatisticsMediator.getStatDisplayComponent();
        int xAxisPixelLength = component.getWidth() - 30;
        int yAxisPixelLength = component.getHeight() - 30 - 60;
        for (int i = 0; i < thickness; ++i) {
            yVal = y + height - i - 30;
            g.drawLine(x + 30, yVal, xAxisPixelLength, yVal);
            xVal = x + i + 30;
            int yTop = yBase - yAxisPixelLength;
            g.drawLine(xVal, yTop, xVal, yBase);
        }
        Font oldFont = g.getFont();
        Font tempFont = new Font(oldFont.getName(), oldFont.getStyle(), oldFont.getSize() - 1);
        g.setFont(tempFont);
        this.drawHashedLineX(x + 30, yVal, g);
        this.drawHashedLineY(xVal, y, yBase, g);
        g.setFont(oldFont);
    }

    static int getOffset() {
        return 30;
    }

    private void drawHashedLineX(int x0, int y0, Graphics g) {
        int startY = y0 - 4;
        int endY = y0 + 4;
        double curX = x0;
        int xInc = this.DATA.getXIncrement();
        JComponent component = StatisticsMediator.getStatDisplayComponent();
        double drawingWidth = component.getWidth() - 30 - x0;
        double xVal = drawingWidth / (double)this.DATA.getTotalXValues();
        int num = this.DATA.getTotalXValues() / xInc + 1;
        for (int i = 0; i < num; ++i) {
            g.drawLine((int)curX, startY, (int)curX, endY);
            g.drawString(new Integer((this.NUM_X_TICKS - i) * xInc).toString(), (int)curX, startY + 20);
            curX += xVal * (double)xInc;
        }
        g.drawString(this.DATA.getXAxisLabel() + " vs. " + this.DATA.getYAxisLabel(), (int)(drawingWidth / 2.0 - 20.0), y0 + 30);
    }

    private void drawHashedLineY(int x0, int y0, int y1, Graphics g) {
        int startX = x0 - 4;
        int endX = x0 + 4;
        double curY = y1;
        int yInc = this.DATA.getYIncrement();
        JComponent component = StatisticsMediator.getStatDisplayComponent();
        double yVal = (double)(component.getHeight() - 30 - y0 - 60) / (double)this.DATA.getTotalYValues();
        double pixelJump = yVal * (double)yInc;
        int i = 0;
        int num = this.DATA.getTotalYValues() / yInc + 1;
        while (i < num) {
            g.drawLine(startX, (int)curY, endX, (int)curY);
            g.drawString(new Integer(i * yInc).toString(), startX - 20, (int)curY);
            ++i;
            curY -= pixelJump;
        }
    }
}

