/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.tables.DataLineModel;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class BasicDataLineModel
extends AbstractTableModel
implements DataLineModel {
    protected List _list = new ArrayList();
    private static final int ASCENDING = 1;
    private static final int DESCENDING = -1;
    protected int _ascending = 1;
    protected int _activeColumn = -1;
    private final Class _dataLineClass;
    private final DataLine _internalDataLine;
    protected boolean _isSorted = false;

    public BasicDataLineModel(Class dataLineClass) {
        this._dataLineClass = dataLineClass;
        this._internalDataLine = this.createDataLine();
    }

    public String[] getToolTipArray(int row, int col) {
        return ((DataLine)this._list.get(row)).getToolTipArray(col);
    }

    public boolean isTooltipRequired(int row, int col) {
        return ((DataLine)this._list.get(row)).isTooltipRequired(col);
    }

    public boolean isSortAscending() {
        return this._ascending == 1;
    }

    public int getSortColumn() {
        return this._activeColumn;
    }

    public boolean isSorted() {
        return this._isSorted;
    }

    public void sort(int col) {
        if (col == this._activeColumn) {
            if (this._ascending == -1) {
                this.unsort();
                return;
            }
            this._ascending = -1;
        } else {
            this._ascending = 1;
            this._activeColumn = col;
        }
        this._isSorted = true;
        this.resort();
    }

    public void resort() {
        if (this._isSorted) {
            this.doResort();
            this.fireTableDataChanged();
        }
    }

    public void unsort() {
        this._isSorted = false;
        this._activeColumn = -1;
    }

    protected void doResort() {
        Collections.sort(this._list, this);
    }

    public boolean needsResort() {
        return this._isSorted && this._internalDataLine.isDynamic(this._activeColumn);
    }

    public void clear() {
        this.cleanup();
        this._list.clear();
        this.fireTableDataChanged();
    }

    protected void cleanup() {
        int end = this._list.size();
        for (int i = 0; i < end; ++i) {
            ((DataLine)this._list.get(i)).cleanup();
        }
    }

    public Object refresh() {
        int end = this._list.size();
        for (int i = 0; i < end; ++i) {
            ((DataLine)this._list.get(i)).update();
        }
        this.fireTableRowsUpdated(0, end);
        return null;
    }

    public int update(Object o) {
        int row = this.getRow(o);
        ((DataLine)this._list.get(row)).update();
        this.fireTableRowsUpdated(row, row);
        return row;
    }

    public DataLine createDataLine() {
        try {
            DataLine dl = (DataLine)this._dataLineClass.newInstance();
            return dl;
        }
        catch (IllegalAccessException e) {
            Assert.that(false, e.getMessage());
        }
        catch (InstantiationException e) {
            Assert.that(false, e.getMessage());
        }
        catch (ClassCastException e) {
            Assert.that(false, e.getMessage());
        }
        return null;
    }

    public DataLine getNewDataLine(Object o) {
        DataLine dl = this.createDataLine();
        dl.initialize(o);
        return dl;
    }

    public int getSortedPosition(DataLine dl) {
        int row = Collections.binarySearch(this._list, dl, this);
        if (row < 0) {
            row = -(row + 1);
        }
        return row;
    }

    public int add(Object o) {
        return this.add(o, 0);
    }

    public int add(Object o, int row) {
        DataLine dl = this.getNewDataLine(o);
        return dl == null ? -1 : this.add(dl, row);
    }

    public int add(DataLine dl) {
        return this.add(dl, 0);
    }

    public int add(DataLine dl, int row) {
        this._list.add(row, dl);
        this.fireTableRowsInserted(row, row);
        return row;
    }

    public int addSorted(Object o) {
        DataLine dl = this.getNewDataLine(o);
        return dl == null ? -1 : this.add(dl, this.getSortedPosition(dl));
    }

    public int addSorted(DataLine dl) {
        return this.add(dl, this.getSortedPosition(dl));
    }

    public DataLine get(int row) {
        return (DataLine)this._list.get(row);
    }

    public DataLine get(Object o) {
        int row = this.getRow(o);
        if (row != -1) {
            return (DataLine)this._list.get(row);
        }
        return null;
    }

    public DataLine get(Object o, int col) {
        int row = this.getRow(o, col);
        if (row != -1) {
            return (DataLine)this._list.get(row);
        }
        return null;
    }

    public void remove(int row) {
        ((DataLine)this._list.get(row)).cleanup();
        this._list.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void remove(DataLine line) {
        int idx = this._list.indexOf(line);
        if (idx != -1) {
            this.remove(idx);
        }
    }

    public void remove(Object o) {
        int end = this._list.size();
        for (int i = 0; i < end; ++i) {
            if (!((DataLine)this._list.get(i)).getInitializeObject().equals(o)) continue;
            this.remove(i);
            break;
        }
    }

    public Object getValueAt(int row, int col) {
        return ((DataLine)this._list.get(row)).getValueAt(col);
    }

    public void setValueAt(Object o, int row, int col) {
        if (row >= 0 && row < this._list.size()) {
            ((DataLine)this._list.get(row)).setValueAt(o, col);
            this.fireTableRowsUpdated(row, row);
        }
    }

    public boolean contains(Object o, int col) {
        int end = this._list.size();
        for (int i = 0; i < end; ++i) {
            if (!((DataLine)this._list.get(i)).getValueAt(col).equals(o)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Object o) {
        int end = this._list.size();
        for (int i = 0; i < end; ++i) {
            if (!((DataLine)this._list.get(i)).getInitializeObject().equals(o)) continue;
            return true;
        }
        return false;
    }

    public int getRow(DataLine dl) {
        return this._list.indexOf(dl);
    }

    public int getRow(Object o, int col) {
        int end = this._list.size();
        for (int i = 0; i < end; ++i) {
            if (!((DataLine)this._list.get(i)).getValueAt(col).equals(o)) continue;
            return i;
        }
        return -1;
    }

    public int getRow(Object o) {
        int end = this._list.size();
        for (int i = 0; i < end; ++i) {
            if (!((DataLine)this._list.get(i)).getInitializeObject().equals(o)) continue;
            return i;
        }
        return -1;
    }

    public int compare(Object a, Object b) {
        Object o1 = ((DataLine)a).getValueAt(this._activeColumn);
        Object o2 = ((DataLine)b).getValueAt(this._activeColumn);
        return AbstractTableMediator.compare(o1, o2) * this._ascending;
    }

    public LimeTableColumn getTableColumn(int col) {
        if (this._internalDataLine == null) {
            return null;
        }
        return this._internalDataLine.getColumn(col);
    }

    public int getRowCount() {
        return this._list.size();
    }

    public int getColumnCount() {
        if (this._internalDataLine == null) {
            return 0;
        }
        return this._internalDataLine.getColumnCount();
    }

    public boolean isClippable(int col) {
        if (this._internalDataLine == null) {
            return false;
        }
        return this._internalDataLine.isClippable(col);
    }

    public int getTypeAheadColumn() {
        if (this._internalDataLine == null) {
            return -1;
        }
        return this._internalDataLine.getTypeAheadColumn();
    }

    public String getColumnName(int col) {
        return this.getTableColumn(col).getName();
    }

    public Object getColumnId(int col) {
        return this.getTableColumn(col).getIdentifier();
    }

    public Class getColumnClass(int col) {
        return this.getTableColumn(col).getColumnClass();
    }
}

