/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.JMultilineToolTip;
import com.limegroup.gnutella.gui.tables.ColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.tables.DataLineModel;
import com.limegroup.gnutella.gui.tables.EventListenerProxy;
import com.limegroup.gnutella.gui.tables.JSortTable;
import com.limegroup.gnutella.gui.tables.LastColumnException;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.util.DataUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Position;

public final class LimeJTable
extends JTable
implements JSortTable {
    protected Map _hiddenColumns = new HashMap();
    protected int pressedColumnIndex = -1;
    private String[] tips;
    private final String[] CLIPPED_TIP = new String[1];
    private static LimeTableColumn _lastRemoved;
    protected ColumnPreferenceHandler columnPreferences;
    protected TableSettings tableSettings;
    protected boolean mouseEventsProxied = false;

    public LimeJTable() {
        this.setToolTipText("");
        GUIUtils.fixInputMap(this);
        this.addFocusListener(FocusHandler.INSTANCE);
    }

    public LimeJTable(DataLineModel dm) {
        super(dm);
        this.setToolTipText("");
        GUIUtils.fixInputMap(this);
        this.addFocusListener(FocusHandler.INSTANCE);
    }

    public boolean isManagingFocus() {
        return false;
    }

    public void setSelectedRow(int row) {
        this.clearSelection();
        this.addRowSelectionInterval(row, row);
    }

    public DataLine getSelectedDataLine() {
        int selected = this.getSelectedRow();
        if (selected != -1) {
            return ((DataLineModel)this.dataModel).get(selected);
        }
        return null;
    }

    public int getSelectedRow() {
        int selected = super.getSelectedRow();
        if (selected >= this.dataModel.getRowCount()) {
            return -1;
        }
        return selected;
    }

    public DataLine[] getSelectedDataLines() {
        int[] selected = this.getSelectedRows();
        if (selected == null || selected.length == 0) {
            return new DataLine[0];
        }
        DataLine[] ret = new DataLine[selected.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ((DataLineModel)this.dataModel).get(selected[i]);
        }
        return ret;
    }

    public int[] getSelectedRows() {
        int[] selected = super.getSelectedRows();
        if (selected == null || selected.length == 0) {
            return selected;
        }
        Arrays.sort(selected);
        int tableSize = this.dataModel.getRowCount();
        for (int i = 0; i < selected.length; ++i) {
            if (selected[i] < tableSize) continue;
            int[] newData = new int[i];
            System.arraycopy(selected, 0, newData, 0, i);
            return newData;
        }
        return selected;
    }

    public void ensureSelectionVisible() {
        this.ensureRowVisible(this.getSelectedRow());
    }

    public void ensureRowVisible(int row) {
        if (row != -1) {
            Rectangle cellRect = this.getCellRect(row, 0, false);
            Rectangle visibleRect = this.getVisibleRect();
            if (!visibleRect.intersects(cellRect)) {
                this.scrollRectToVisible(cellRect);
            }
        }
    }

    public boolean isSelectionVisible() {
        return this.isRowVisible(this.getSelectedRow());
    }

    public boolean isRowVisible(int row) {
        if (row != -1) {
            Rectangle cellRect = this.getCellRect(row, 0, false);
            Rectangle visibleRect = this.getVisibleRect();
            return visibleRect.intersects(cellRect);
        }
        return false;
    }

    public ColumnPreferenceHandler getColumnPreferenceHandler() {
        return this.columnPreferences;
    }

    public void setColumnPreferenceHandler(ColumnPreferenceHandler handl) {
        this.columnPreferences = handl;
    }

    public TableSettings getTableSettings() {
        return this.tableSettings;
    }

    public void setTableSettings(TableSettings settings) {
        this.tableSettings = settings;
    }

    public void setPressedColumnIndex(int col) {
        this.pressedColumnIndex = col;
    }

    public int getPressedColumnIndex() {
        return this.convertColumnIndexToView(this.pressedColumnIndex);
    }

    public int getSortedColumnIndex() {
        return this.convertColumnIndexToView(((DataLineModel)this.dataModel).getSortColumn());
    }

    public boolean isSortedColumnAscending() {
        return ((DataLineModel)this.dataModel).isSortAscending();
    }

    public void setColumnVisible(Object columnId, boolean visible) throws LastColumnException {
        if (!visible) {
            TableColumnModel model = this.getColumnModel();
            if (model.getColumnCount() == 1) {
                throw new LastColumnException();
            }
            TableColumn column = model.getColumn(model.getColumnIndex(columnId));
            this._hiddenColumns.put(columnId, column);
            _lastRemoved = (LimeTableColumn)column;
            this.removeColumn(column);
        } else {
            TableColumn column = (TableColumn)this._hiddenColumns.get(columnId);
            this._hiddenColumns.remove(columnId);
            this.addColumn(column);
        }
    }

    public Iterator getHiddenColumns() {
        return Collections.unmodifiableCollection(this._hiddenColumns.values()).iterator();
    }

    public LimeTableColumn getLastRemovedColumn() {
        return _lastRemoved;
    }

    public boolean isColumnVisible(Object columnId) {
        return !this._hiddenColumns.containsKey(columnId);
    }

    public boolean isPointSelected(Point p) {
        int row = this.rowAtPoint(p);
        int col = this.columnAtPoint(p);
        if (row == -1 || col == -1) {
            return false;
        }
        int[] sel = this.getSelectedRows();
        for (int i = 0; i < sel.length; ++i) {
            if (sel[i] != row) continue;
            return true;
        }
        return false;
    }

    public boolean isMouseEventsProxied() {
        return this.mouseEventsProxied;
    }

    public void setMouseEventsProxied(boolean proxy) {
        this.mouseEventsProxied = proxy;
    }

    public void processMouseEvent(MouseEvent e) {
        try {
            int index;
            TableModel model;
            super.processMouseEvent(e);
            if (e.getID() == 500 && SwingUtilities.isLeftMouseButton(e) && (model = this.getModel()) != null && ((index = this.rowAtPoint(e.getPoint())) < 0 || index >= model.getRowCount())) {
                this.clearSelection();
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            String msg = aioobe.getMessage();
            if (msg != null && msg.indexOf("at javax.swing.MenuSelectionManager.processMouseEvent") != -1) {
                return;
            }
            throw aioobe;
        }
    }

    public void removeMouseListener(MouseListener ml) {
        if (!this.mouseEventsProxied) {
            super.removeMouseListener(ml);
            return;
        }
        EventListener[] oldListeners = this.getListeners(MouseListener.class);
        super.removeMouseListener(ml);
        EventListener[] newListeners = this.getListeners(MouseListener.class);
        if (oldListeners.length == newListeners.length) {
            for (int i = 0; i < oldListeners.length; ++i) {
                EventListener current = oldListeners[i];
                if (!(current instanceof EventListenerProxy) || !((EventListenerProxy)((Object)current)).isProxyFor(ml)) continue;
                super.removeMouseListener((MouseListener)current);
                return;
            }
        }
    }

    public void removeMouseMotionListener(MouseMotionListener ml) {
        if (!this.mouseEventsProxied) {
            super.removeMouseMotionListener(ml);
            return;
        }
        EventListener[] oldListeners = this.getListeners(MouseMotionListener.class);
        super.removeMouseMotionListener(ml);
        EventListener[] newListeners = this.getListeners(MouseMotionListener.class);
        if (oldListeners.length == newListeners.length) {
            for (int i = 0; i < oldListeners.length; ++i) {
                EventListener current = oldListeners[i];
                if (!(current instanceof EventListenerProxy) || !((EventListenerProxy)((Object)current)).isProxyFor(ml)) continue;
                super.removeMouseMotionListener((MouseMotionListener)current);
                return;
            }
        }
    }

    public String getToolTipText(MouseEvent e) {
        boolean forceTooltip;
        Point p = e.getPoint();
        int row = this.rowAtPoint(p);
        int col = this.columnAtPoint(p);
        int colModel = this.convertColumnIndexToModel(col);
        DataLineModel dlm = (DataLineModel)this.dataModel;
        boolean isClippable = col > -1 && row > -1 ? dlm.isClippable(colModel) : false;
        boolean bl = forceTooltip = col > -1 && row > -1 ? dlm.isTooltipRequired(row, col) : false;
        if (!this.tableSettings.DISPLAY_TOOLTIPS.getValue() && !forceTooltip) {
            if (isClippable) {
                return this.clippedToolTip(row, col, colModel);
            }
            return null;
        }
        if (row > -1) {
            this.tips = dlm.getToolTipArray(row, colModel);
            if (this.tips == null) {
                if (isClippable) {
                    return this.clippedToolTip(row, col, colModel);
                }
                return null;
            }
            return dlm.get(row).toString() + col;
        }
        this.tips = DataUtils.EMPTY_STRING_ARRAY;
        return null;
    }

    private String clippedToolTip(int row, int col, int colModel) {
        int dataWidth;
        TableColumn tc = this.getColumnModel().getColumn(col);
        int columnWidth = tc.getWidth();
        if (columnWidth < (dataWidth = this.getDataWidth(row, colModel))) {
            this.tips = this.CLIPPED_TIP;
            return ((DataLineModel)this.dataModel).get(row).toString() + col;
        }
        this.tips = DataUtils.EMPTY_STRING_ARRAY;
        return null;
    }

    private int getDataWidth(int row, int col) {
        String info;
        DataLineModel dlm = (DataLineModel)this.dataModel;
        DataLine dl = dlm.get(row);
        Object data = dl.getValueAt(col);
        if (data != null && (info = data.toString()) != null) {
            this.CLIPPED_TIP[0] = info;
            TableCellRenderer tcr = this.getDefaultRenderer(dlm.getColumnClass(col));
            JComponent renderer = (JComponent)tcr.getTableCellRendererComponent(this, data, false, false, row, col);
            try {
                FontMetrics fm = renderer.getFontMetrics(renderer.getFont());
                return fm.stringWidth(info) + 3;
            }
            catch (NullPointerException npe) {
                return -1;
            }
        }
        return -1;
    }

    public JToolTip createToolTip() {
        JMultilineToolTip ret = JMultilineToolTip.instance();
        ret.setToolTipArray(this.tips);
        this.tips = DataUtils.EMPTY_STRING_ARRAY;
        return ret;
    }

    public void createDefaultColumnsFromModel() {
        DataLineModel dlm = (DataLineModel)this.dataModel;
        if (dlm != null) {
            TableColumnModel cm = this.getColumnModel();
            while (cm.getColumnCount() > 0) {
                cm.removeColumn(cm.getColumn(0));
            }
            for (int i = 0; i < dlm.getColumnCount(); ++i) {
                LimeTableColumn newColumn = dlm.getTableColumn(i);
                this.addColumn(newColumn);
            }
        }
    }

    public Color getBackgroundForRow(int row) {
        if (row % 2 == 0 || !this.tableSettings.ROWSTRIPE.getValue()) {
            return this.getBackground();
        }
        return ThemeFileHandler.TABLE_ALTERNATE_COLOR.getValue();
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        if (renderer == null) {
            throw new IllegalStateException("null renderer, row: " + row + ", column: " + column + ", id: " + this.tableSettings.getID() + ", columnId: " + this.getColumnModel().getColumn(column));
        }
        Object value = this.getValueAt(row, column);
        boolean isSelected = this.isCellSelected(row, column);
        boolean rowIsAnchor = this.selectionModel.getAnchorSelectionIndex() == row;
        boolean colIsAnchor = this.columnModel.getSelectionModel().getAnchorSelectionIndex() == column;
        boolean hasFocus = rowIsAnchor && colIsAnchor && this.hasFocus();
        Component r = renderer.getTableCellRendererComponent(this, value, isSelected, hasFocus, row, column);
        Color odd = ThemeFileHandler.TABLE_ALTERNATE_COLOR.getValue();
        Color even = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
        if (!(isSelected || hasFocus && this.isCellEditable(row, column) || even.equals(odd))) {
            if (!this.tableSettings.ROWSTRIPE.getValue()) {
                if (r != null && !r.equals(even)) {
                    r.setBackground(even);
                }
            } else if (row % 2 != 0) {
                r.setBackground(odd);
            } else {
                r.setBackground(even);
            }
        }
        return r;
    }

    public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
        DataLineModel model = (DataLineModel)this.dataModel;
        int max = model.getRowCount();
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (startIndex < 0 || startIndex >= max) {
            throw new IllegalArgumentException();
        }
        prefix = prefix.toUpperCase();
        int increment = bias == Position.Bias.Forward ? 1 : -1;
        int index = startIndex;
        int typeAheadColumn = model.getTypeAheadColumn();
        if (typeAheadColumn >= 0 && typeAheadColumn < model.getColumnCount()) {
            do {
                String string;
                Object o;
                if ((o = model.getValueAt(index, typeAheadColumn)) == null) continue;
                if (o instanceof String) {
                    string = ((String)o).toUpperCase();
                } else {
                    string = o.toString();
                    if (string != null) {
                        string = string.toUpperCase();
                    }
                }
                if (string == null || !string.startsWith(prefix)) continue;
                return index;
            } while ((index = (index + increment + max) % max) != startIndex);
        }
        return -1;
    }

    public boolean getScrollableTracksViewportHeight() {
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            return parent.getHeight() > this.getPreferredSize().height;
        }
        return super.getScrollableTracksViewportHeight();
    }

    public void paint(Graphics g) {
        Border rowBorder;
        super.paint(g);
        int focusedRow = this.getFocusedRow(true);
        if (focusedRow != -1 && focusedRow < this.getRowCount() && (rowBorder = UIManager.getBorder("Table.focusRowHighlightBorder")) != null) {
            Rectangle rect = this.getCellRect(focusedRow, 0, true);
            rect.width = this.getWidth();
            rowBorder.paintBorder(this, g, rect.x, rect.y, rect.width, rect.height);
        }
    }

    private void repaintFocusedRow() {
        int focusedRow = this.getFocusedRow(false);
        if (focusedRow != -1 && focusedRow < this.getRowCount()) {
            Rectangle rect = this.getCellRect(focusedRow, 0, true);
            rect.width = this.getWidth();
            this.repaint(rect);
        }
    }

    private int getFocusedRow(boolean requireFocus) {
        if (!requireFocus || this.hasFocus()) {
            return this.selectionModel.getAnchorSelectionIndex();
        }
        return -1;
    }

    private static class FocusHandler
    implements FocusListener {
        private static final FocusListener INSTANCE = new FocusHandler();

        private FocusHandler() {
        }

        public void focusGained(FocusEvent e) {
            LimeJTable t = (LimeJTable)e.getSource();
            t.repaintFocusedRow();
        }

        public void focusLost(FocusEvent e) {
            LimeJTable t = (LimeJTable)e.getSource();
            t.repaintFocusedRow();
        }
    }
}

