/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.tables.SortHeaderRenderer;
import javax.swing.Icon;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class LimeTableColumn
extends TableColumn {
    public static final TableCellRenderer HEADER_RENDERER = new SortHeaderRenderer();
    public static final TableCellRenderer INVIS_RENDERER;
    private final boolean defaultVisibility;
    private final int defaultWidth;
    private final String messageId;
    private final String name;
    private final Icon icon;
    private final Class clazz;
    private boolean initialized = true;

    public String toString() {
        return this.messageId;
    }

    public LimeTableColumn(int model, String id, int width, boolean vis, Class clazz) {
        this(model, id, GUIMediator.getStringResource(id), width, vis, clazz);
    }

    public LimeTableColumn(int model, String id, Icon icon, int width, boolean vis, Class clazz) {
        this(model, id, GUIMediator.getStringResource(id), icon, width, vis, clazz);
    }

    public LimeTableColumn(int model, String id, String name, int width, boolean vis, Class clazz) {
        this(model, id, name, null, width, vis, clazz);
    }

    public LimeTableColumn(int model, String id, String name, Icon icon, int width, boolean vis, Class clazz) {
        super(model);
        this.defaultVisibility = vis;
        this.defaultWidth = width;
        if (this.defaultWidth != -1) {
            super.setPreferredWidth(width);
        }
        this.messageId = id;
        super.setIdentifier(id);
        this.name = name;
        this.icon = icon;
        this.clazz = clazz;
        this.setHeaderVisible(true);
    }

    public LimeTableColumn setHeaderVisible(boolean vis) {
        if (vis) {
            super.setHeaderRenderer(HEADER_RENDERER);
            if (this.icon != null) {
                super.setHeaderValue(this.icon);
            } else if (this.name != null) {
                super.setHeaderValue(this.name);
            } else {
                super.setHeaderValue("");
            }
        } else {
            super.setHeaderRenderer(INVIS_RENDERER);
            super.setHeaderValue("");
        }
        return this;
    }

    public boolean getDefaultVisibility() {
        return this.defaultVisibility;
    }

    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    public int getDefaultOrder() {
        return this.getModelIndex();
    }

    public String getName() {
        return this.name;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Class getColumnClass() {
        return this.clazz;
    }

    public String getId() {
        return this.messageId;
    }

    public void setModelIndex(int idx) {
        if (!this.initialized) {
            return;
        }
        throw new IllegalStateException("cannot change model index");
    }

    public void setHeaderValue(Object val) {
        if (!this.initialized) {
            return;
        }
        throw new IllegalStateException("cannot change header value");
    }

    public void setIdentifier(Object id) {
        if (!this.initialized) {
            return;
        }
        throw new IllegalStateException("cannot change id");
    }

    static {
        SortHeaderRenderer rnd = new SortHeaderRenderer();
        rnd.setAllowIcon(false);
        INVIS_RENDERER = rnd;
    }
}

