/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.EventListenerProxy;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;

public final class MouseEventConsumptionChecker {
    private MouseEventConsumptionChecker() {
    }

    public static MouseMotionListener proxy(MouseMotionListener mml) {
        return new MouseMotionProxy(mml);
    }

    public static MouseListener proxy(MouseListener ml) {
        return new MouseProxy(ml);
    }

    private static class MouseProxy
    implements MouseListener,
    EventListenerProxy {
        private final MouseListener delegate;

        MouseProxy(MouseListener ml) {
            this.delegate = ml;
        }

        public boolean isProxyFor(EventListener el) {
            return this.delegate == el;
        }

        public void mouseClicked(MouseEvent e) {
            this.delegate.mouseClicked(e);
        }

        public void mouseEntered(MouseEvent e) {
            this.delegate.mouseEntered(e);
        }

        public void mouseExited(MouseEvent e) {
            this.delegate.mouseExited(e);
        }

        public void mousePressed(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            this.delegate.mousePressed(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.delegate.mouseReleased(e);
        }
    }

    private static class MouseMotionProxy
    implements MouseMotionListener,
    EventListenerProxy {
        private final MouseMotionListener delegate;

        MouseMotionProxy(MouseMotionListener mml) {
            this.delegate = mml;
        }

        public boolean isProxyFor(EventListener el) {
            return this.delegate == el;
        }

        public void mouseDragged(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            this.delegate.mouseDragged(e);
        }

        public void mouseMoved(MouseEvent e) {
            this.delegate.mouseMoved(e);
        }
    }
}

